/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.IContainerDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2Cache;

public class H2ContainerDao
implements IContainerDao {
    private static final String Q_INSERT = "INSERT INTO CONTAINERS(PATH) VALUES(?);";
    private static final String Q_SELECT_BY_PATH = "SELECT * FROM CONTAINERS WHERE PATH=?;";
    private static final String Q_SELECT_BY_ID = "SELECT * FROM CONTAINERS WHERE ID=?;";
    private static final String Q_DELETE_BY_PATH = "DELETE FROM CONTAINERS WHERE PATH=?;";
    private static final String Q_DELETE_BY_ID = "DELETE FROM CONTAINERS WHERE ID=?;";

    public Container insert(Connection connection, String path) throws SQLException {
        Container container = this.selectByPath(connection, path);
        if (container != null) {
            return container;
        }
        PreparedStatement statement = connection.prepareStatement(Q_INSERT, 1);
        try {
            int param = 0;
            statement.setString(++param, path);
            statement.executeUpdate();
            ResultSet result = statement.getGeneratedKeys();
            try {
                result.next();
                container = new Container(result.getInt(1), path);
                H2Cache.addContainer(container);
            }
            finally {
                result.close();
            }
        }
        finally {
            statement.close();
        }
        return container;
    }

    public Container selectByPath(Connection connection, String path) throws SQLException {
        Container container = H2Cache.selectContainerByPath(path);
        if (container != null) {
            return container;
        }
        PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_PATH, 1);
        try {
            int param = 0;
            statement.setString(++param, path);
            ResultSet result = statement.executeQuery();
            try {
                if (result.next()) {
                    container = new Container(result.getInt(1), result.getString(2));
                    H2Cache.addContainer(container);
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            statement.close();
        }
        return container;
    }

    public Container selectById(Connection connection, int id) throws SQLException {
        Container container = H2Cache.selectContainerById(id);
        if (container != null) {
            return container;
        }
        PreparedStatement statement = connection.prepareStatement(Q_SELECT_BY_ID, 1);
        try {
            int param = 0;
            statement.setInt(++param, id);
            ResultSet result = statement.executeQuery();
            try {
                if (result.next()) {
                    container = new Container(result.getInt(1), result.getString(2));
                    H2Cache.addContainer(container);
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            statement.close();
        }
        return container;
    }

    public void deleteById(Connection connection, int id) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_ID, 1);
        try {
            int param = 0;
            statement.setInt(++param, id);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
        H2Cache.deleteContainerById(id);
    }

    public void deleteByPath(Connection connection, String path) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(Q_DELETE_BY_PATH, 1);
        try {
            int param = 0;
            statement.setString(++param, path);
            statement.executeUpdate();
        }
        finally {
            statement.close();
        }
        H2Cache.deleteContainerByPath(path);
    }
}

