/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IProjectFragmentTimestamp;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuildpathChange;
import org.eclipse.dltk.internal.core.BuildpathValidation;
import org.eclipse.dltk.internal.core.DeltaProcessingState;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElementDelta;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelUpdater;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ProjectElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragmentInfo;
import org.eclipse.dltk.internal.core.ProjectReferenceChange;
import org.eclipse.dltk.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.builder.ScriptBuilder;
import org.eclipse.dltk.internal.core.search.DLTKWorkspaceScope;
import org.eclipse.dltk.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaProcessor {
    private static final int NON_SCRIPT_RESOURCE = -1;
    public static boolean DEBUG = false;
    public static boolean VERBOSE = false;
    public static boolean PERF = false;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private ISourceElementParser sourceElementParserCache;
    private SourceIndexerRequestor sourceRequestorCache;
    private DeltaProcessingState state;
    ModelManager manager;
    private ModelElementDelta currentDelta;
    private Openable currentElement;
    public ArrayList<IModelElementDelta> modelDeltas = new ArrayList();
    public HashMap reconcileDeltas = new HashMap();
    private boolean isFiring = true;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    private HashSet<IScriptProject> projectCachesToReset = new HashSet();
    public Map<IScriptProject, IProjectFragment[]> oldRoots;
    private HashSet<IScriptProject> rootsToRefresh = new HashSet();
    private final ArrayList<Runnable> postActions = new ArrayList();
    public int overridenEventType = -1;

    public static long getTimeStamp(IFileHandle file) {
        long lmodif = 0L;
        lmodif = file.lastModified();
        return lmodif + file.length();
    }

    public DeltaProcessor(DeltaProcessingState state, ModelManager manager) {
        this.state = state;
        this.manager = manager;
    }

    private void addDependentProjects(IScriptProject project, HashMap projectDependencies, HashSet result) {
        IScriptProject[] dependents = (IScriptProject[])projectDependencies.get(project);
        if (dependents == null) {
            return;
        }
        int i = 0;
        int length = dependents.length;
        while (i < length) {
            IScriptProject dependent = dependents[i];
            if (!result.contains(dependent)) {
                result.add(dependent);
                this.addDependentProjects(dependent, projectDependencies, result);
            }
            ++i;
        }
    }

    private void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                ModelElementInfo info = (ModelElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    private void addToRootsToRefreshWithDependents(IScriptProject scriptProject) {
        this.rootsToRefresh.add(scriptProject);
        this.addDependentProjects(scriptProject, this.state.projectDependencies, this.rootsToRefresh);
    }

    public void checkExternalChanges(IModelElement[] elementsToRefresh, IProgressMonitor monitor) throws ModelException {
        block14: {
            try {
                boolean hasDelta;
                block16: {
                    block15: {
                        int i = 0;
                        int length = elementsToRefresh.length;
                        while (i < length) {
                            this.state.addForRefresh(elementsToRefresh[i]);
                            ++i;
                        }
                        hasDelta = false;
                        Set<IModelElement> refreshedElementsCopy = this.state.removeExternalElementsToRefresh();
                        if (refreshedElementsCopy == null) break block15;
                        hasDelta = this.createExternalArchiveDelta(refreshedElementsCopy, null);
                        hasDelta |= this.createCustomElementDelta(null, refreshedElementsCopy);
                        if (monitor == null || !monitor.isCanceled()) break block16;
                    }
                    return;
                }
                if (!hasDelta) break block14;
                Model.flushExternalFileCache();
                ModelManager.getModelManager().resetZIPTypeCache();
                IModelElementDelta[] projectDeltas = this.currentDelta.getAffectedChildren();
                final int length = projectDeltas.length;
                final IProject[] projectsToTouch = new IProject[length];
                int i = 0;
                while (i < length) {
                    IModelElementDelta delta = projectDeltas[i];
                    ScriptProject scriptProject = (ScriptProject)delta.getElement();
                    projectsToTouch[i] = scriptProject.getProject();
                    ++i;
                }
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        int i = 0;
                        while (i < length) {
                            IProject project = projectsToTouch[i];
                            if (DLTKCore.DEBUG) {
                                System.out.println("Touching project " + project.getName() + " due to external jar file change");
                            }
                            project.touch(progressMonitor);
                            ++i;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable, monitor);
                }
                catch (CoreException e) {
                    throw new ModelException(e);
                }
                if (this.currentDelta != null) {
                    this.fire(this.currentDelta, 0);
                }
            }
            finally {
                this.currentDelta = null;
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    private void checkProjectsBeingAddedOrRemoved(IResourceDelta delta) {
        IResource resource = delta.getResource();
        IResourceDelta[] children = null;
        switch (resource.getType()) {
            case 8: {
                this.state.getOldScriptProjectNames();
                children = delta.getAffectedChildren();
                break;
            }
            case 4: {
                IProject project = (IProject)resource;
                ScriptProject scriptProject = (ScriptProject)DLTKCore.create(project);
                switch (delta.getKind()) {
                    case 1: {
                        this.manager.batchContainerInitializations = true;
                        this.addToRootsToRefreshWithDependents(scriptProject);
                        if (DLTKLanguageManager.hasScriptNature(project)) {
                            this.addToParentInfo(scriptProject);
                            this.readRawBuildpath(scriptProject);
                            this.checkProjectReferenceChange(project, scriptProject);
                        }
                        this.state.rootsAreStale = true;
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x4000) != 0) {
                            this.manager.batchContainerInitializations = true;
                            this.addToRootsToRefreshWithDependents(scriptProject);
                            if (project.isOpen()) {
                                if (DLTKLanguageManager.hasScriptNature(project)) {
                                    this.addToParentInfo(scriptProject);
                                    this.readRawBuildpath(scriptProject);
                                    this.checkProjectReferenceChange(project, scriptProject);
                                }
                            } else {
                                try {
                                    scriptProject.close();
                                }
                                catch (ModelException modelException) {}
                                this.removeFromParentInfo(scriptProject);
                                this.manager.removePerProjectInfo(scriptProject);
                                this.manager.containerRemove(scriptProject);
                            }
                            this.state.rootsAreStale = true;
                            break;
                        }
                        if ((delta.getFlags() & 0x80000) != 0) {
                            boolean isScriptProject;
                            boolean wasScriptProject = this.state.findProject(project.getName()) != null;
                            if (wasScriptProject != (isScriptProject = DLTKLanguageManager.hasScriptNature(project))) {
                                this.manager.batchContainerInitializations = true;
                                this.addToRootsToRefreshWithDependents(scriptProject);
                                if (isScriptProject) {
                                    this.addToParentInfo(scriptProject);
                                    this.readRawBuildpath(scriptProject);
                                    this.checkProjectReferenceChange(project, scriptProject);
                                } else {
                                    this.manager.removePerProjectInfo(scriptProject);
                                    this.manager.containerRemove(scriptProject);
                                    try {
                                        scriptProject.close();
                                    }
                                    catch (ModelException modelException) {}
                                    this.removeFromParentInfo(scriptProject);
                                }
                                this.state.rootsAreStale = true;
                                break;
                            }
                            if (!isScriptProject) break;
                            this.addToParentInfo(scriptProject);
                            children = delta.getAffectedChildren();
                            break;
                        }
                        if (!DLTKLanguageManager.hasScriptNature(project)) break;
                        this.addToParentInfo(scriptProject);
                        children = delta.getAffectedChildren();
                        break;
                    }
                    case 2: {
                        this.manager.batchContainerInitializations = true;
                        this.manager.removePerProjectInfo(scriptProject);
                        this.manager.containerRemove(scriptProject);
                        this.state.rootsAreStale = true;
                    }
                }
                this.state.addForRefresh(scriptProject);
                break;
            }
            case 1: {
                ScriptProject scriptProject;
                IFile file = (IFile)resource;
                if (!file.getName().equals(".buildpath")) break;
                this.manager.batchContainerInitializations = true;
                switch (delta.getKind()) {
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x100) == 0 && (flags & 0x100000) == 0 && (flags & 0x1000) == 0) break;
                    }
                    case 1: 
                    case 2: {
                        scriptProject = (ScriptProject)DLTKCore.create(file.getProject());
                        this.readRawBuildpath(scriptProject);
                    }
                }
                this.state.rootsAreStale = true;
            }
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.checkProjectsBeingAddedOrRemoved(children[i]);
                ++i;
            }
        }
    }

    private void checkProjectReferenceChange(IProject project, ScriptProject javaProject) {
        BuildpathChange change = this.state.getBuildpathChange(project);
        this.state.addProjectReferenceChange(javaProject, change == null ? null : change.oldResolvedBuildpath);
    }

    private void readRawBuildpath(ScriptProject javaProject) {
        block3: {
            try {
                ModelManager.PerProjectInfo perProjectInfo = javaProject.getPerProjectInfo();
                if (!perProjectInfo.writtingRawClasspath) {
                    perProjectInfo.readAndCacheBuildpath(javaProject);
                }
            }
            catch (ModelException e) {
                if (!VERBOSE) break block3;
                e.printStackTrace();
            }
        }
    }

    private void close(Openable element) {
        try {
            element.close();
        }
        catch (ModelException modelException) {}
    }

    private void contentChanged(Openable element) {
        boolean isPrimary = false;
        boolean isPrimaryWorkingCopy = false;
        if (element.getElementType() == 5) {
            SourceModule cu = (SourceModule)element;
            isPrimary = cu.isPrimary();
            boolean bl = isPrimaryWorkingCopy = isPrimary && cu.isWorkingCopy();
        }
        if (isPrimaryWorkingCopy) {
            this.currentDelta().changed(element, 262144);
        } else {
            this.close(element);
            int flags = 1;
            if (element instanceof ArchiveProjectFragment) {
                flags |= 0x8000;
                this.projectCachesToReset.add(element.getScriptProject());
            }
            if (isPrimary) {
                flags |= 0x40000;
            }
            this.currentDelta().changed(element, flags);
        }
    }

    private Openable createElement(IResource resource, int elementType, RootInfo rootInfo) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getFullPath();
        IModelElement element = null;
        switch (elementType) {
            case 2: {
                if (!(resource instanceof IProject)) break;
                this.popUntilPrefixOf(path);
                if (this.currentElement != null && this.currentElement.getElementType() == 2 && ((IScriptProject)((Object)this.currentElement)).getProject().equals((Object)resource)) {
                    return this.currentElement;
                }
                if (rootInfo != null && rootInfo.project.getProject().equals((Object)resource)) {
                    element = rootInfo.project;
                    break;
                }
                IProject proj = (IProject)resource;
                if (DLTKLanguageManager.hasScriptNature(proj)) {
                    element = DLTKCore.create(proj);
                    break;
                }
                element = this.state.findProject(proj.getName());
                break;
            }
            case 3: {
                element = rootInfo == null ? DLTKCore.create(resource) : rootInfo.getProjectFragment(resource);
                break;
            }
            case 4: {
                if (rootInfo != null) {
                    if (!rootInfo.project.contains(resource)) break;
                    IProjectFragment root = rootInfo.getProjectFragment(null);
                    IPath pkgPath = path.removeFirstSegments(rootInfo.rootPath.segmentCount());
                    element = root.getScriptFolder(pkgPath);
                    break;
                }
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = DLTKCore.create(resource);
                    break;
                }
                IProjectFragment root = this.currentElement.getProjectFragment();
                if (root == null) {
                    element = DLTKCore.create(resource);
                    break;
                }
                if (!((ScriptProject)root.getScriptProject()).contains(resource)) break;
                IPath pkgPath = path.removeFirstSegments(root.getPath().segmentCount());
                element = root.getScriptFolder(pkgPath);
                break;
            }
            case 5: 
            case 6: {
                this.popUntilPrefixOf(path);
                if (this.currentElement == null) {
                    element = rootInfo == null ? DLTKCore.create(resource) : ModelManager.create(resource, (IScriptProject)rootInfo.project);
                    break;
                }
                IScriptFolder pkgFragment = null;
                switch (this.currentElement.getElementType()) {
                    case 3: {
                        IProjectFragment root = (IProjectFragment)((Object)this.currentElement);
                        IPath rootPath = root.getPath();
                        IPath pkgPath = path.removeLastSegments(1);
                        IPath pkgName = pkgPath.removeFirstSegments(rootPath.segmentCount());
                        pkgFragment = root.getScriptFolder(pkgName);
                        break;
                    }
                    case 4: {
                        Openable pkg = this.currentElement;
                        if (!pkg.getPath().equals((Object)path.removeLastSegments(1))) break;
                        pkgFragment = (IScriptFolder)((Object)pkg);
                        break;
                    }
                    case 5: 
                    case 6: {
                        pkgFragment = (IScriptFolder)this.currentElement.getParent();
                    }
                }
                if (pkgFragment == null) {
                    element = rootInfo == null ? DLTKCore.create(resource) : ModelManager.create(resource, (IScriptProject)rootInfo.project);
                    break;
                }
                if (elementType == 5) {
                    String fileName = path.lastSegment();
                    element = pkgFragment.getSourceModule(fileName);
                    break;
                }
                throw new RuntimeException("not implemented");
            }
        }
        if (element == null) {
            return null;
        }
        this.currentElement = (Openable)element;
        return this.currentElement;
    }

    private boolean createExternalArchiveDelta(Set<IModelElement> refreshedElements, IProgressMonitor monitor) {
        if (refreshedElements == null) {
            return false;
        }
        HashMap<IPath, ZipStatus> externalArchivesStatus = new HashMap<IPath, ZipStatus>();
        boolean hasDelta = false;
        HashSet<IPath> archivePathsToRefresh = new HashSet<IPath>();
        block11: for (IModelElement element : refreshedElements) {
            switch (element.getElementType()) {
                case 3: {
                    archivePathsToRefresh.add(element.getPath());
                    break;
                }
                case 2: {
                    IBuildpathEntry[] buildpath;
                    IEnvironment environment;
                    ScriptProject scriptProject = (ScriptProject)element;
                    if (!DLTKLanguageManager.hasScriptNature(scriptProject.getProject()) || (environment = EnvironmentManager.getEnvironment(scriptProject)) != null && !environment.isConnected()) continue block11;
                    try {
                        buildpath = scriptProject.getResolvedBuildpath();
                        int j = 0;
                        int cpLength = buildpath.length;
                        while (j < cpLength) {
                            if (buildpath[j].getEntryKind() == 1) {
                                archivePathsToRefresh.add(buildpath[j].getPath());
                            }
                            ++j;
                        }
                    }
                    catch (ModelException modelException) {}
                    continue block11;
                }
                case 1: {
                    IBuildpathEntry[] buildpath;
                    ScriptProject scriptProject;
                    for (String projectName : this.state.getOldScriptProjectNames()) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!DLTKLanguageManager.hasScriptNature(project)) continue;
                        scriptProject = (ScriptProject)DLTKCore.create(project);
                        try {
                            buildpath = scriptProject.getResolvedBuildpath();
                        }
                        catch (ModelException modelException) {
                            continue;
                        }
                        int k = 0;
                        int cpLength = buildpath.length;
                        while (k < cpLength) {
                            if (buildpath[k].getEntryKind() == 1) {
                                archivePathsToRefresh.add(buildpath[k].getPath());
                            }
                            ++k;
                        }
                    }
                    continue block11;
                }
            }
        }
        IWorkspaceRoot wksRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (String projectName : this.state.getOldScriptProjectNames()) {
            IBuildpathEntry[] entries;
            if (monitor != null && monitor.isCanceled()) break;
            IProject project = wksRoot.getProject(projectName);
            if (!DLTKLanguageManager.hasScriptNature(project)) continue;
            ScriptProject scriptProject = (ScriptProject)DLTKCore.create(project);
            try {
                entries = scriptProject.getResolvedBuildpath();
            }
            catch (ModelException modelException) {
                continue;
            }
            int j = 0;
            while (j < entries.length) {
                IPath entryPath;
                IBuildpathEntry entry = entries[j];
                if (entry.getEntryKind() == 1 && archivePathsToRefresh.contains(entryPath = entry.getPath())) {
                    ZipStatus status = (ZipStatus)((Object)externalArchivesStatus.get(entryPath));
                    if (status == null) {
                        Object targetLibrary = Model.getTarget((IContainer)wksRoot, entryPath, true);
                        if (targetLibrary == null) {
                            if (this.state.getExternalLibTimeStamps().remove(entryPath) != null) {
                                externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_REMOVED);
                                this.manager.indexManager.removeIndex(entryPath);
                                ProjectIndexerManager.removeLibrary(scriptProject, entryPath);
                            }
                        } else if (targetLibrary instanceof IFileHandle) {
                            IFileHandle externalFile = (IFileHandle)targetLibrary;
                            Long oldTimestamp = this.state.getExternalLibTimeStamps().get(entryPath);
                            long newTimeStamp = DeltaProcessor.getTimeStamp(externalFile);
                            if (oldTimestamp != null) {
                                if (newTimeStamp == 0L) {
                                    externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_REMOVED);
                                    this.state.getExternalLibTimeStamps().remove(entryPath);
                                    this.manager.indexManager.removeIndex(entryPath);
                                    ProjectIndexerManager.removeLibrary(scriptProject, entryPath);
                                } else if (oldTimestamp != newTimeStamp) {
                                    externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_CHANGED);
                                    this.state.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                    this.manager.indexManager.removeIndex(entryPath);
                                    ProjectIndexerManager.indexLibrary(scriptProject, entryPath);
                                } else {
                                    externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_UNCHANGED);
                                }
                            } else if (newTimeStamp == 0L) {
                                externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_UNCHANGED);
                            } else {
                                externalArchivesStatus.put(entryPath, ZipStatus.EXTERNAL_ZIP_ADDED);
                                this.state.getExternalLibTimeStamps().put(entryPath, new Long(newTimeStamp));
                                ProjectIndexerManager.indexLibrary(scriptProject, entryPath);
                            }
                        } else {
                            externalArchivesStatus.put(entryPath, ZipStatus.INTERNAL_ZIP_IGNORE);
                        }
                    }
                    if ((status = (ZipStatus)((Object)externalArchivesStatus.get(entryPath))) != null) {
                        IProjectFragment root;
                        if (status == ZipStatus.EXTERNAL_ZIP_ADDED) {
                            root = scriptProject.getProjectFragment(entryPath);
                            if (root == null) {
                                DeltaProcessor.logFragmentNotFound(scriptProject, entryPath);
                            } else {
                                if (VERBOSE) {
                                    System.out.println("- External ZIP ADDED, affecting root: " + root.getElementName());
                                }
                                this.elementAdded((Openable)((Object)root), null, null);
                                scriptProject.resetResolvedBuildpath();
                                this.state.addBuildpathValidation(scriptProject);
                                hasDelta = true;
                            }
                        } else if (status == ZipStatus.EXTERNAL_ZIP_CHANGED) {
                            root = scriptProject.getProjectFragment(entryPath);
                            if (root == null) {
                                DeltaProcessor.logFragmentNotFound(scriptProject, entryPath);
                            } else {
                                if (VERBOSE) {
                                    System.out.println("- External ZIP CHANGED, affecting root: " + root.getElementName());
                                }
                                this.contentChanged((Openable)((Object)root));
                                hasDelta = true;
                            }
                        } else if (status == ZipStatus.EXTERNAL_ZIP_REMOVED) {
                            root = scriptProject.getProjectFragment(entryPath);
                            if (root == null) {
                                DeltaProcessor.logFragmentNotFound(scriptProject, entryPath);
                            } else {
                                if (VERBOSE) {
                                    System.out.println("- External ZIP REMOVED, affecting root: " + root.getElementName());
                                }
                                this.elementRemoved((Openable)((Object)root), null, null);
                                scriptProject.resetResolvedBuildpath();
                                this.state.addBuildpathValidation(scriptProject);
                                hasDelta = true;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        return hasDelta;
    }

    private static void logFragmentNotFound(ScriptProject scriptProject, IPath entryPath) {
        if (DEBUG) {
            System.out.println("ProjectFragment \"" + entryPath + "\" not found in " + scriptProject.getElementName());
        }
    }

    private ModelElementDelta currentDelta() {
        if (this.currentDelta == null) {
            this.currentDelta = new ModelElementDelta(this.manager.getModel());
        }
        return this.currentDelta;
    }

    private void deleting(IProject project) {
        try {
            this.manager.indexManager.discardJobs(project.getName());
            ScriptProject scriptProject = (ScriptProject)DLTKCore.create(project);
            if (this.oldRoots == null) {
                this.oldRoots = new HashMap<IScriptProject, IProjectFragment[]>();
            }
            if (scriptProject.isOpen()) {
                this.oldRoots.put(scriptProject, scriptProject.getProjectFragments());
            } else {
                this.oldRoots.put(scriptProject, scriptProject.computeProjectFragments(scriptProject.getResolvedBuildpath(), false, null));
            }
            scriptProject.close();
            this.state.getOldScriptProjectNames();
            this.removeFromParentInfo(scriptProject);
            this.manager.resetProjectPreferences(scriptProject);
        }
        catch (ModelException modelException) {}
    }

    private void elementAdded(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            if (delta != null && DLTKLanguageManager.hasScriptNature((IProject)delta.getResource())) {
                this.addToParentInfo(element);
                if ((delta.getFlags() & 0x1000) != 0) {
                    Openable movedFromElement = (Openable)((Object)element.getModel().getScriptProject(delta.getMovedFromPath().lastSegment()));
                    this.currentDelta().movedTo(element, movedFromElement);
                } else {
                    this.close(element);
                    this.currentDelta().added(element);
                }
                this.state.updateRoots(element.getPath(), delta, this);
                IScriptProject project = (IScriptProject)((Object)element);
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
            }
        } else {
            if (delta == null || (delta.getFlags() & 0x1000) == 0) {
                if (this.isPrimaryWorkingCopy(element, elementType)) {
                    this.currentDelta().changed(element, 262144);
                } else {
                    this.addToParentInfo(element);
                    this.close(element);
                    this.currentDelta().added(element);
                }
            } else {
                Openable movedFromElement;
                this.addToParentInfo(element);
                this.close(element);
                IPath movedFromPath = delta.getMovedFromPath();
                IResource res = delta.getResource();
                Object movedFromRes = res instanceof IFile ? res.getWorkspace().getRoot().getFile(movedFromPath) : res.getWorkspace().getRoot().getFolder(movedFromPath);
                RootInfo movedFromInfo = this.enclosingRootInfo(movedFromPath, 2);
                int movedFromType = this.elementType((IResource)movedFromRes, 2, element.getParent().getElementType(), movedFromInfo);
                this.currentElement = null;
                Openable openable = movedFromElement = elementType != 2 && movedFromType == 2 ? null : this.createElement((IResource)movedFromRes, movedFromType, movedFromInfo);
                if (movedFromElement == null) {
                    this.currentDelta().added(element);
                } else {
                    this.currentDelta().movedTo(element, movedFromElement);
                }
            }
            switch (elementType) {
                case 3: {
                    ScriptProject project = (ScriptProject)element.getScriptProject();
                    this.rootsToRefresh.add(project);
                    this.projectCachesToReset.add(project);
                    break;
                }
                case 4: {
                    ScriptProject project = (ScriptProject)element.getScriptProject();
                    this.projectCachesToReset.add(project);
                }
            }
        }
    }

    private void elementRemoved(Openable element, IResourceDelta delta, RootInfo rootInfo) {
        int elementType = element.getElementType();
        if (delta == null || (delta.getFlags() & 0x2000) == 0) {
            if (this.isPrimaryWorkingCopy(element, elementType)) {
                this.currentDelta().changed(element, 262144);
            } else {
                this.close(element);
                this.removeFromParentInfo(element);
                this.currentDelta().removed(element);
            }
        } else {
            Openable movedToElement;
            IFolder movedToRes;
            this.close(element);
            this.removeFromParentInfo(element);
            IPath movedToPath = delta.getMovedToPath();
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 4: {
                    movedToRes = res.getWorkspace().getRoot().getProject(movedToPath.lastSegment());
                    break;
                }
                case 2: {
                    movedToRes = res.getWorkspace().getRoot().getFolder(movedToPath);
                    break;
                }
                case 1: {
                    movedToRes = res.getWorkspace().getRoot().getFile(movedToPath);
                    break;
                }
                default: {
                    return;
                }
            }
            RootInfo movedToInfo = this.enclosingRootInfo(movedToPath, 1);
            int movedToType = this.elementType((IResource)movedToRes, 1, element.getParent().getElementType(), movedToInfo);
            this.currentElement = null;
            Openable openable = movedToElement = elementType != 2 && movedToType == 2 ? null : this.createElement((IResource)movedToRes, movedToType, movedToInfo);
            if (movedToElement == null) {
                this.currentDelta().removed(element);
            } else {
                this.currentDelta().movedFrom(element, movedToElement);
            }
        }
        switch (elementType) {
            case 1: {
                this.manager.indexManager.reset();
                break;
            }
            case 2: {
                this.state.updateRoots(element.getPath(), delta, this);
                IScriptProject project = (IScriptProject)((Object)element);
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
                break;
            }
            case 3: {
                IScriptProject project = element.getScriptProject();
                this.rootsToRefresh.add(project);
                this.projectCachesToReset.add(project);
                break;
            }
            case 4: {
                IScriptProject project = element.getScriptProject();
                this.projectCachesToReset.add(project);
            }
        }
    }

    private int elementType(IResource res, int kind, int parentType, RootInfo rootInfo) {
        switch (parentType) {
            case 1: {
                return 2;
            }
            case -1: 
            case 2: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo != null && rootInfo.isRootOfProject(res.getFullPath())) {
                    return 3;
                }
            }
            case 3: 
            case 4: {
                if (rootInfo == null) {
                    rootInfo = this.enclosingRootInfo(res.getFullPath(), kind);
                }
                if (rootInfo == null) {
                    return -1;
                }
                if (Util.isExcluded(res, rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                    return -1;
                }
                if (res.getType() == 2) {
                    if (parentType == -1 && !Util.isExcluded((IResource)res.getParent(), rootInfo.inclusionPatterns, rootInfo.exclusionPatterns)) {
                        return -1;
                    }
                    if (Util.isValidFolderNameForPackage(res.getParent(), res.getName())) {
                        return 4;
                    }
                    return -1;
                }
                IProject project = res.getProject();
                IScriptProject scriptProject = DLTKCore.create(project);
                if (scriptProject != null) {
                    if (!Util.isValidSourceModule((IModelElement)scriptProject, res)) break;
                    return 5;
                }
                if (this.rootInfo(res.getFullPath(), kind) != null) {
                    return 3;
                }
                return -1;
            }
        }
        return -1;
    }

    public void flush() {
        this.modelDeltas = new ArrayList();
    }

    private RootInfo enclosingRootInfo(IPath path, int kind) {
        while (path != null && path.segmentCount() > 0) {
            RootInfo rootInfo = this.rootInfo(path, kind);
            if (rootInfo != null) {
                return rootInfo;
            }
            path = path.removeLastSegments(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(IModelElementDelta customDelta, int eventType) {
        int listenerCount;
        int[] listenerMask;
        IElementChangedListener[] listeners;
        IModelElementDelta deltaToNotify;
        if (!this.isFiring) {
            return;
        }
        if (DEBUG) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        if ((deltaToNotify = customDelta == null ? this.mergeDeltas(this.modelDeltas) : customDelta) != null && this.manager.workspaceScope != null) {
            for (DLTKWorkspaceScope workspaceScope : this.manager.workspaceScope.values()) {
                if (workspaceScope == null) continue;
                workspaceScope.processDelta(deltaToNotify);
            }
        }
        DeltaProcessingState deltaProcessingState = this.state;
        synchronized (deltaProcessingState) {
            listeners = this.state.elementChangedListeners;
            listenerMask = this.state.elementChangedListenerMasks;
            listenerCount = this.state.elementChangedListenerCount;
        }
        switch (eventType) {
            case 0: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePostChangeDelta(IModelElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DEBUG) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IModelElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DEBUG) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    private boolean isAffectedBy(IResourceDelta rootDelta) {
        if (rootDelta != null) {
            class FoundRelevantDeltaException
            extends RuntimeException {
                private static final long serialVersionUID = 7137113252936111022L;

                FoundRelevantDeltaException() {
                }
            }
            try {
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        switch (delta.getKind()) {
                            case 1: 
                            case 2: {
                                throw new FoundRelevantDeltaException();
                            }
                            case 4: {
                                if (delta.getAffectedChildren().length != 0 || (delta.getFlags() & 0xFFFCFFFF) == 0) break;
                                throw new FoundRelevantDeltaException();
                            }
                        }
                        return true;
                    }
                });
            }
            catch (FoundRelevantDeltaException foundRelevantDeltaException) {
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private boolean isPrimaryWorkingCopy(IModelElement element, int elementType) {
        if (elementType == 5) {
            SourceModule cu = (SourceModule)element;
            return cu.isPrimary() && cu.isWorkingCopy();
        }
        return false;
    }

    private IModelElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IModelElementDelta)deltas.iterator().next();
        }
        if (VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        ModelElementDelta rootDelta = new ModelElementDelta(this.manager.model);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IModelElement element;
            ModelElementDelta delta = (ModelElementDelta)iterator.next();
            if (VERBOSE) {
                System.out.println(delta.toString());
            }
            if (this.manager.model.equals(element = delta.getElement())) {
                IModelElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    ModelElementDelta projectDelta = (ModelElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    private void notifyListeners(IModelElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of script element change notification");
                    }

                    public void run() throws Exception {
                        PerformanceStats stats = null;
                        if (PERF) {
                            stats = PerformanceStats.getStats((String)"org.eclipse.dltk.core/perf/deltalistener", (Object)listener);
                            stats.startRun();
                        }
                        listener.elementChanged(extraEvent);
                        if (PERF) {
                            stats.endRun();
                        }
                    }
                });
                if (VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    private void notifyTypeHierarchies(IElementChangedListener[] listeners, int listenerCount) {
        if (DLTKCore.DEBUG) {
            System.out.println("notify type hierarchies");
        }
    }

    private void nonScriptResourcesChanged(Openable element, IResourceDelta delta) throws ModelException {
        ModelElementDelta current;
        ModelElementDelta elementDelta;
        if (element.isOpen()) {
            ModelElementInfo info = (ModelElementInfo)element.getElementInfo();
            switch (element.getElementType()) {
                case 1: {
                    ((ModelInfo)info).foreignResources = null;
                    this.currentDelta().addResourceDelta(delta);
                    return;
                }
                case 2: {
                    ((ProjectElementInfo)info).setForeignResources(null);
                    ScriptProject project = (ScriptProject)element;
                    IProjectFragment projectRoot = project.getProjectFragment((IResource)project.getProject());
                    if (!projectRoot.isOpen()) break;
                    ((ProjectFragmentInfo)((Openable)((Object)projectRoot)).getElementInfo()).setForeignResources(null);
                    break;
                }
                case 4: {
                    ((ScriptFolderInfo)info).setForeignResources(null);
                    break;
                }
                case 3: {
                    ((ProjectFragmentInfo)info).setForeignResources(null);
                }
            }
        }
        if ((elementDelta = (current = this.currentDelta()).find(element)) == null) {
            elementDelta = current.changed(element, 1);
        }
        elementDelta.addResourceDelta(delta);
    }

    private ArrayList otherRootsInfo(IPath path, int kind) {
        if (kind == 2) {
            return (ArrayList)this.state.oldOtherRoots.get(path);
        }
        return (ArrayList)this.state.otherRoots.get(path);
    }

    private void popUntilPrefixOf(IPath path) {
        while (this.currentElement != null) {
            IPath currentElementPath = null;
            if (this.currentElement instanceof IProjectFragment) {
                currentElementPath = ((IProjectFragment)((Object)this.currentElement)).getPath();
            } else {
                IResource currentElementResource = this.currentElement.getResource();
                if (currentElementResource != null) {
                    currentElementPath = currentElementResource.getFullPath();
                }
            }
            if (currentElementPath != null) {
                if (this.currentElement instanceof IScriptFolder && ((IScriptFolder)((Object)this.currentElement)).isRootFolder() && currentElementPath.segmentCount() != path.segmentCount() - 1) {
                    this.currentElement = (Openable)this.currentElement.getParent();
                }
                if (currentElementPath.isPrefixOf(path)) {
                    return;
                }
            }
            this.currentElement = (Openable)this.currentElement.getParent();
        }
    }

    private IModelElementDelta processResourceDelta(IResourceDelta changes) {
        try {
            Model model = this.manager.getModel();
            if (!model.isOpen()) {
                try {
                    model.open(null);
                }
                catch (ModelException e) {
                    if (VERBOSE) {
                        e.printStackTrace();
                    }
                    this.currentDelta = null;
                    this.rootsToRefresh.clear();
                    this.projectCachesToReset.clear();
                    this.postActions.clear();
                    return null;
                }
            }
            this.state.initializeRoots();
            this.currentElement = null;
            IResourceDelta[] deltas = changes.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                IResourceDelta delta = deltas[i];
                IResource res = delta.getResource();
                RootInfo rootInfo = null;
                IProject proj = (IProject)res;
                boolean wasDylanProject = this.state.findProject(proj.getName()) != null;
                boolean isDylanProject = DLTKLanguageManager.hasScriptNature(proj);
                int elementType = !wasDylanProject && !isDylanProject ? -1 : ((rootInfo = this.enclosingRootInfo(res.getFullPath(), delta.getKind())) != null && rootInfo.isRootOfProject(res.getFullPath()) ? 3 : 2);
                this.traverseDelta(delta, elementType, rootInfo);
                if (elementType == -1 || wasDylanProject != isDylanProject && delta.getKind() == 4) {
                    try {
                        this.nonScriptResourcesChanged(model, delta);
                    }
                    catch (ModelException modelException) {}
                }
                ++i;
            }
            this.refreshProjectFragments();
            this.resetProjectCaches();
            this.executePostActions();
            ModelElementDelta modelElementDelta = this.currentDelta;
            return modelElementDelta;
        }
        finally {
            this.currentDelta = null;
            this.rootsToRefresh.clear();
            this.projectCachesToReset.clear();
            this.postActions.clear();
        }
    }

    private void executePostActions() {
        if (this.postActions.size() == 0) {
            return;
        }
        Iterator<Runnable> i = this.postActions.iterator();
        while (i.hasNext()) {
            i.next().run();
        }
    }

    private void resetProjectCaches() {
        if (this.projectCachesToReset.size() == 0) {
            return;
        }
        ModelManager.getModelManager().resetZIPTypeCache();
        Iterator<IScriptProject> iterator = this.projectCachesToReset.iterator();
        HashMap projectDepencies = this.state.projectDependencies;
        HashSet affectedDependents = new HashSet();
        while (iterator.hasNext()) {
            ScriptProject project = (ScriptProject)iterator.next();
            project.resetCaches();
            this.addDependentProjects(project, projectDepencies, affectedDependents);
        }
        for (ScriptProject project : affectedDependents) {
            project.resetCaches();
        }
    }

    private void refreshProjectFragments() {
        for (ScriptProject scriptProject : this.rootsToRefresh) {
            scriptProject.updateProjectFragments();
        }
    }

    public void registerModelDelta(IModelElementDelta delta) {
        this.modelDeltas.add(delta);
    }

    private void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                ModelElementInfo info = (ModelElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (ModelException modelException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resourceChanged(IResourceChangeEvent event) {
        int eventType = this.overridenEventType == -1 ? event.getType() : this.overridenEventType;
        IResource resource = event.getResource();
        IResourceDelta delta = event.getDelta();
        switch (eventType) {
            case 4: {
                if (resource.getType() != 4 || !DLTKLanguageManager.hasScriptNature((IProject)resource)) return;
                this.deleting((IProject)resource);
                return;
            }
            case 1: {
                Set<IModelElement> elementsToRefresh = this.state.removeExternalElementsToRefresh();
                if (!this.isAffectedBy(delta) && elementsToRefresh == null) return;
                try {
                    int listenerCount;
                    IElementChangedListener[] listeners;
                    Object javaDelta;
                    try {
                        IModelElementDelta translatedDelta;
                        HashMap<IProject, BuildpathChange> buildpathChanges;
                        this.stopDeltas();
                        this.checkProjectsBeingAddedOrRemoved(delta);
                        if (elementsToRefresh != null) {
                            this.createExternalArchiveDelta(elementsToRefresh, null);
                            this.createCustomElementDelta(null, elementsToRefresh);
                        }
                        if ((buildpathChanges = this.state.removeAllBuildpathChanges()).size() > 0) {
                            boolean hasDelta = this.currentDelta != null;
                            javaDelta = this.currentDelta();
                            for (BuildpathChange change : buildpathChanges.values()) {
                                int result = change.generateDelta((ModelElementDelta)javaDelta, false);
                                if ((result & BuildpathChange.HAS_DELTA) != 0) {
                                    hasDelta = true;
                                    this.state.rootsAreStale = true;
                                    change.requestIndexing();
                                    this.state.addBuildpathValidation(change.project);
                                }
                                if ((result & BuildpathChange.HAS_PROJECT_CHANGE) != 0) {
                                    this.state.addProjectReferenceChange(change.project, change.oldResolvedBuildpath);
                                }
                                if ((result & BuildpathChange.HAS_LIBRARY_CHANGE) == 0) continue;
                                this.state.addExternalFolderChange(change.project, change.oldResolvedBuildpath);
                            }
                            elementsToRefresh = this.state.removeExternalElementsToRefresh();
                            if (elementsToRefresh != null) {
                                hasDelta |= this.createExternalArchiveDelta(elementsToRefresh, null);
                            }
                            if (!hasDelta) {
                                this.currentDelta = null;
                            }
                        }
                        if ((translatedDelta = this.processResourceDelta(delta)) != null) {
                            this.registerModelDelta(translatedDelta);
                        }
                    }
                    finally {
                        this.sourceElementParserCache = null;
                        this.startDeltas();
                    }
                    javaDelta = this.state;
                    synchronized (javaDelta) {
                        listeners = this.state.elementChangedListeners;
                        listenerCount = this.state.elementChangedListenerCount;
                    }
                    this.notifyTypeHierarchies(listeners, listenerCount);
                    this.fire(null, 1);
                    return;
                }
                finally {
                    this.state.resetOldScriptProjectNames();
                    this.oldRoots = null;
                }
            }
            case 8: {
                ProjectReferenceChange[] projectRefChanges;
                if (!this.isAffectedBy(delta)) {
                    return;
                }
                boolean needCycleValidation = this.validateBuildpaths(delta);
                BuildpathValidation[] validations = this.state.removeBuildpathValidations();
                if (validations != null) {
                    int i = 0;
                    int length = validations.length;
                    while (i < length) {
                        BuildpathValidation validation = validations[i];
                        validation.validate();
                        ++i;
                    }
                }
                if ((projectRefChanges = this.state.removeProjectReferenceChanges()) != null) {
                    int i = 0;
                    int length = projectRefChanges.length;
                    while (i < length) {
                        try {
                            projectRefChanges[i].updateProjectReferencesIfNecessary();
                        }
                        catch (ModelException modelException) {}
                        ++i;
                    }
                }
                if (needCycleValidation || projectRefChanges != null) {
                    try {
                        ScriptProject.validateCycles(null);
                    }
                    catch (ModelException modelException) {}
                }
                Model.flushExternalFileCache();
                ScriptBuilder.buildStarting();
                return;
            }
            case 16: {
                ScriptBuilder.buildFinished();
                return;
            }
        }
    }

    private static boolean isVirtualProjectFragment(IProjectFragment fragment) throws ModelException {
        if (fragment == null) {
            return false;
        }
        return fragment.isExternal() && fragment.getRawBuildpathEntry() == null;
    }

    private boolean createCustomElementDelta(IProgressMonitor monitor, Set<IModelElement> refreshedElements) {
        if (refreshedElements == null) {
            return false;
        }
        boolean hasDelta = false;
        FragmentCache fragmentCache = new FragmentCache();
        HashSet<Object> fragmentsToRefresh = new HashSet<Object>();
        block13: for (IModelElement element : refreshedElements) {
            switch (element.getElementType()) {
                case 3: {
                    IProjectFragment fragment = (IProjectFragment)element;
                    try {
                        if (!DeltaProcessor.isVirtualProjectFragment(fragment)) break;
                        fragmentsToRefresh.add(fragment);
                    }
                    catch (ModelException e1) {
                        if (!DLTKCore.DEBUG) break;
                        e1.printStackTrace();
                    }
                    continue block13;
                }
                case 2: {
                    IEnvironment environment;
                    ScriptProject scriptProject = (ScriptProject)element;
                    if (!DLTKLanguageManager.hasScriptNature(scriptProject.getProject()) || (environment = EnvironmentManager.getEnvironment(scriptProject)) != null && !environment.isConnected()) continue block13;
                    try {
                        IProjectFragment[] fragments = scriptProject.getProjectFragments();
                        int i = 0;
                        while (i < fragments.length) {
                            if (DeltaProcessor.isVirtualProjectFragment(fragments[i])) {
                                fragmentsToRefresh.add(fragments[i]);
                            }
                            ++i;
                        }
                        fragments = fragmentCache.getAllFragments(scriptProject);
                        i = 0;
                        while (i < fragments.length) {
                            if (DeltaProcessor.isVirtualProjectFragment(fragments[i])) {
                                fragmentsToRefresh.add(fragments[i]);
                            }
                            ++i;
                        }
                    }
                    catch (ModelException e1) {
                        if (!DLTKCore.DEBUG) break;
                        e1.printStackTrace();
                    }
                    continue block13;
                }
                case 1: {
                    ScriptProject scriptProject;
                    for (String projectName : this.state.getOldScriptProjectNames()) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!DLTKLanguageManager.hasScriptNature(project)) continue;
                        scriptProject = (ScriptProject)DLTKCore.create(project);
                        try {
                            IProjectFragment[] fragments = scriptProject.getProjectFragments();
                            int i = 0;
                            while (i < fragments.length) {
                                if (DeltaProcessor.isVirtualProjectFragment(fragments[i])) {
                                    fragmentsToRefresh.add(fragments[i]);
                                }
                                ++i;
                            }
                        }
                        catch (ModelException e1) {
                            if (!DLTKCore.DEBUG) continue;
                            e1.printStackTrace();
                        }
                    }
                    continue block13;
                }
            }
        }
        if (fragmentsToRefresh.isEmpty()) {
            return false;
        }
        HashSet<String> projectsToRefresh = new HashSet<String>();
        for (IProjectFragment iProjectFragment : fragmentsToRefresh) {
            projectsToRefresh.add(iProjectFragment.getScriptProject().getElementName());
        }
        Map<IPath, Long> map = this.state.getCustomTimeStamps();
        IWorkspaceRoot wksRoot = ResourcesPlugin.getWorkspace().getRoot();
        for (String projectName : this.state.getOldScriptProjectNames()) {
            if (!projectsToRefresh.contains(projectName)) continue;
            if (monitor != null && monitor.isCanceled()) break;
            IProject project = wksRoot.getProject(projectName);
            if (!DLTKLanguageManager.hasScriptNature(project)) continue;
            ScriptProject scriptProject = (ScriptProject)DLTKCore.create(project);
            try {
                HashSet oldFragments = new HashSet();
                Collections.addAll(oldFragments, scriptProject.getProjectFragments());
                HashSet newFragments = new HashSet();
                Collections.addAll(newFragments, fragmentCache.getAllFragments(scriptProject));
                HashSet allFragments = new HashSet();
                allFragments.addAll(oldFragments);
                allFragments.addAll(newFragments);
                allFragments.retainAll(fragmentsToRefresh);
                for (IProjectFragment fragment : allFragments) {
                    if (!(fragment instanceof IProjectFragmentTimestamp)) continue;
                    boolean isNew = newFragments.contains(fragment);
                    boolean isOld = oldFragments.contains(fragment);
                    if (isNew && !isOld) {
                        long newTimeStamp = ((IProjectFragmentTimestamp)((Object)fragment)).getTimeStamp();
                        if (newTimeStamp == 0L) continue;
                        map.put(fragment.getPath(), new Long(newTimeStamp));
                        ProjectIndexerManager.indexLibrary(scriptProject, fragment.getPath());
                        if (fragment instanceof Openable) {
                            this.elementAdded((Openable)((Object)fragment), null, null);
                        }
                        hasDelta = true;
                        continue;
                    }
                    if (isOld && !isNew) {
                        if (fragment instanceof Openable) {
                            this.elementRemoved((Openable)((Object)fragment), null, null);
                        }
                        hasDelta = true;
                        continue;
                    }
                    Long oldTimestamp = map.get(fragment.getPath());
                    long newTimeStamp = ((IProjectFragmentTimestamp)((Object)fragment)).getTimeStamp();
                    if (newTimeStamp == 0L || oldTimestamp != null && newTimeStamp == oldTimestamp) continue;
                    map.put(fragment.getPath(), new Long(newTimeStamp));
                    ProjectIndexerManager.indexLibrary(scriptProject, fragment.getPath());
                    if (fragment instanceof Openable) {
                        this.contentChanged((Openable)((Object)fragment));
                    }
                    hasDelta = true;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return hasDelta;
    }

    private RootInfo rootInfo(IPath path, int kind) {
        if (kind == 2) {
            return (RootInfo)this.state.oldRoots.get(path);
        }
        return (RootInfo)this.state.roots.get(path);
    }

    private void startDeltas() {
        this.isFiring = true;
    }

    private void stopDeltas() {
        this.isFiring = false;
    }

    private void traverseDelta(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        block15: {
            IProject rscProject;
            ScriptProject adoptiveProject;
            IResource res = delta.getResource();
            if (this.currentElement == null && rootInfo != null) {
                this.currentElement = rootInfo.project;
            }
            boolean processChildren = true;
            processChildren = res instanceof IProject ? this.updateCurrentDeltaAndIndex(delta, elementType == 3 ? 2 : elementType, rootInfo) : (rootInfo != null ? this.updateCurrentDeltaAndIndex(delta, elementType, rootInfo) : true);
            if (!processChildren) break block15;
            IResourceDelta[] children = delta.getAffectedChildren();
            boolean oneChildOnBuildpath = false;
            int length = children.length;
            IResourceDelta[] orphanChildren = null;
            Openable parent = null;
            boolean isValidParent = true;
            int i = 0;
            while (i < length) {
                block19: {
                    ArrayList rootList;
                    boolean isNestedRoot;
                    RootInfo childRootInfo2;
                    int childKind;
                    IPath childPath;
                    IResourceDelta child;
                    block21: {
                        block16: {
                            block17: {
                                block18: {
                                    block20: {
                                        child = children[i];
                                        IResource childRes = child.getResource();
                                        childPath = childRes.getFullPath();
                                        childRootInfo2 = this.rootInfo(childPath, childKind = child.getKind());
                                        if (childRootInfo2 != null && !childRootInfo2.isRootOfProject(childPath)) {
                                            childRootInfo2 = null;
                                        }
                                        int childType = this.elementType(childRes, childKind, elementType, rootInfo == null ? childRootInfo2 : rootInfo);
                                        boolean bl = isNestedRoot = rootInfo != null && childRootInfo2 != null;
                                        if (isNestedRoot) break block16;
                                        this.traverseDelta(child, childType, rootInfo == null ? childRootInfo2 : rootInfo);
                                        if (childType != -1) break block17;
                                        if (rootInfo == null) break block18;
                                        if (!isValidParent) break block19;
                                        if (parent != null) break block20;
                                        if (this.currentElement == null || !rootInfo.project.equals(this.currentElement.getScriptProject())) {
                                            this.currentElement = rootInfo.project;
                                        }
                                        if ((parent = elementType == 2 || elementType == 3 && res instanceof IProject ? rootInfo.project : this.createElement(res, elementType, rootInfo)) != null) break block20;
                                        isValidParent = false;
                                        break block19;
                                    }
                                    try {
                                        this.nonScriptResourcesChanged(parent, child);
                                    }
                                    catch (ModelException modelException) {}
                                    break block21;
                                }
                                if (orphanChildren == null) {
                                    orphanChildren = new IResourceDelta[length];
                                }
                                orphanChildren[i] = child;
                                break block21;
                            }
                            oneChildOnBuildpath = true;
                            break block21;
                        }
                        oneChildOnBuildpath = true;
                    }
                    if (isNestedRoot || childRootInfo2 == null && (childRootInfo2 = this.rootInfo(childPath, childKind)) != null) {
                        this.traverseDelta(child, 3, childRootInfo2);
                    }
                    if ((rootList = this.otherRootsInfo(childPath, childKind)) != null) {
                        for (RootInfo childRootInfo2 : rootList) {
                            this.traverseDelta(child, 3, childRootInfo2);
                        }
                    }
                }
                ++i;
            }
            if (orphanChildren != null && (oneChildOnBuildpath || res instanceof IProject) && (adoptiveProject = (ScriptProject)DLTKCore.create(rscProject = res.getProject())) != null && DLTKLanguageManager.hasScriptNature(rscProject)) {
                int i2 = 0;
                while (i2 < length) {
                    if (orphanChildren[i2] != null) {
                        try {
                            this.nonScriptResourcesChanged(adoptiveProject, (IResourceDelta)orphanChildren[i2]);
                        }
                        catch (ModelException modelException) {}
                    }
                    ++i2;
                }
            }
        }
    }

    private void validateBuildpaths(IResourceDelta delta, HashSet<IPath> affectedProjects) {
        IResource resource = delta.getResource();
        boolean processChildren = false;
        switch (resource.getType()) {
            case 8: {
                if (delta.getKind() != 4) break;
                processChildren = true;
                break;
            }
            case 4: {
                ScriptProject scriptProject;
                IProject project = (IProject)resource;
                int kind = delta.getKind();
                boolean isDylanProject = DLTKLanguageManager.hasScriptNature(project);
                switch (kind) {
                    case 1: {
                        processChildren = isDylanProject;
                        affectedProjects.add(project.getFullPath());
                        break;
                    }
                    case 4: {
                        boolean wasScriptProject;
                        processChildren = isDylanProject;
                        if ((delta.getFlags() & 0x4000) != 0) {
                            if (isDylanProject) {
                                ScriptProject scriptProject2 = (ScriptProject)DLTKCore.create(project);
                                this.state.addBuildpathValidation(scriptProject2);
                            }
                            affectedProjects.add(project.getFullPath());
                            break;
                        }
                        if ((delta.getFlags() & 0x80000) == 0) break;
                        boolean bl = wasScriptProject = this.state.findProject(project.getName()) != null;
                        if (wasScriptProject == isDylanProject) break;
                        scriptProject = (ScriptProject)DLTKCore.create(project);
                        this.state.addBuildpathValidation(scriptProject);
                        affectedProjects.add(project.getFullPath());
                        break;
                    }
                    case 2: {
                        affectedProjects.add(project.getFullPath());
                    }
                }
                break;
            }
            case 1: {
                IFile file = (IFile)resource;
                if (!file.getName().equals(".buildpath")) break;
                ScriptProject scriptProject = (ScriptProject)DLTKCore.create(file.getProject());
                this.state.addBuildpathValidation(scriptProject);
                affectedProjects.add(file.getProject().getFullPath());
            }
        }
        if (processChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.validateBuildpaths(children[i], affectedProjects);
                ++i;
            }
        }
    }

    private boolean validateBuildpaths(IResourceDelta delta) {
        HashSet<IPath> affectedProjects = new HashSet<IPath>(5);
        this.validateBuildpaths(delta, affectedProjects);
        boolean needCycleValidation = false;
        if (!affectedProjects.isEmpty()) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int length = projects.length;
            int i = 0;
            while (i < length) {
                IProject project = projects[i];
                ScriptProject scriptProject = (ScriptProject)DLTKCore.create(project);
                try {
                    IPath projectPath = project.getFullPath();
                    IBuildpathEntry[] buildpath = scriptProject.getResolvedBuildpath();
                    int j = 0;
                    int cpLength = buildpath.length;
                    while (j < cpLength) {
                        IBuildpathEntry entry = buildpath[j];
                        switch (entry.getEntryKind()) {
                            case 2: {
                                if (!affectedProjects.contains(entry.getPath())) break;
                                this.state.addBuildpathValidation(scriptProject);
                                needCycleValidation = true;
                                break;
                            }
                            case 1: {
                                IPath entryPath = entry.getPath();
                                IPath libProjectPath = entryPath.removeLastSegments(entryPath.segmentCount() - 1);
                                if (libProjectPath.equals((Object)projectPath) || !affectedProjects.contains(libProjectPath)) break;
                                this.state.addBuildpathValidation(scriptProject);
                            }
                        }
                        ++j;
                    }
                }
                catch (ModelException modelException) {}
                ++i;
            }
        }
        return needCycleValidation;
    }

    public boolean updateCurrentDeltaAndIndex(IResourceDelta delta, int elementType, RootInfo rootInfo) {
        switch (delta.getKind()) {
            case 1: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.state.updateRoots(deltaRes.getFullPath(), delta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(element, delta);
                this.elementAdded(element, delta, rootInfo);
                if (elementType == 3) {
                    this.state.addBuildpathValidation(rootInfo.project);
                }
                return elementType == 4;
            }
            case 2: {
                IResource deltaRes = delta.getResource();
                Openable element = this.createElement(deltaRes, elementType, rootInfo);
                if (element == null) {
                    this.state.updateRoots(deltaRes.getFullPath(), delta, this);
                    return rootInfo != null && rootInfo.inclusionPatterns != null;
                }
                this.updateIndex(element, delta);
                this.elementRemoved(element, delta, rootInfo);
                if (elementType == 3) {
                    this.state.addBuildpathValidation(rootInfo.project);
                }
                if (deltaRes.getType() == 4) {
                    if (DLTKCore.DEBUG) {
                        System.out.println("Clearing last state for removed project : " + deltaRes);
                    }
                    this.manager.setLastBuiltState((IProject)deltaRes, null);
                    this.manager.previousSessionContainers.remove(element);
                }
                return elementType == 4;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0 || (flags & 0x100000) != 0) {
                    Openable element = this.createElement(delta.getResource(), elementType, rootInfo);
                    if (element == null) {
                        return false;
                    }
                    this.updateIndex(element, delta);
                    this.contentChanged(element);
                } else if (elementType == 2) {
                    boolean isDylanProject;
                    IProject res;
                    boolean wasDylanProject;
                    if ((flags & 0x4000) != 0) {
                        final IProject res2 = (IProject)delta.getResource();
                        Openable element = this.createElement((IResource)res2, elementType, rootInfo);
                        if (element == null) {
                            this.state.updateRoots(res2.getFullPath(), delta, this);
                            return false;
                        }
                        if (res2.isOpen()) {
                            if (DLTKLanguageManager.hasScriptNature(res2)) {
                                this.addToParentInfo(element);
                                this.currentDelta().opened(element);
                                this.state.updateRoots(element.getPath(), delta, this);
                                IScriptProject project = (IScriptProject)((Object)element);
                                this.rootsToRefresh.add(project);
                                this.projectCachesToReset.add(project);
                                this.postActions.add(new Runnable(){

                                    public void run() {
                                        ProjectIndexerManager.indexProject(res2);
                                    }
                                });
                            }
                        } else {
                            boolean wasDylanProject2;
                            boolean bl = wasDylanProject2 = this.state.findProject(res2.getName()) != null;
                            if (wasDylanProject2) {
                                this.close(element);
                                this.removeFromParentInfo(element);
                                this.currentDelta().closed(element);
                                this.manager.indexManager.discardJobs(element.getElementName());
                                IPath projectPath = res2.getFullPath();
                                this.manager.indexManager.removeIndexFamily(projectPath);
                                ProjectIndexerManager.removeProject(projectPath);
                            }
                        }
                        return false;
                    }
                    if ((flags & 0x80000) != 0 && (wasDylanProject = this.state.findProject((res = (IProject)delta.getResource()).getName()) != null) != (isDylanProject = DLTKLanguageManager.hasScriptNature(res))) {
                        Openable element = this.createElement((IResource)res, elementType, rootInfo);
                        if (element == null) {
                            return false;
                        }
                        if (isDylanProject) {
                            this.elementAdded(element, delta, rootInfo);
                            ProjectIndexerManager.indexProject(res);
                        } else {
                            this.elementRemoved(element, delta, rootInfo);
                            this.manager.indexManager.discardJobs(element.getElementName());
                            IPath projectPath = res.getFullPath();
                            this.manager.indexManager.removeIndexFamily(projectPath);
                            ProjectIndexerManager.removeProject(projectPath);
                            if (DLTKCore.DEBUG) {
                                System.out.println("Clearing last state for project loosing script nature: " + res);
                            }
                            this.manager.setLastBuiltState(res, null);
                        }
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIndex(Openable element, IResourceDelta delta) {
        IndexManager indexManager = this.manager.indexManager;
        if (indexManager == null) {
            return;
        }
        block0 : switch (element.getElementType()) {
            case 2: {
                switch (delta.getKind()) {
                    case 1: {
                        final IScriptProject scriptProject = element.getScriptProject();
                        this.postActions.add(new Runnable(){

                            public void run() {
                                ProjectIndexerManager.indexProject(scriptProject);
                            }
                        });
                        return;
                    }
                    case 2: {
                        IPath projectPath = element.getScriptProject().getProject().getFullPath();
                        indexManager.removeIndexFamily(projectPath);
                        ProjectIndexerManager.removeProject(projectPath);
                    }
                }
                return;
            }
            case 3: {
                if (element instanceof ArchiveProjectFragment || element instanceof ExternalProjectFragment) {
                    IProjectFragment root = (IProjectFragment)((Object)element);
                    IPath jarPath = root.getPath();
                    IScriptProject scriptProject = root.getScriptProject();
                    switch (delta.getKind()) {
                        case 1: {
                            ProjectIndexerManager.indexLibrary(scriptProject, jarPath);
                            return;
                        }
                        case 4: {
                            indexManager.removeIndex(jarPath);
                            ProjectIndexerManager.indexLibrary(scriptProject, jarPath);
                            return;
                        }
                        case 2: {
                            indexManager.discardJobs(jarPath.toString());
                            indexManager.removeIndex(jarPath);
                            ProjectIndexerManager.removeLibrary(scriptProject, jarPath);
                        }
                    }
                    return;
                }
                int kind = delta.getKind();
                if (kind == 1 || kind == 2) {
                    IProjectFragment root = (IProjectFragment)((Object)element);
                    this.updateRootIndex(root, (IPath)Path.EMPTY, delta);
                    return;
                }
            }
            case 4: {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: {
                        IScriptFolder pkg = null;
                        if (element instanceof IProjectFragment) {
                            IProjectFragment root = (IProjectFragment)((Object)element);
                            pkg = root.getScriptFolder((IPath)Path.EMPTY);
                        } else {
                            pkg = (IScriptFolder)((Object)element);
                        }
                        RootInfo rootInfo = this.rootInfo(pkg.getParent().getPath(), delta.getKind());
                        boolean isSource = rootInfo == null || rootInfo.entryKind == 3;
                        IResourceDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IResourceDelta child = children[i];
                            IResource resource = child.getResource();
                            if (resource instanceof IFile) {
                                String name = resource.getName();
                                if (isSource && Util.isValidSourceModule((IModelElement)pkg, resource)) {
                                    Openable cu = (Openable)((Object)pkg.getSourceModule(name));
                                    this.updateIndex(cu, child);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case 6: {
                IFile file = (IFile)delta.getResource();
                IPath binaryFolderPath = element.getProjectFragment().getPath();
                switch (delta.getKind()) {
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x100) == 0 && (flags & 0x100000) == 0) return;
                    }
                    case 2: {
                        String containerRelativePath = Util.relativePath(file.getFullPath(), binaryFolderPath.segmentCount());
                        indexManager.remove(containerRelativePath, binaryFolderPath);
                    }
                    default: {
                        return;
                    }
                }
            }
            case 5: {
                IFile file = (IFile)delta.getResource();
                switch (delta.getKind()) {
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x100) == 0 && (flags & 0x100000) == 0) return;
                    }
                    case 1: {
                        if (!ProjectIndexerManager.isIndexerEnabled(file.getProject())) return;
                        IDLTKLanguageToolkit toolkit = null;
                        toolkit = DLTKLanguageManager.getLanguageToolkit(element);
                        ProjectIndexerManager.indexSourceModule((ISourceModule)((Object)element), toolkit);
                        if (!DLTKCore.DEBUG) return;
                        System.err.println("update index: some actions are required to perform here....");
                        break block0;
                    }
                    case 2: {
                        IProject project = file.getProject();
                        String path = Util.relativePath(file.getFullPath(), 1);
                        indexManager.remove(path, project.getFullPath());
                        ProjectIndexerManager.removeSourceModule(DLTKCore.create(project), path);
                    }
                }
            }
        }
    }

    private ISourceElementParser getSourceElementParser(Openable element) {
        if (this.sourceElementParserCache == null) {
            this.sourceElementParserCache = this.manager.indexManager.getSourceElementParser(element.getScriptProject());
        }
        return this.sourceElementParserCache;
    }

    private SourceIndexerRequestor getSourceRequestor(Openable element) {
        if (this.sourceRequestorCache == null) {
            this.sourceRequestorCache = this.manager.indexManager.getSourceRequestor(element.getScriptProject());
        }
        return this.sourceRequestorCache;
    }

    public void updateModel(IModelElementDelta customDelta) {
        if (customDelta == null) {
            int i = 0;
            int length = this.modelDeltas.size();
            while (i < length) {
                IModelElementDelta delta = this.modelDeltas.get(i);
                this.modelUpdater.processDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processDelta(customDelta);
        }
    }

    private void updateRootIndex(IProjectFragment root, IPath pkgPath, IResourceDelta delta) {
        Openable pkg = (Openable)((Object)root.getScriptFolder(pkgPath));
        this.updateIndex(pkg, delta);
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        int length = children.length;
        while (i < length) {
            IResourceDelta child = children[i];
            IResource resource = child.getResource();
            if (resource instanceof IFolder) {
                this.updateRootIndex(root, pkgPath.append(resource.getName()), child);
            }
            ++i;
        }
    }

    public void clearCustomTimestampsFor(IModelElement[] elements) {
        Map<IPath, Long> timeStamps = this.state.getCustomTimeStamps();
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement e = iModelElementArray[n2];
            timeStamps.remove(e.getPath());
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FragmentCache
    extends HashMap<ScriptProject, IProjectFragment[]> {
        private FragmentCache() {
        }

        public IProjectFragment[] getAllFragments(ScriptProject project) throws ModelException {
            IProjectFragment[] fragments = (IProjectFragment[])this.get(project);
            if (fragments == null) {
                fragments = project.getAllProjectFragments();
                this.put(project, fragments);
            }
            return fragments;
        }
    }

    static class RootInfo {
        char[][] inclusionPatterns;
        char[][] exclusionPatterns;
        IPath rootPath;
        ScriptProject project;
        int entryKind;
        IProjectFragment root;

        RootInfo(ScriptProject project, IPath rootPath, char[][] inclusionPatterns, char[][] exclusionPatterns, int entryKind) {
            this.project = project;
            this.rootPath = rootPath;
            this.inclusionPatterns = inclusionPatterns;
            this.exclusionPatterns = exclusionPatterns;
            this.entryKind = entryKind;
        }

        IProjectFragment getProjectFragment(IResource resource) {
            if (this.root == null) {
                Object target;
                this.root = resource != null ? this.project.getProjectFragment(resource) : ((target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.rootPath, false)) instanceof IResource ? this.project.getProjectFragment((IResource)target) : this.project.getProjectFragment(this.rootPath.toOSString()));
            }
            return this.root;
        }

        boolean isRootOfProject(IPath path) {
            return this.rootPath.equals((Object)path) && this.project.getProject().getFullPath().isPrefixOf(path);
        }

        public String toString() {
            int length;
            int i;
            StringBuffer buffer = new StringBuffer("project=");
            if (this.project == null) {
                buffer.append("null");
            } else {
                buffer.append(this.project.getElementName());
            }
            buffer.append("\npath=");
            if (this.rootPath == null) {
                buffer.append("null");
            } else {
                buffer.append(this.rootPath.toString());
            }
            buffer.append("\nincluding=");
            if (this.inclusionPatterns == null) {
                buffer.append("null");
            } else {
                i = 0;
                length = this.inclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.inclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            buffer.append("\nexcluding=");
            if (this.exclusionPatterns == null) {
                buffer.append("null");
            } else {
                i = 0;
                length = this.exclusionPatterns.length;
                while (i < length) {
                    buffer.append(new String(this.exclusionPatterns[i]));
                    if (i < length - 1) {
                        buffer.append("|");
                    }
                    ++i;
                }
            }
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ZipStatus {
        EXTERNAL_ZIP_ADDED,
        EXTERNAL_ZIP_CHANGED,
        EXTERNAL_ZIP_REMOVED,
        EXTERNAL_ZIP_UNCHANGED,
        INTERNAL_ZIP_IGNORE;

    }
}

