/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IDLTKLanguageToolkitExtension;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.index2.IIndexer;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.core.search.indexing.AbstractJob;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.index2.IndexerManager;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.dltk.internal.core.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIndexRequest
extends AbstractJob {
    ProjectIndexer2 projectIndexer;
    ProgressJob progressJob;

    public AbstractIndexRequest(ProjectIndexer2 indexer, ProgressJob progressJob) {
        this.projectIndexer = indexer;
        this.progressJob = progressJob;
    }

    protected void reportToProgress(ISourceModule sourceModule) {
        if (this.progressJob != null) {
            IDLTKLanguageToolkit toolkit;
            IResource resource = sourceModule.getResource();
            String path = resource != null ? resource.getFullPath().toString() : ((toolkit = DLTKLanguageManager.getLanguageToolkit(sourceModule)) instanceof IDLTKLanguageToolkitExtension && ((IDLTKLanguageToolkitExtension)((Object)toolkit)).isArchiveFileName(sourceModule.getPath().toString()) ? ((ExternalSourceModule)sourceModule).getFullPath().toString() : EnvironmentPathUtils.getFile(sourceModule).getCanonicalPath());
            this.progressJob.subTask(path);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.projectIndexer == null ? 0 : this.projectIndexer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIndexRequest other = (AbstractIndexRequest)obj;
        return !(this.projectIndexer == null ? other.projectIndexer != null : !this.projectIndexer.equals(other.projectIndexer));
    }

    public void analyzeSourceModuleChanges(IPath containerPath, Collection<ISourceModule> sourceModules, Collection<String> toRemove, Collection<ISourceModule> toReindex) {
        IIndexer indexer = IndexerManager.getIndexer();
        if (indexer == null) {
            return;
        }
        Map<String, Long> documentNames = indexer.getDocuments(containerPath);
        if (documentNames == null || documentNames.isEmpty()) {
            toReindex.addAll(sourceModules);
            return;
        }
        toRemove.addAll(documentNames.keySet());
        for (ISourceModule sourceModule : sourceModules) {
            String relativePath = Util.relativePath(sourceModule.getPath(), containerPath.segmentCount());
            IFileHandle handle = EnvironmentPathUtils.getFile(sourceModule, false);
            if (toRemove.remove(relativePath)) {
                if (documentNames.get(relativePath) >= handle.lastModified()) continue;
                toReindex.add(sourceModule);
                continue;
            }
            toReindex.add(sourceModule);
        }
    }
}

