/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceableBlock;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.StatementBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionStatement
extends Expression
implements ISourceableBlock,
Documentable,
JSDeclaration,
JSScope {
    private Keyword functionKeyword;
    private Identifier name;
    private List<Argument> arguments = null;
    private StatementBlock body;
    private int LP = -1;
    private int RP = -1;
    private int colonPosition = -1;
    private Comment documentation;
    private final boolean declaration;
    private List<JSDeclaration> declarations;

    public FunctionStatement(JSNode parent, boolean declaration) {
        super(parent);
        this.declaration = declaration;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.functionKeyword != null) {
                this.functionKeyword.traverse(visitor);
            }
            if (this.name != null) {
                this.name.traverse(visitor);
            }
            if (this.arguments != null) {
                for (ASTNode aSTNode : this.arguments) {
                    aSTNode.traverse(visitor);
                }
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getFunctionKeyword() {
        return this.functionKeyword;
    }

    public void setFunctionKeyword(Keyword keyword) {
        this.functionKeyword = keyword;
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    @Override
    public Identifier getIdentifier() {
        return this.name;
    }

    public String getFunctionName() {
        return this.name != null ? this.name.getName() : "<anonymous>";
    }

    public List<Argument> getArguments() {
        return this.arguments != null ? this.arguments : Collections.emptyList();
    }

    public void addArgument(Argument argument) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<Argument>(4);
        }
        this.arguments.add(argument);
    }

    public Argument getArgument(String argumentName) {
        if (this.arguments != null && argumentName != null) {
            for (Argument argument : this.arguments) {
                if (!argumentName.equals(argument.getArgumentName())) continue;
                return argument;
            }
        }
        return null;
    }

    public StatementBlock getBody() {
        return this.body;
    }

    public void setBody(StatementBlock body) {
        this.body = body;
    }

    public boolean isEmptyBody() {
        return this.body == null || this.body.getStatements().isEmpty();
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public int getColonPosition() {
        return this.colonPosition;
    }

    public void setColonPosition(int colonPosition) {
        this.colonPosition = colonPosition;
    }

    @Override
    public Comment getDocumentation() {
        return this.documentation;
    }

    @Override
    public void setDocumentation(Comment documentation) {
        this.documentation = documentation;
    }

    @Override
    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("function");
        if (this.name != null) {
            buffer.append(" ");
            buffer.append(this.name.toSourceString(indentationString));
        }
        buffer.append(" (");
        int i = 0;
        while (i < this.getArguments().size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getArguments().get(i).toSourceString(indentationString));
            ++i;
        }
        buffer.append(")");
        buffer.append("\n");
        buffer.append(this.getBody().toSourceString(indentationString));
        return buffer.toString();
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    public boolean isDeclaration() {
        return this.declaration;
    }

    public boolean isInlineBlock() {
        if (!this.declaration) {
            if (this.getParent() instanceof CallExpression) {
                return true;
            }
            if (this.getParent() instanceof ParenthesizedExpression && ((ParenthesizedExpression)this.getParent()).getParent() instanceof CallExpression) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDeclaration(JSDeclaration declaration) {
        if (this.declarations == null) {
            this.declarations = new ArrayList<JSDeclaration>();
        }
        this.declarations.add(declaration);
    }

    @Override
    public List<JSDeclaration> getDeclarations() {
        return this.declarations != null ? this.declarations : Collections.emptyList();
    }
}

