/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.commands;

import org.eclipse.dltk.dbgp.DbgpBaseCommands;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlEntityParser;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpExtendedCommands
extends DbgpBaseCommands
implements IDbgpExtendedCommands {
    private IDbgpProperty parseResponse(Element response) {
        if (DbgpXmlParser.parseSuccess(response)) {
            NodeList list = response.getElementsByTagName("property");
            return DbgpXmlEntityParser.parseProperty((Element)list.item(0));
        }
        return null;
    }

    public DbgpExtendedCommands(IDbgpCommunicator communicator) throws DbgpException {
        super(communicator);
    }

    public boolean makeBreak() throws DbgpException {
        return DbgpXmlParser.parseSuccess(this.communicate(DbgpExtendedCommands.createAsyncRequest("break")));
    }

    public boolean configureStdin(int value) throws DbgpException {
        DbgpRequest request = DbgpExtendedCommands.createRequest("stdin");
        request.addOption("-c", value);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    public boolean sendStdin(String data) throws DbgpException {
        DbgpRequest request = DbgpExtendedCommands.createRequest("stdin");
        request.setData(data);
        return DbgpXmlParser.parseSuccess(this.communicate(request));
    }

    public IDbgpProperty evaluate(String snippet) throws DbgpException {
        DbgpRequest request = DbgpExtendedCommands.createRequest("eval");
        request.setData(snippet);
        return this.parseResponse(this.communicate(request));
    }

    public IDbgpProperty evaluate(String snippet, int depth) throws DbgpException {
        return this.evaluate(snippet);
    }

    public IDbgpProperty expression(String expression) throws DbgpException {
        DbgpRequest request = DbgpExtendedCommands.createRequest("expr");
        request.setData(expression);
        return this.parseResponse(this.communicate(request));
    }

    public IDbgpProperty execute(String code) throws DbgpException {
        DbgpRequest request = DbgpExtendedCommands.createRequest("exec");
        request.setData(code);
        return this.parseResponse(this.communicate(request));
    }
}

