/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.utils.ASTUtil;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.model.LocalVariable;
import org.eclipse.dltk.core.model.UnresolvedElement;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.MultiLineComment;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.core.NodeFinder;
import org.eclipse.dltk.javascript.internal.core.codeassist.SelectionVisitor;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinference.ValueReferenceUtil;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeRegion;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeUtil;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptSelectionEngine2
extends ScriptSelectionEngine {
    private static final boolean DEBUG = false;

    public static boolean isJSDocTypeSelectionEnabled() {
        return true;
    }

    private static boolean isStringLiteralInObjectLiteral(ASTNode node) {
        StringLiteral literal;
        if (node instanceof StringLiteral && (literal = (StringLiteral)node).getParent() instanceof PropertyInitializer) {
            PropertyInitializer initializer = (PropertyInitializer)literal.getParent();
            return initializer.getName() == literal;
        }
        return false;
    }

    public IModelElement[] select(final IModuleSource module, int position, int i) {
        if (!(module.getModelElement() instanceof ISourceModule) || i == -1) {
            return null;
        }
        String content = module.getSourceContents();
        if (position < 0 || position > content.length()) {
            return null;
        }
        Script script = JavaScriptParserUtil.parse((IModuleSource)module, null);
        NodeFinder finder = new NodeFinder(position, i + 1);
        finder.locate(script);
        ASTNode node = finder.getNode();
        if (node != null) {
            MultiLineComment comment;
            if (node instanceof Identifier || JavaScriptSelectionEngine2.isStringLiteralInObjectLiteral(node)) {
                final TypeInferencer2 inferencer2 = new TypeInferencer2();
                final SelectionVisitor visitor = new SelectionVisitor(inferencer2, node);
                inferencer2.setVisitor(visitor);
                inferencer2.setModelElement(module.getModelElement());
                try {
                    inferencer2.doInferencing(script);
                }
                catch (PositionReachedException positionReachedException) {}
                final IValueReference value = visitor.getValue();
                if (value == null) {
                    return null;
                }
                ITypeSystem.CURRENT.runWith((ITypeSystem)inferencer2, new Runnable(){

                    public void run() {
                        JavaScriptSelectionEngine2.this.toModelElements(inferencer2, visitor, module, value);
                    }
                });
                return null;
            }
            if (node instanceof MultiLineComment && JavaScriptSelectionEngine2.isJSDocTypeSelectionEnabled() && (comment = (MultiLineComment)node).isDocumentation()) {
                JSDocSupport.TypeNode typeNode;
                JSDocTag tag = JSDocSupport.parse((Comment)comment).getTagAt(position);
                if (tag == null || position < tag.valueStart()) {
                    return null;
                }
                int valueOffset = tag.toValueOffset(position);
                if ("@param".equals(tag.name())) {
                    JSDocSupport.ParameterNode paramNode = JSDocSupport.parseParameter(tag);
                    if (paramNode != null) {
                        if (paramNode.isInParameter(valueOffset)) {
                            Argument argument;
                            FunctionStatement function = JavaScriptSelectionEngine2.findFunctionByDocumentation(script, comment);
                            if (function != null && (argument = function.getArgument(paramNode.name)) != null) {
                                return new IModelElement[]{new LocalVariable(module.getModelElement(), paramNode.name, argument.start(), argument.end(), argument.start(), argument.end() - 1, null)};
                            }
                        } else if (paramNode.isInType(valueOffset)) {
                            this.findTypeInTypeExpression(module, tag, paramNode, valueOffset);
                        }
                    }
                } else if ("@return".equals(tag.name()) || "@returns".equals(tag.name())) {
                    JSDocSupport.TypedElementNode typedNode = JSDocSupport.parseOptionalType(tag);
                    if (typedNode != null && typedNode.isInType(valueOffset)) {
                        this.findTypeInTypeExpression(module, tag, typedNode, valueOffset);
                    }
                } else if ("@type".equals(tag.name()) && (typeNode = JSDocSupport.parseType(tag)) != null && typeNode.isInType(valueOffset)) {
                    this.findTypeInTypeExpression(module, tag, typeNode, valueOffset);
                }
            }
        }
        return null;
    }

    private void findTypeInTypeExpression(IModuleSource module, JSDocTag tag, JSDocSupport.TypedElementNode node, int valueOffset) {
        Type type;
        ISourceModule m = (ISourceModule)module.getModelElement();
        TypeInferencer2 inferencer2 = new TypeInferencer2();
        inferencer2.setModelElement(module.getModelElement());
        JSDocTypeRegion typeRegion = JSDocTypeUtil.findTypeAt(inferencer2, node.getTypeExpression(), valueOffset - node.getTypeExpressionStart());
        if (typeRegion != null && (type = inferencer2.getKnownType(typeRegion.name())) != null) {
            int typeOffsetInFile = tag.fromValueOffset(typeRegion.start() + node.getTypeExpressionStart());
            this.convertAndReportElement(m, type, (ISourceRange)new SourceRange(typeOffsetInFile, typeRegion.length()));
        }
    }

    @Nullable
    private static FunctionStatement findFunctionByDocumentation(Script script, MultiLineComment comment) {
        for (FunctionStatement function : ASTUtil.select((ASTNode)script, FunctionStatement.class, (boolean)true)) {
            if (function.getDocumentation() != comment && JSDocSupport.getComment((JSNode)function) != comment) continue;
            return function;
        }
        return null;
    }

    private void toModelElements(TypeInferencer2 inferencer2, SelectionVisitor visitor, IModuleSource module, IValueReference value) {
        ReferenceKind kind = value.getKind();
        ReferenceLocation location = value.getLocation();
        ISourceModule m = (ISourceModule)module.getModelElement();
        if (kind == ReferenceKind.ARGUMENT || kind == ReferenceKind.LOCAL) {
            if (location == ReferenceLocation.UNKNOWN) {
                return;
            }
            IModelElement result = this.locateModelElement(location);
            if (result != null && (result.getElementType() == 8 || result.getElementType() == 9)) {
                this.reportElement(result);
                return;
            }
            IRType type = JavaScriptValidations.typeOf(value);
            this.reportElement(new LocalVariable((IModelElement)m, value.getName(), location.getDeclarationStart(), location.getDeclarationEnd(), location.getNameStart(), location.getNameEnd() - 1, type == null ? null : type.getName()));
            return;
        }
        if (kind == ReferenceKind.FUNCTION || kind == ReferenceKind.GLOBAL || kind == ReferenceKind.FIELD) {
            if (location == ReferenceLocation.UNKNOWN) {
                return;
            }
            IModelElement result = this.locateModelElement(location);
            if (result != null) {
                this.reportElement(result);
                return;
            }
        } else if (kind == ReferenceKind.PROPERTY) {
            List<Property> properties = ValueReferenceUtil.extractElements(value, Property.class);
            if (properties != null) {
                this.convertAndReportElements(m, properties);
                return;
            }
            IModelElement result = this.locateModelElement(location);
            if (result != null) {
                this.reportElement(result);
                return;
            }
        } else if (kind == ReferenceKind.METHOD) {
            List<IRMethod> methods = ValueReferenceUtil.extractElements(value, IRMethod.class);
            if (methods != null) {
                IRMethod method;
                IValueReference[] arguments = visitor.getArguments();
                if (arguments == null) {
                    arguments = new IValueReference[]{};
                }
                if ((method = JavaScriptValidations.selectMethod(methods, arguments, true)).getSource() instanceof Method) {
                    this.convertAndReportElement(m, (Method)method.getSource(), null);
                    return;
                }
            }
        } else if (kind == ReferenceKind.TYPE) {
            LinkedHashSet t = new LinkedHashSet();
            JSTypeSet types = value.getDeclaredTypes();
            if (types != null) {
                Collections.addAll(t, types.toArray());
            }
            if ((types = value.getTypes()) != null) {
                Collections.addAll(t, types.toArray());
            }
            if (!t.isEmpty()) {
                this.convertAndReportElements(m, t);
                return;
            }
        }
        if (location != ReferenceLocation.UNKNOWN && location.getSourceModule() != null) {
            this.reportElement(new UnresolvedElement((IModelElement)location.getSourceModule(), value.getName(), location.getNameStart(), location.getNameEnd() - 1));
            return;
        }
    }

    private void convertAndReportElements(ISourceModule module, Collection<? extends Element> elements) {
        for (Element element : elements) {
            this.convertAndReportElement(module, element, null);
        }
    }

    private void convertAndReportElement(ISourceModule module, Element element, ISourceRange range) {
        try {
            IModelElement me = this.convert(module, element);
            this.reportElement(me != null ? me : element, range);
        }
        catch (ModelException modelException) {}
    }

    private IModelElement convert(ISourceModule module, Element element) throws ModelException {
        Type type = element instanceof Type ? (Type)element : ((Member)element).getDeclaringType();
        if (type != null && type.getKind() == TypeKind.PREDEFINED) {
            ArrayList<String> path = new ArrayList<String>();
            path.add(type.getName());
            if (element != type) {
                path.add(element.getName());
            }
            return this.resolveBuiltin(module.getScriptProject(), path);
        }
        if (type != null && type.getKind() == TypeKind.JAVASCRIPT) {
            ReferenceLocation location = (ReferenceLocation)element.getAttribute("LOCATION");
            if (location != null && location != ReferenceLocation.UNKNOWN) {
                if (element instanceof Property) {
                    return new LocalVariable((IModelElement)module, element.getName(), location.getDeclarationStart(), location.getDeclarationEnd(), location.getNameStart(), location.getNameEnd() - 1, null);
                }
                IModelElement result = this.locateModelElement(location);
                if (result != null) {
                    return result;
                }
            } else {
                IModelElement[] children;
                IModelElement[] iModelElementArray = children = module.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement modelElement = iModelElementArray[n2];
                    if (modelElement.getElementType() == 9 && modelElement.getElementName().equals(type.getName())) {
                        IModelElement[] children2;
                        IModelElement[] iModelElementArray2 = children2 = ((IParent)modelElement).getChildren();
                        int n3 = children2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray2[n4];
                            if (child.getElementName().equals(element.getName())) {
                                return child;
                            }
                            ++n4;
                        }
                        return modelElement;
                    }
                    ++n2;
                }
            }
        }
        return TypeInfoManager.convertElement(module, element);
    }

    private IModelElement locateModelElement(ReferenceLocation location) {
        ISourceModule module = location.getSourceModule();
        if (module != null) {
            try {
                ScriptModelUtil.reconcile((ISourceModule)module);
                module.accept((IModelElementVisitor)new Visitor(location.getNameStart(), location.getNameEnd()));
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (ModelElementFound e) {
                return e.element;
            }
        }
        return null;
    }

    private IModelElement resolveBuiltin(IScriptProject project, List<String> segments) throws ModelException {
        IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
        int n = iProjectFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment fragment = iProjectFragmentArray[n2];
            if (fragment.isBuiltin()) {
                ISourceModule m = fragment.getScriptFolder((IPath)Path.EMPTY).getSourceModule("builtins.js");
                if (!m.exists()) {
                    return null;
                }
                ISourceModule me = m;
                block1: for (String segment : segments) {
                    if (me instanceof IParent) {
                        IModelElement[] children;
                        IModelElement[] iModelElementArray = children = ((IParent)me).getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement child = iModelElementArray[n4];
                            if (segment.equals(child.getElementName())) {
                                me = child;
                                continue block1;
                            }
                            ++n4;
                        }
                    }
                    return null;
                }
                return me;
            }
            ++n2;
        }
        return null;
    }

    private static class ModelElementFound
    extends RuntimeException {
        final IModelElement element;

        public ModelElementFound(IModelElement element) {
            this.element = element;
        }
    }

    private static class Visitor
    implements IModelElementVisitor {
        private final int nameStart;
        private final int nameEnd;

        public Visitor(int nameStart, int nameEnd) {
            this.nameStart = nameStart;
            this.nameEnd = nameEnd;
        }

        public boolean visit(IModelElement element) {
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                try {
                    ISourceRange range = member.getNameRange();
                    if (range.getOffset() == this.nameStart && range.getLength() == this.nameEnd - this.nameStart) {
                        throw new ModelElementFound(element);
                    }
                }
                catch (ModelException modelException) {}
            }
            return true;
        }
    }
}

