/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.Collection;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureRequestor;
import org.eclipse.dltk.javascript.internal.search.ArgumentDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.TypeReferenceNode;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeReferencePredicate
extends AbstractMatchingPredicate<MatchingNode> {
    final ITypeSystem context;

    public TypeReferencePredicate(ITypeSystem context, TypeReferencePattern pattern) {
        super((SearchPattern)pattern, TypeReferencePredicate.concat(pattern.qualification, pattern.simpleName));
        this.context = context;
    }

    private static char[] concat(char[] qualification, char[] simpleName) {
        if (qualification != null) {
            ISearchPatternProcessor patternProcessor = DLTKLanguageManager.getSearchPatternProcessor((String)"org.eclipse.dltk.javascript.core.nature");
            char[] separator = (patternProcessor != null ? patternProcessor.getDelimiterReplacementString() : "/").toCharArray();
            return CharOperation.concat((char[])CharOperation.replace((char[])qualification, (char[])new char[]{'$'}, (char[])separator), (char[])separator, (char[])simpleName);
        }
        return simpleName;
    }

    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            MatchLevel level = this.matchTypeName(mNode.method.getType());
            if (level != null) {
                return level;
            }
            for (IModelBuilder.IParameter parameter : mNode.method.getParameters()) {
                level = this.matchTypeName(parameter.getType());
                if (level == null) continue;
                return level;
            }
        } else {
            if (node instanceof FieldDeclarationNode) {
                FieldDeclarationNode fNode = (FieldDeclarationNode)node;
                return this.matchTypeName(fNode.declaredType);
            }
            if (node instanceof LocalVariableDeclarationNode && !(node instanceof ArgumentDeclarationNode)) {
                LocalVariableDeclarationNode vNode = (LocalVariableDeclarationNode)node;
                return this.matchTypeName(vNode.declaredType);
            }
            if (node instanceof TypeReferenceNode) {
                TypeReferenceNode ref = (TypeReferenceNode)node;
                return this.matchTypeNames(ref.typeNames);
            }
        }
        return null;
    }

    private MatchLevel matchTypeNames(Collection<String> typeNames) {
        MatchLevel result = null;
        for (String typeName : typeNames) {
            MatchLevel level = this.matchName(typeName, MatchLevel.ACCURATE_MATCH);
            if (level == null || result != null && level.compareTo((Enum)result) <= 0) continue;
            result = level;
        }
        return result;
    }

    private MatchLevel matchTypeName(JSType type) {
        if (type == null) {
            return null;
        }
        return this.matchTypeNames(StructureRequestor.collectContainedTypeNames(type));
    }
}

