/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.javascript.typeinfo.TypeCircularDependency;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.utils.CompoundIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQuery {
    protected final List<Type> types = new ArrayList<Type>();
    static final int ROOT = 1;
    static final int SUPERTYPES = 2;
    static final int TRAITS = 4;

    public TypeQuery() {
    }

    public TypeQuery(Type type) {
        this.add(type);
    }

    public void add(Type type) {
        this.types.add(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        boolean first = true;
        for (Type type : this.types) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(type.getName());
        }
        sb.append(")");
        return sb.toString();
    }

    protected boolean isValid(Type type) {
        return true;
    }

    public List<Type> getHierarchy() {
        ArrayList<Type> result = new ArrayList<Type>();
        TypeIterator i = new TypeIterator();
        while (i.hasNext()) {
            result.add((Type)i.next());
        }
        return result;
    }

    public Iterable<Type> getAllTraits() {
        return new TypeIterable(4);
    }

    public TypeCircularDependency checkCircularDependencies(Type currentType) {
        Stack<Type> visited = new Stack<Type>();
        for (Type type : this.types) {
            visited.push(type);
        }
        return this.checkCircularDependencies(currentType, visited);
    }

    private TypeCircularDependency checkCircularDependencies(Type currentType, Stack<Type> visitedTypes) {
        TypeCircularDependency dependency;
        assert (currentType != null);
        assert (visitedTypes != null);
        int duplicateIndex = visitedTypes.indexOf(currentType);
        if (duplicateIndex != -1) {
            ArrayList<Type> loop = new ArrayList<Type>(visitedTypes.subList(duplicateIndex, visitedTypes.size()));
            ArrayList<Type> pathToLoop = duplicateIndex == 0 ? Collections.emptyList() : new ArrayList<Type>(visitedTypes.subList(0, duplicateIndex));
            return new TypeCircularDependency(loop, pathToLoop);
        }
        visitedTypes.push(currentType);
        if (currentType.getSuperType() != null && (dependency = this.checkCircularDependencies(currentType.getSuperType(), visitedTypes)) != null) {
            return dependency;
        }
        for (Type trait : currentType.getTraits()) {
            TypeCircularDependency dependency2 = this.checkCircularDependencies(trait, visitedTypes);
            if (dependency2 == null) continue;
            return dependency2;
        }
        visitedTypes.pop();
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeIterable
    implements Iterable<Type> {
        private final int flags;

        public TypeIterable(int flags) {
            this.flags = flags;
        }

        @Override
        public Iterator<Type> iterator() {
            return new TypeIterator(this.flags);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeIterator
    extends CompoundIterator<Type> {
        private final Set<Type> visited = new HashSet<Type>();
        private final List<Type> queue = new ArrayList<Type>();
        private final List<Type> skipQueue = new ArrayList<Type>();
        private final int flags;

        public TypeIterator() {
            this(7);
        }

        public TypeIterator(int flags) {
            this.flags = flags;
            if (TypeQuery.this.types != null) {
                if ((flags & 1) != 0) {
                    this.queue.addAll(TypeQuery.this.types);
                } else {
                    this.skipQueue.addAll(TypeQuery.this.types);
                }
            }
            this.current = this.queue.iterator();
        }

        private boolean canVisit(Type type) {
            return this.visited.add(type);
        }

        protected boolean fetchNext() {
            block8: {
                do {
                    if (!this.skipQueue.isEmpty()) {
                        this.queue.addAll(this.skipQueue);
                        this.skipQueue.clear();
                    }
                    if (this.queue.isEmpty()) break block8;
                    Type[] copy = this.queue.toArray(new Type[this.queue.size()]);
                    this.queue.clear();
                    Type[] typeArray = copy;
                    int n = copy.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Type type = typeArray[n2];
                        Type superType = type.getSuperType();
                        if (superType != null && this.canVisit(superType) && TypeQuery.this.isValid(superType)) {
                            if ((this.flags & 2) != 0) {
                                this.queue.add(superType);
                            } else {
                                this.skipQueue.add(superType);
                            }
                        }
                        if ((this.flags & 4) != 0) {
                            for (Type trait : type.getTraits()) {
                                if (!this.canVisit(trait) || !TypeQuery.this.isValid(trait)) continue;
                                this.queue.add(trait);
                            }
                        }
                        ++n2;
                    }
                } while (this.queue.isEmpty());
                this.current = this.queue.iterator();
                return true;
            }
            return false;
        }
    }
}

