/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text;

import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ScriptElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private ScriptEditor fEditor;
    private boolean fUseCodeResolve = false;

    public ScriptElementProvider(IEditorPart editor) {
        if (editor instanceof ScriptEditor) {
            this.fEditor = (ScriptEditor)editor;
        }
    }

    public ScriptElementProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = ScriptWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection sel;
            if (this.fUseCodeResolve && !(sel = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return sel.getFirstElement();
            }
            IModelElement element = SelectionConverter.getElementAtOffset((IEditorPart)this.fEditor);
            if (element != null) {
                return element;
            }
            return EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, false);
        }
        catch (ModelException modelException) {
            return null;
        }
    }
}

