/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.browsing.LogicalPackagesProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class PackagesViewHierarchicalContentProvider
extends LogicalPackagesProvider
implements ITreeContentProvider {
    public PackagesViewHierarchicalContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IModelElement) {
                IModelElement iJavaElement = (IModelElement)parentElement;
                int type = iJavaElement.getElementType();
                switch (type) {
                    case 2: {
                        IProjectFragment root;
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IScriptProject project = (IScriptProject)parentElement;
                        IScriptFolder[] topLevelChildren = this.getTopLevelChildrenByElementName((IModelElement[])project.getScriptFolders());
                        ArrayList<IScriptFolder> list = new ArrayList<IScriptFolder>();
                        int i = 0;
                        while (i < topLevelChildren.length) {
                            IScriptFolder fragment = topLevelChildren[i];
                            IModelElement el = fragment.getParent();
                            if (!(!(el instanceof IProjectFragment) || (root = (IProjectFragment)el).isArchive() && root.isExternal())) {
                                list.add(fragment);
                            }
                            ++i;
                        }
                        IProjectFragment[] packageFragmentRoots = project.getProjectFragments();
                        ArrayList<Object> folders = new ArrayList<Object>();
                        int i2 = 0;
                        while (i2 < packageFragmentRoots.length) {
                            root = packageFragmentRoots[i2];
                            IResource resource = root.getUnderlyingResource();
                            if (resource != null && resource instanceof IFolder) {
                                folders.addAll(this.getFolders(((IFolder)resource).members()));
                            }
                            ++i2;
                        }
                        Object[] logicalPackages = this.combineSamePackagesIntoLogialPackages(list.toArray(new IScriptFolder[list.size()]));
                        if (folders.size() > 0) {
                            if (logicalPackages.length > 0) {
                                folders.addAll(Arrays.asList(logicalPackages));
                            }
                            return folders.toArray();
                        }
                        return logicalPackages;
                    }
                    case 3: {
                        IProjectFragment root = (IProjectFragment)parentElement;
                        this.fMapToLogicalPackage.clear();
                        this.fMapToPackageFragments.clear();
                        IResource resource = root.getUnderlyingResource();
                        if (root.isArchive()) {
                            Object[] fragments = new IScriptFolder[]{};
                            IModelElement[] els = root.getChildren();
                            fragments = this.getTopLevelChildrenByElementName(els);
                            this.addFragmentsToMap((IScriptFolder[])fragments);
                            return fragments;
                        }
                        if (resource != null && resource instanceof IFolder) {
                            List children = this.getFoldersAndElements(((IFolder)resource).members());
                            IScriptFolder defaultPackage = root.getScriptFolder("");
                            if (defaultPackage.exists()) {
                                children.add(defaultPackage);
                            }
                            this.addFragmentsToMap(children);
                            return children.toArray();
                        }
                        return NO_CHILDREN;
                    }
                    case 4: {
                        IScriptFolder packageFragment = (IScriptFolder)parentElement;
                        if (packageFragment.isRootFolder()) {
                            return NO_CHILDREN;
                        }
                        IProjectFragment parent = (IProjectFragment)packageFragment.getParent();
                        Object[] fragments = this.findNextLevelChildrenByElementName(parent, packageFragment);
                        this.addFragmentsToMap((IScriptFolder[])fragments);
                        Object[] nonJavaResources = packageFragment.getForeignResources();
                        if (nonJavaResources.length == 0) {
                            return fragments;
                        }
                        ArrayList<Object> combined = new ArrayList<Object>();
                        combined.addAll(Arrays.asList(fragments));
                        int i = 0;
                        while (i < nonJavaResources.length) {
                            Object curr = nonJavaResources[i];
                            if (curr instanceof IFolder) {
                                combined.add(curr);
                            }
                            ++i;
                        }
                        return combined.toArray();
                    }
                }
            } else {
                if (parentElement instanceof LogicalPackage) {
                    ArrayList<IScriptFolder> children = new ArrayList<IScriptFolder>();
                    LogicalPackage logicalPackage = (LogicalPackage)((Object)parentElement);
                    IScriptFolder[] elements = logicalPackage.getScriptFolders();
                    int i = 0;
                    while (i < elements.length) {
                        IScriptFolder fragment = elements[i];
                        IScriptFolder[] objects = this.findNextLevelChildrenByElementName((IProjectFragment)fragment.getParent(), fragment);
                        children.addAll(Arrays.asList(objects));
                        ++i;
                    }
                    return this.combineSamePackagesIntoLogialPackages(children.toArray(new IScriptFolder[children.size()]));
                }
                if (parentElement instanceof IFolder) {
                    IFolder folder = (IFolder)parentElement;
                    IResource[] resources = folder.members();
                    List children = this.getFoldersAndElements(resources);
                    this.addFragmentsToMap(children);
                    return children.toArray();
                }
            }
        }
        catch (Exception exception) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    private void addFragmentsToMap(List elements) {
        ArrayList packageFragments = new ArrayList();
        for (Object elem : elements) {
            if (!(elem instanceof IScriptFolder)) continue;
            packageFragments.add(elem);
        }
        this.addFragmentsToMap(packageFragments.toArray(new IScriptFolder[packageFragments.size()]));
    }

    private List getFoldersAndElements(IResource[] resources) throws CoreException {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IModelElement element = DLTKCore.create((IResource)folder);
                if (element instanceof IScriptFolder) {
                    list.add(element);
                } else {
                    list.add(folder);
                }
            }
            ++i;
        }
        return list;
    }

    private List getFolders(IResource[] resources) throws CoreException {
        ArrayList<IFolder> list = new ArrayList<IFolder>();
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IModelElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = DLTKCore.create((IResource)(folder = (IFolder)resource))) == null) {
                list.add(folder);
            }
            ++i;
        }
        return list;
    }

    private IScriptFolder[] findNextLevelChildrenByElementName(IProjectFragment parent, IScriptFolder fragment) {
        ArrayList<IScriptFolder> list = new ArrayList<IScriptFolder>();
        try {
            IModelElement[] children = parent.getChildren();
            String fragmentname = fragment.getElementName();
            int i = 0;
            while (i < children.length) {
                IModelElement element = children[i];
                if (element instanceof IScriptFolder) {
                    String tail;
                    IScriptFolder frag = (IScriptFolder)element;
                    String name = element.getElementName();
                    if (name.length() > fragmentname.length() && name.charAt(fragmentname.length()) == '.' && frag.exists() && !"".equals(fragmentname) && name.startsWith(fragmentname) && !name.equals(fragmentname) && !"".equals(tail = name.substring(fragmentname.length() + 1)) && tail.indexOf(46) == -1) {
                        list.add(frag);
                    }
                }
                ++i;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return list.toArray(new IScriptFolder[list.size()]);
    }

    private IScriptFolder[] getTopLevelChildrenByElementName(IModelElement[] elements) {
        ArrayList<IModelElement> topLevelElements = new ArrayList<IModelElement>();
        int i = 0;
        while (i < elements.length) {
            IModelElement iJavaElement = elements[i];
            if (iJavaElement instanceof IScriptFolder && iJavaElement.getElementName().indexOf(46) == -1) {
                topLevelElements.add(iJavaElement);
            }
            ++i;
        }
        return topLevelElements.toArray(new IScriptFolder[topLevelElements.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getParent(Object element) {
        try {
            if (element instanceof IScriptFolder) {
                IScriptFolder fragment = (IScriptFolder)element;
                if (!fragment.exists()) {
                    return null;
                }
                Object parent = this.getHierarchicalParent(fragment);
                if (!(parent instanceof IScriptFolder)) return parent;
                IScriptFolder pkgFragment = (IScriptFolder)parent;
                LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
                if (logicalPkg != null) {
                    return logicalPkg;
                }
                LogicalPackage lp = this.createLogicalPackage(pkgFragment);
                if (lp != null) return lp;
                return pkgFragment;
            }
            if (!(element instanceof LogicalPackage)) {
                if (!(element instanceof IFolder)) return null;
                IFolder folder = (IFolder)element;
                IContainer res = folder.getParent();
                IModelElement el = DLTKCore.create((IResource)res);
                if (el == null) return res;
                return el;
            }
            LogicalPackage el = (LogicalPackage)((Object)element);
            IScriptFolder fragment = el.getScriptFolders()[0];
            Object parent = this.getHierarchicalParent(fragment);
            if (!(parent instanceof IScriptFolder)) return fragment.getScriptProject();
            IScriptFolder pkgFragment = (IScriptFolder)parent;
            LogicalPackage logicalPkg = this.findLogicalPackage(pkgFragment);
            if (logicalPkg != null) {
                return logicalPkg;
            }
            LogicalPackage lp = this.createLogicalPackage(pkgFragment);
            if (lp != null) return lp;
            return pkgFragment;
        }
        catch (Exception e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private LogicalPackage createLogicalPackage(IScriptFolder pkgFragment) {
        if (!this.fInputIsProject) {
            return null;
        }
        ArrayList<IScriptFolder> fragments = new ArrayList<IScriptFolder>();
        try {
            IProjectFragment[] roots = pkgFragment.getScriptProject().getProjectFragments();
            int i = 0;
            while (i < roots.length) {
                IProjectFragment root = roots[i];
                IScriptFolder fragment = root.getScriptFolder(pkgFragment.getElementName());
                if (fragment.exists() && !fragment.equals(pkgFragment)) {
                    fragments.add(fragment);
                }
                ++i;
            }
            if (!fragments.isEmpty()) {
                LogicalPackage logicalPackage = new LogicalPackage(pkgFragment);
                this.fMapToLogicalPackage.put(this.getKey(pkgFragment), logicalPackage);
                for (IScriptFolder f : fragments) {
                    if (!logicalPackage.belongs(f)) continue;
                    logicalPackage.add(f);
                    this.fMapToLogicalPackage.put(this.getKey(f), logicalPackage);
                }
                return logicalPackage;
            }
        }
        catch (Exception e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private Object getHierarchicalParent(IScriptFolder fragment) throws Exception {
        IModelElement parent = fragment.getParent();
        if (parent instanceof IProjectFragment && parent.exists()) {
            IProjectFragment root = (IProjectFragment)parent;
            if (root.isArchive() || !fragment.exists()) {
                return this.findNextLevelParentByElementName(fragment);
            }
            IResource resource = fragment.getUnderlyingResource();
            if (resource != null && resource instanceof IFolder) {
                IFolder folder = (IFolder)resource;
                IContainer res = folder.getParent();
                IModelElement el = DLTKCore.create((IResource)res);
                if (el != null) {
                    return el;
                }
                return res;
            }
        }
        return parent;
    }

    private Object findNextLevelParentByElementName(IScriptFolder child) {
        String name = child.getElementName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IScriptFolder element = ((IProjectFragment)child.getParent()).getScriptFolder(realParentName);
            if (element.exists()) {
                return element;
            }
        }
        return child.getParent();
    }

    public boolean hasChildren(Object element) {
        IScriptFolder fragment;
        if (element instanceof IScriptFolder && ((fragment = (IScriptFolder)element).isRootFolder() || !fragment.exists())) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    @Override
    protected void processDelta(IModelElementDelta delta) {
        block14: {
            Object input;
            int kind = delta.getKind();
            IModelElement element = delta.getElement();
            if (this.isClassPathChange(delta) && (input = this.fViewer.getInput()) != null) {
                if (this.fInputIsProject && input.equals(element.getScriptProject())) {
                    this.postRefresh(input);
                    return;
                }
                if (!this.fInputIsProject && input.equals(element)) {
                    if (element.exists()) {
                        this.postRefresh(input);
                    } else {
                        this.postRemove(input);
                    }
                    return;
                }
            }
            if (kind == 2 && (input = this.fViewer.getInput()) != null && input.equals(element)) {
                this.postRemove(input);
                return;
            }
            if (element instanceof IScriptFolder) {
                IScriptFolder frag = (IScriptFolder)element;
                if (kind == 2) {
                    this.removeElement(frag);
                    return;
                }
                if (kind == 1) {
                    Object parent = this.getParent(frag);
                    this.addElement(frag, parent);
                    return;
                }
                if (kind == 4) {
                    LogicalPackage logicalPkg = this.findLogicalPackage(frag);
                    if (logicalPkg != null) {
                        this.postRefresh(this.findElementToRefresh((Object)logicalPkg));
                    } else {
                        this.postRefresh(this.findElementToRefresh(frag));
                    }
                    return;
                }
            }
            try {
                this.processAffectedChildren(delta);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block14;
                e.printStackTrace();
            }
        }
    }

    private Object findElementToRefresh(Object object) {
        Object toBeRefreshed = object;
        if (this.fViewer.testFindItem(object) == null) {
            Object parent = this.getParent(object);
            if (parent instanceof IProjectFragment && this.fInputIsProject) {
                parent = ((IProjectFragment)parent).getScriptProject();
            }
            if (parent != null) {
                toBeRefreshed = parent;
            }
        }
        return toBeRefreshed;
    }

    private void processAffectedChildren(IModelElementDelta delta) throws Exception {
        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            if (!(affectedChildren[i] instanceof ISourceModule)) {
                this.processDelta(affectedChildren[i]);
            }
            ++i;
        }
    }

    private void postAdd(final Object child, final Object parent) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).add(parent, child);
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).remove(object);
                }
            }
        });
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                Control ctrl = PackagesViewHierarchicalContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ((TreeViewer)PackagesViewHierarchicalContentProvider.this.fViewer).refresh(object);
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    private void addElement(IScriptFolder frag, Object parent) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null && lp.belongs(frag)) {
            lp.add(frag);
            return;
        }
        IScriptFolder iPackageFragment = (IScriptFolder)this.fMapToPackageFragments.get(key);
        if (iPackageFragment != null && !iPackageFragment.equals(frag)) {
            lp = new LogicalPackage(iPackageFragment);
            lp.add(frag);
            this.fMapToLogicalPackage.put(key, lp);
            if (parent instanceof IProjectFragment) {
                IProjectFragment root = (IProjectFragment)parent;
                if (this.fInputIsProject) {
                    this.postRefresh(root.getScriptProject());
                } else {
                    this.postRefresh(root);
                }
            } else {
                this.postAdd((Object)lp, parent);
                this.postRemove(iPackageFragment);
            }
        } else {
            this.fMapToPackageFragments.put(key, frag);
            if (parent instanceof IProjectFragment) {
                IProjectFragment root = (IProjectFragment)parent;
                if (this.fInputIsProject) {
                    this.postAdd(frag, root.getScriptProject());
                } else {
                    this.postAdd(frag, root);
                }
            } else {
                this.postAdd(frag, parent);
            }
        }
    }

    private void removeElement(IScriptFolder frag) {
        String key = this.getKey(frag);
        LogicalPackage lp = (LogicalPackage)((Object)this.fMapToLogicalPackage.get(key));
        if (lp != null) {
            lp.remove(frag);
            if (lp.getScriptFolders().length == 1) {
                IScriptFolder fragment = lp.getScriptFolders()[0];
                this.fMapToPackageFragments.put(key, fragment);
                this.fMapToLogicalPackage.remove(key);
                this.postRemove((Object)lp);
                Object parent = this.getParent(fragment);
                if (parent instanceof IProjectFragment) {
                    parent = ((IProjectFragment)parent).getScriptProject();
                }
                this.postAdd(fragment, parent);
            }
        } else {
            IScriptFolder fragment = (IScriptFolder)this.fMapToPackageFragments.get(key);
            if (fragment != null && fragment.equals(frag)) {
                this.fMapToPackageFragments.remove(key);
                this.postRemove(frag);
            }
        }
    }
}

