/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JavaScriptRemoteTab
extends AbstractLaunchConfigurationTab {
    private static final int DEFAULT_PORT = 9000;
    private static final String DEFAULT_SESSION_ID = "javascript_debug";
    private Text portText;
    private Text sessionIdText;
    private Text timeoutText;

    private int getPort() {
        return Integer.parseInt(this.portText.getText());
    }

    private void setPort(int port) {
        this.portText.setText(Integer.toString(port));
    }

    private String getSessionId() {
        return this.sessionIdText.getText();
    }

    private void setSessionId(String id) {
        this.sessionIdText.setText(id);
    }

    private int getTimeout() {
        return Integer.parseInt(this.timeoutText.getText());
    }

    private void setTimeout(int timeout) {
        this.timeoutText.setText(Integer.toString(timeout));
    }

    protected void createInstruction(Composite parent, Object data) {
        Label instruction = new Label(parent, 0);
        instruction.setLayoutData(data);
        instruction.setText("To start TCL debugging engine use this command temlate:");
    }

    protected void createPathTemplate(Composite parent, Object data) {
        Text text = new Text(parent, 0);
        text.setText("${DEBUGGIN_ENGINE} -host-ide ${HOST} -port-ide ${PORT} -app-shell ${TCL_INTERPRETER} -ide-key ${SESSION_ID} -app-file {TCL_FILE}");
    }

    protected void createConnectionPropertiesGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText("Connection Properties");
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        Label portLabel = new Label((Composite)group, 0);
        portLabel.setText("Local port:");
        this.portText = new Text((Composite)group, 2048);
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaScriptRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.portText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label idLabel = new Label((Composite)group, 0);
        idLabel.setText("Connection id:");
        this.sessionIdText = new Text((Composite)group, 2048);
        this.sessionIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaScriptRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.sessionIdText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label timeoutLabel = new Label((Composite)group, 0);
        timeoutLabel.setText("Waiting timeout:");
        this.timeoutText = new Text((Composite)group, 2048);
        this.timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaScriptRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.timeoutText.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createConnectionPropertiesGroup(composite, new GridData(4, 0, true, false));
        this.createInstruction(composite, new GridData(4, 0, true, false));
        this.createPathTemplate(composite, new GridData(4, 0, true, false));
    }

    public String getName() {
        return "Tcl Remote Properties";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int port = configuration.getAttribute("dbpg_port", -1);
            this.setPort(port != -1 ? port : 9000);
            String sessionId = configuration.getAttribute("dbgp_session_id", null);
            this.setSessionId(sessionId != null ? sessionId : DEFAULT_SESSION_ID);
            int timeout = configuration.getAttribute("dbpg_waiting_timeout", DLTKDebugPlugin.getConnectionTimeout());
            this.setTimeout(timeout);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            this.setErrorMessage(null);
            configuration.setAttribute("dbgp_remote", true);
            configuration.setAttribute("dbpg_port", this.getPort());
            configuration.setAttribute("dbgp_session_id", this.getSessionId());
            configuration.setAttribute("dbpg_waiting_timeout", this.getTimeout());
        }
        catch (NumberFormatException e) {
            this.setErrorMessage("Should be a number instead of string");
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("dbpg_port", 9000);
        configuration.setAttribute("dbgp_session_id", DEFAULT_SESSION_ID);
        configuration.setAttribute("dbpg_waiting_timeout", DLTKDebugPlugin.getConnectionTimeout());
    }
}

