/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.javascript.core.manipulation.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.StatementAnalyzer;
import org.eclipse.dltk.javascript.core.dom.BlockStatement;
import org.eclipse.dltk.javascript.core.dom.BreakStatement;
import org.eclipse.dltk.javascript.core.dom.ContinueStatement;
import org.eclipse.dltk.javascript.core.dom.DoStatement;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.ForEachInStatement;
import org.eclipse.dltk.javascript.core.dom.ForInStatement;
import org.eclipse.dltk.javascript.core.dom.ForStatement;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Label;
import org.eclipse.dltk.javascript.core.dom.LabeledStatement;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.WhileStatement;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class ExtractMethodAnalyzer
extends StatementAnalyzer {
    public static final int ERROR = -2;
    public static final int UNDEFINED = -1;
    public static final int NO = 0;
    public static final int EXPRESSION = 1;
    public static final int ACCESS_TO_LOCAL = 2;
    public static final int RETURN_STATEMENT_VOID = 3;
    public static final int RETURN_STATEMENT_VALUE = 4;
    public static final int MULTIPLE = 5;
    private Node fEnclosingNode;
    private int fReturnKind;
    private String fReturnTypeName;
    private FlowInfo fInputFlowInfo;
    private FlowContext fInputFlowContext;
    private VariableBinding[] fArguments;
    private VariableBinding[] fMethodLocals;
    private VariableBinding fReturnValue;
    private VariableBinding[] fCallerLocals;
    private VariableBinding fReturnLocal;
    private boolean fIsLastStatementSelected;
    private Label fEnclosingLoopLabel;

    public ExtractMethodAnalyzer(ISourceModule unit, Selection selection) {
        super(unit, selection, false);
    }

    public Node getEnclosingNode() {
        return this.fEnclosingNode;
    }

    public int getReturnKind() {
        return this.fReturnKind;
    }

    public String getReturnTypeName() {
        return this.fReturnTypeName;
    }

    public VariableBinding[] getArguments() {
        return this.fArguments;
    }

    public VariableBinding[] getMethodLocals() {
        return this.fMethodLocals;
    }

    public VariableBinding getReturnValue() {
        return this.fReturnValue;
    }

    public VariableBinding[] getCallerLocals() {
        return this.fCallerLocals;
    }

    public VariableBinding getReturnLocal() {
        return this.fReturnLocal;
    }

    public RefactoringStatus checkInitialConditions(Source root) {
        int returns;
        RefactoringStatus result = this.getStatus();
        this.traverse(root);
        if (result.hasFatalError()) {
            return result;
        }
        this.fReturnKind = -1;
        if (this.analyzeSelection(result).hasFatalError()) {
            return result;
        }
        int n = returns = this.fReturnKind == 0 ? 0 : 1;
        if (this.fReturnValue != null) {
            this.fReturnKind = 2;
            ++returns;
        }
        if (this.isExpressionSelected()) {
            this.fReturnKind = 1;
            ++returns;
        }
        if (returns > 1) {
            this.fReturnKind = 5;
            this.addFatalError(result, RefactoringCoreMessages.ExtractMethodAnalyzer_ambiguous_return_value);
            return result;
        }
        this.initReturnType();
        return result;
    }

    private void addFatalError(RefactoringStatus status, String message) {
        SourceRange range = new SourceRange(this.getSelection().getOffset(), this.getSelection().getLength());
        status.addFatalError(message, ScriptStatusContext.create((ISourceModule)this.fCUnit, (ISourceRange)range));
    }

    private void addError(RefactoringStatus status, String message) {
        SourceRange range = new SourceRange(this.getSelection().getOffset(), this.getSelection().getLength());
        status.addError(message, ScriptStatusContext.create((ISourceModule)this.fCUnit, (ISourceRange)range));
    }

    private void addWarning(RefactoringStatus status, String message) {
        SourceRange range = new SourceRange(this.getSelection().getOffset(), this.getSelection().getLength());
        status.addWarning(message, ScriptStatusContext.create((ISourceModule)this.fCUnit, (ISourceRange)range));
    }

    private void initReturnType() {
        this.fReturnTypeName = null;
        switch (this.fReturnKind) {
            case 2: {
                this.fReturnTypeName = this.fReturnValue.getTypeName();
                break;
            }
            case 4: {
                this.fEnclosingNode.eClass().getClassifierID();
            }
        }
    }

    private RefactoringStatus analyzeSelection(RefactoringStatus status) {
        String canHandleBranchesProblem;
        Map<Identifier, VariableBinding> bindings = VariableLookup.findBindings(this.fEnclosingNode);
        this.fInputFlowContext = new FlowContext(bindings);
        this.fInputFlowContext.setConsiderAccessMode(true);
        this.fInputFlowContext.setComputeMode(FlowContext.Mode.ARGUMENTS);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(this.fInputFlowContext);
        this.fInputFlowInfo = flowAnalyzer.perform(this.getSelectedNodes());
        if (this.fInputFlowInfo.branches() && (canHandleBranchesProblem = this.canHandleBranches()) != null) {
            this.addFatalError(status, canHandleBranchesProblem);
            this.fReturnKind = -2;
            return status;
        }
        if (this.fInputFlowInfo.isValueReturn()) {
            this.fReturnKind = 4;
        } else if (this.fInputFlowInfo.isVoidReturn() || this.fInputFlowInfo.isPartialReturn() && this.isLastStatementSelected()) {
            this.fReturnKind = 3;
        } else if (this.fInputFlowInfo.isNoReturn() || this.fInputFlowInfo.isThrow() || this.fInputFlowInfo.isUndefined()) {
            this.fReturnKind = 0;
        }
        if (this.fReturnKind == -1) {
            this.addError(status, RefactoringCoreMessages.FlowAnalyzer_execution_flow);
            this.fReturnKind = 0;
        }
        this.computeInput();
        this.computeOutput(status, bindings);
        if (status.hasFatalError()) {
            return status;
        }
        this.adjustArgumentsAndMethodLocals();
        return status;
    }

    private String canHandleBranches() {
        BlockStatement block;
        EList<Statement> statements;
        Statement lastStatementInLoop;
        if (this.fReturnValue != null) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        Node[] selectedNodes = this.getSelectedNodes();
        Node lastSelectedNode = selectedNodes[selectedNodes.length - 1];
        Statement body = this.getParentLoopBody((Node)lastSelectedNode.eContainer());
        if (!(body instanceof Block)) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        if (body != lastSelectedNode && lastSelectedNode != (lastStatementInLoop = (Statement)(statements = (block = (BlockStatement)body).getStatements()).get(statements.size() - 1))) {
            return RefactoringCoreMessages.ExtractMethodAnalyzer_branch_mismatch;
        }
        int i = 0;
        while (i < selectedNodes.length) {
            Node node = selectedNodes[i];
            ArrayList<String> localLoopLabels = new ArrayList<String>();
            TreeIterator it = node.eAllContents();
            block6: while (it.hasNext()) {
                Node cur = (Node)it.next();
                switch (node.eClass().getClassifierID()) {
                    case 44: {
                        Label label = ((BreakStatement)cur).getLabel();
                        if (label == null || localLoopLabels.contains(label.getName())) continue block6;
                        return Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_break_mismatch, new Object[]{"break " + label.getName()});
                    }
                    case 43: {
                        Label label = ((ContinueStatement)cur).getLabel();
                        if (!(label == null || localLoopLabels.contains(label.getName()) || this.fEnclosingLoopLabel != null && label.getName().equals(this.fEnclosingLoopLabel.getName()))) {
                            return Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_branch_continue_mismatch, new Object[]{"continue " + label.getName()});
                        }
                    }
                    case 51: {
                        Label label = ((LabeledStatement)cur).getLabel();
                        if (label == null) break;
                        localLoopLabels.add(label.getName());
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private Statement getParentLoopBody(Node node) {
        Statement stmt = null;
        Node start = node;
        while (!(start == null || start instanceof ForStatement || start instanceof DoStatement || start instanceof WhileStatement || start instanceof ForInStatement || start instanceof ForEachInStatement)) {
            start = (Node)start.eContainer();
        }
        if (start instanceof ForStatement) {
            stmt = ((ForStatement)start).getBody();
        } else if (start instanceof DoStatement) {
            stmt = ((DoStatement)start).getBody();
        } else if (start instanceof WhileStatement) {
            stmt = ((WhileStatement)start).getBody();
        } else if (start instanceof ForInStatement) {
            stmt = ((ForInStatement)start).getBody();
        } else if (start instanceof ForEachInStatement) {
            stmt = ((ForEachInStatement)start).getBody();
        }
        if (start.eContainer() instanceof LabeledStatement) {
            LabeledStatement labeledStatement = (LabeledStatement)start.eContainer();
            this.fEnclosingLoopLabel = labeledStatement.getLabel();
        }
        return stmt;
    }

    public boolean isLastStatementSelected() {
        return this.fIsLastStatementSelected;
    }

    private void computeLastStatementSelected() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            this.fIsLastStatementSelected = false;
        } else {
            BlockStatement body = null;
            if (this.fEnclosingNode instanceof FunctionExpression) {
                body = ((FunctionExpression)this.fEnclosingNode).getBody();
            }
            if (body != null) {
                EList<Statement> statements = body.getStatements();
                this.fIsLastStatementSelected = nodes[nodes.length - 1] == statements.get(statements.size() - 1);
            }
        }
    }

    private void computeInput() {
        int argumentMode = 54;
        this.fArguments = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, argumentMode));
        this.fMethodLocals = this.removeSelectedDeclarations(this.fInputFlowInfo.get(this.fInputFlowContext, 24));
    }

    private VariableBinding[] removeSelectedDeclarations(VariableBinding[] bindings) {
        ArrayList<VariableBinding> result = new ArrayList<VariableBinding>(bindings.length);
        Selection selection = this.getSelection();
        int i = 0;
        while (i < bindings.length) {
            Identifier decl = bindings[i].getDeclaration();
            if (!selection.covers(decl)) {
                result.add(bindings[i]);
            }
            ++i;
        }
        return result.toArray(new VariableBinding[result.size()]);
    }

    private void computeOutput(RefactoringStatus status, Map<Identifier, VariableBinding> bindings) {
        VariableBinding write;
        VariableBinding[] closureRW;
        Object read;
        FlowContext flowContext = new FlowContext(bindings);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.Mode.RETURN_VALUES);
        FlowInfo returnInfo = new InOutFlowAnalyzer(flowContext).perform(this.getSelectedNodes());
        VariableBinding[] returnValues = returnInfo.get(flowContext, 56);
        InOutFlowAnalyzer analyzer = new InOutFlowAnalyzer(flowContext);
        analyzer.perform(new Node[]{this.fEnclosingNode});
        GenericConditionalFlowInfo closureInfo = analyzer.closureInfo;
        VariableBinding[] closureReads = closureInfo.get(flowContext, 6);
        VariableBinding[] variableBindingArray = returnValues;
        int n = returnValues.length;
        int n2 = 0;
        while (n2 < n) {
            VariableBinding binding = variableBindingArray[n2];
            VariableBinding[] variableBindingArray2 = closureReads;
            int n3 = closureReads.length;
            int n4 = 0;
            while (n4 < n3) {
                read = variableBindingArray2[n4];
                if (read == binding) {
                    this.addWarning(status, Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_closure, binding.getName()));
                }
                ++n4;
            }
            ++n2;
        }
        read = closureRW = closureInfo.get(flowContext, 32);
        int n5 = closureRW.length;
        n = 0;
        while (n < n5) {
            VariableBinding binding = read[n];
            this.addWarning(status, Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_closure, binding.getName()));
            ++n;
        }
        IRegion region = this.getSelectedNodeRange();
        Selection selection = Selection.createFromStartLength(region.getOffset(), region.getLength());
        ArrayList<VariableBinding> localReads = new ArrayList<VariableBinding>();
        flowContext.setComputeMode(FlowContext.Mode.ARGUMENTS);
        FlowInfo argInfo = new InputFlowAnalyzer(flowContext, selection, true).perform(this.fEnclosingNode);
        VariableBinding[] reads = argInfo.get(flowContext, 38);
        VariableBinding[] closureWrites = closureInfo.get(flowContext, 24);
        VariableBinding[] variableBindingArray3 = reads;
        int n6 = reads.length;
        int n7 = 0;
        while (n7 < n6) {
            VariableBinding binding = variableBindingArray3[n7];
            VariableBinding[] variableBindingArray4 = closureWrites;
            int n8 = closureWrites.length;
            int n9 = 0;
            while (n9 < n8) {
                write = variableBindingArray4[n9];
                if (write == binding) {
                    this.addWarning(status, Messages.format(RefactoringCoreMessages.ExtractMethodAnalyzer_closure, binding.getName()));
                }
                ++n9;
            }
            ++n7;
        }
        int i = 0;
        while (i < returnValues.length && localReads.size() < returnValues.length) {
            VariableBinding binding = returnValues[i];
            int x = 0;
            while (x < reads.length) {
                if (reads[x] == binding) {
                    localReads.add(binding);
                    this.fReturnValue = binding;
                    break;
                }
                ++x;
            }
            ++i;
        }
        switch (localReads.size()) {
            case 0: {
                this.fReturnValue = null;
                break;
            }
            case 1: {
                break;
            }
            default: {
                this.fReturnValue = null;
                StringBuffer affectedLocals = new StringBuffer();
                int i2 = 0;
                while (i2 < localReads.size()) {
                    VariableBinding binding = (VariableBinding)localReads.get(i2);
                    affectedLocals.append(binding);
                    if (i2 != localReads.size() - 1) {
                        affectedLocals.append('\n');
                    }
                    ++i2;
                }
                String message = MessageFormat.format((String)RefactoringCoreMessages.ExtractMethodAnalyzer_assignments_to_local, (Object[])new Object[]{affectedLocals.toString()});
                this.addFatalError(status, message);
                return;
            }
        }
        ArrayList<VariableBinding> callerLocals = new ArrayList<VariableBinding>(5);
        FlowInfo localInfo = new InputFlowAnalyzer(flowContext, selection, false).perform(this.fEnclosingNode);
        VariableBinding[] writes = localInfo.get(flowContext, 56);
        int i3 = 0;
        while (i3 < writes.length) {
            write = writes[i3];
            if (this.getSelection().covers(write.getDeclaration())) {
                callerLocals.add(write);
            }
            ++i3;
        }
        this.fCallerLocals = callerLocals.toArray(new VariableBinding[callerLocals.size()]);
        if (this.fReturnValue != null && this.getSelection().covers(this.fReturnValue.getDeclaration())) {
            this.fReturnLocal = this.fReturnValue;
        }
    }

    private void adjustArgumentsAndMethodLocals() {
        int i = 0;
        while (i < this.fArguments.length) {
            VariableBinding argument = this.fArguments[i];
            if (this.fInputFlowInfo.hasAccessMode(this.fInputFlowContext, argument, 16)) {
                if (argument != this.fReturnValue) {
                    this.fArguments[i] = null;
                }
                if (this.fArguments[i] != null) {
                    int l = 0;
                    while (l < this.fMethodLocals.length) {
                        if (this.fMethodLocals[l] == argument) {
                            this.fMethodLocals[l] = null;
                        }
                        ++l;
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public Boolean caseSource(Source node) {
        RefactoringStatus status = this.getStatus();
        if (status.hasFatalError()) {
            return super.caseSource(node);
        }
        if (!this.hasSelectedNodes()) {
            status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_only_method_body);
            return super.caseSource(node);
        }
        Node cur = this.getFirstSelectedNode();
        boolean ok = true;
        while (ok) {
            cur = (Node)cur.eContainer();
            switch (cur.eClass().getClassifierID()) {
                case 20: 
                case 21: 
                case 56: 
                case 58: {
                    ok = false;
                }
            }
        }
        this.fEnclosingNode = cur;
        if (!this.isSingleExpressionOrStatementSet()) {
            status.addFatalError(RefactoringCoreMessages.ExtractMethodAnalyzer_single_expression_or_set);
            return super.caseSource(node);
        }
        this.computeLastStatementSelected();
        return super.caseSource(node);
    }

    private boolean isSingleExpressionOrStatementSet() {
        Node first = this.getFirstSelectedNode();
        if (first == null) {
            return true;
        }
        return !(first instanceof Expression) || this.getSelectedNodes().length == 1;
    }
}

