/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.utils.IntList;

public class ObjectInitializer
extends Expression {
    private final List<ObjectInitializerPart> initializers = new ArrayList<ObjectInitializerPart>();
    private int LC = -1;
    private int RC = -1;
    private IntList commas;
    private boolean multiline;

    public ObjectInitializer(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.initializers != null) {
                for (ASTNode aSTNode : this.initializers) {
                    aSTNode.traverse(visitor);
                }
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public List<ObjectInitializerPart> getInitializers() {
        return this.initializers;
    }

    public void addInitializer(ObjectInitializerPart initializer) {
        this.initializers.add(initializer);
    }

    public PropertyInitializer[] getPropertyInitializers() {
        ArrayList<PropertyInitializer> result = new ArrayList<PropertyInitializer>();
        for (ObjectInitializerPart part : this.initializers) {
            if (!(part instanceof PropertyInitializer)) continue;
            result.add((PropertyInitializer)part);
        }
        return result.toArray(new PropertyInitializer[result.size()]);
    }

    public Expression getValue(String propertyName) {
        PropertyInitializer property = this.getEntry(propertyName);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public PropertyInitializer getEntry(String propertyName) {
        for (ObjectInitializerPart part : this.initializers) {
            PropertyInitializer property;
            if (!(part instanceof PropertyInitializer) || !propertyName.equals((property = (PropertyInitializer)part).getNameAsString())) continue;
            return property;
        }
        return null;
    }

    public int getLC() {
        return this.LC;
    }

    public void setLC(int LC) {
        this.LC = LC;
    }

    public int getRC() {
        return this.RC;
    }

    public void setRC(int RC) {
        this.RC = RC;
    }

    public IntList getCommas() {
        return this.commas;
    }

    public void setCommas(IntList commas) {
        this.commas = commas;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{");
        int i = 0;
        while (i < this.initializers.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ObjectInitializer.toSourceString((ISourceable)((Object)this.initializers.get(i)), indentationString));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }
}

