/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationMultiStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.core.builder.IBuildParticipantExtension4;
import org.eclipse.dltk.internal.javascript.parser.JSDocValidatorFactory;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.IReferenceAttributes;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.validation.FlowValidation;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.MemberValidationEvent;
import org.eclipse.dltk.internal.javascript.validation.RMethodFunctionWrapper;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.core.JSBindings;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.internal.core.TemporaryBindings;
import org.eclipse.dltk.javascript.internal.core.ThreadTypeSystemImpl;
import org.eclipse.dltk.javascript.parser.ISuppressWarningsState;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection2;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.PhantomValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinference.ValueReferenceUtil;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRConstructor;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeExtension;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.IRVariable;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ITypeCheckerExtension;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.RUtils;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.Visibility;
import org.eclipse.dltk.javascript.validation.IValidatorExtension;
import org.eclipse.osgi.util.NLS;

public class TypeInfoValidator
implements IBuildParticipant,
IBuildParticipantExtension,
IBuildParticipantExtension4 {
    public static final String ID = "org.eclipse.dltk.javascript.core.buildParticipant.typeinfo";
    private boolean hasDependents;
    private TypeInferencer2 inferencer;
    public static final String ATTR_BINDINGS = String.valueOf(TypeInfoValidator.class.getName()) + ".BINDINGS";
    private static final int CACHED_BINDINGS_SIZE = 32;
    private static final ThreadLocal<Map<Script, JSBindings>> CACHED_BINDINGS = new ThreadLocal();
    static final boolean DEBUG = false;

    public boolean beginBuild(int buildType) {
        return true;
    }

    public void notifyDependents(IBuildParticipant[] dependents) {
        this.hasDependents = true;
    }

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        if (this.inferencer == null) {
            this.inferencer = this.createTypeInferencer();
        }
        this.inferencer.setModelElement((IModelElement)context.getSourceModule());
        this.inferencer.pushAttribute(ITypeInfoContext.BUILD_CONTEXT, context);
        Reporter reporter = JavaScriptValidations.createReporter(context);
        Set inconsistentReturns = (Set)context.get(JavaScriptValidations.ATTR_INCONSISTENT_RETURNS);
        ValidationVisitor visitor = new ValidationVisitor(this.inferencer, (JSProblemReporter)reporter, inconsistentReturns, this.hasDependents);
        this.inferencer.setVisitor(visitor);
        this.inferencer.doInferencing(script);
        if (this.hasDependents) {
            this.inferencer.resetLocalState();
            context.set(ATTR_BINDINGS, visitor.bindings);
            TypeInfoValidator.saveCachedBindings(script, new TemporaryBindings(this.inferencer, visitor.bindings));
            ((ThreadTypeSystemImpl)ITypeSystem.CURRENT).set(this.inferencer);
        }
    }

    public void afterBuild(IBuildContext context) {
        if (this.hasDependents) {
            ((ThreadTypeSystemImpl)ITypeSystem.CURRENT).set(null);
        }
    }

    public void endBuild(IProgressMonitor monitor) {
        TypeInfoValidator.removeCachedBindings();
        this.inferencer = null;
    }

    private static void saveCachedBindings(Script script, JSBindings bindings) {
        LinkedHashMap<Script, JSBindings> map = CACHED_BINDINGS.get();
        if (map == null) {
            map = new LinkedHashMap<Script, JSBindings>(42, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Script, JSBindings> eldest) {
                    return this.size() >= 32;
                }
            };
            CACHED_BINDINGS.set((Map<Script, JSBindings>)map);
        }
        map.put(script, bindings);
    }

    private static void removeCachedBindings() {
        Map<Script, JSBindings> map = CACHED_BINDINGS.get();
        if (map != null && !map.isEmpty()) {
            map.clear();
        }
    }

    public static JSBindings getCachedBindings(Script script) {
        Map<Script, JSBindings> map = CACHED_BINDINGS.get();
        if (map != null) {
            return map.get(script);
        }
        return null;
    }

    protected TypeInferencer2 createTypeInferencer() {
        return new TypeInferencer2();
    }

    private static class CallExpressionValidator
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final CallExpression node;
        private final IValueReference reference;
        private final IValueReference[] arguments;
        private final List<IRMethod> methods;

        public CallExpressionValidator(FunctionScope scope, CallExpression node, IValueReference reference, IValueReference[] arguments, List<IRMethod> methods) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.arguments = arguments;
            this.methods = methods;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            visitor.validateCallExpression(this.scope, this.node, this.reference, this.arguments, this.methods);
        }

        @Override
        public boolean isRelatedTo(IValueReference reference) {
            return reference.isParentOf(this.reference);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " - " + this.reference + "()";
        }
    }

    private static abstract class ExpressionValidator {
        private ISuppressWarningsState suppressed;

        abstract void call(ValidationVisitor var1);

        public ISuppressWarningsState getSuppressed() {
            return this.suppressed;
        }

        public void setSuppressed(ISuppressWarningsState suppressed) {
            this.suppressed = suppressed;
        }

        public boolean isRelatedTo(IValueReference reference) {
            return false;
        }
    }

    static class FunctionScope {
        final Set<Object> reported = new HashSet<Object>();
        final List<ReturnNode> returnNodes = new ArrayList<ReturnNode>();
        boolean throwsException;

        FunctionScope() {
        }

        void add(Path path) {
            if (path != null) {
                this.reported.add(path.start);
                this.reported.add(path.references[0]);
            }
        }

        boolean contains(Path path) {
            if (path != null) {
                if (this.reported.contains(path.start)) {
                    return true;
                }
                IValueReference[] iValueReferenceArray = path.references;
                int n = path.references.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueReference reference = iValueReferenceArray[n2];
                    if (this.reported.contains(reference)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    private static class NewExpressionValidator
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final NewExpression node;
        private final IValueReference reference;
        private final IValueReference typeReference;
        private final IValueReference[] arguments;
        private final IValueCollection collection;

        public NewExpressionValidator(FunctionScope scope, NewExpression node, IValueReference reference, IValueReference typeReference, IValueReference[] arguments, IValueCollection collection) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.typeReference = typeReference;
            this.arguments = arguments;
            this.collection = collection;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            visitor.validateNewExpression(this.scope, this.collection, this.node.getObjectClass(), this.reference, this.typeReference, this.arguments);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " - " + this.reference;
        }
    }

    static class Path {
        final Expression start;
        final IValueReference[] references;

        public Path(Expression start, IValueReference[] references) {
            this.start = start;
            this.references = references;
        }
    }

    private static class PropertyExpressionHolder
    extends ExpressionValidator {
        private final FunctionScope scope;
        private final PropertyExpression node;
        private final IValueReference reference;
        private final boolean exists;

        public PropertyExpressionHolder(FunctionScope scope, PropertyExpression node, IValueReference reference, boolean exists) {
            this.scope = scope;
            this.node = node;
            this.reference = reference;
            this.exists = exists;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            visitor.validateProperty(this.scope, this.node, this.reference, this.exists);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " - " + this.reference;
        }
    }

    private static class ReturnNode {
        final ReturnStatement node;
        final IValueReference returnValueReference;

        public ReturnNode(ReturnStatement node, IValueReference returnValueReference) {
            this.node = node;
            this.returnValueReference = returnValueReference;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.node).trim()) + " -> " + this.returnValueReference;
        }
    }

    private static class TestReturnStatement
    extends ExpressionValidator {
        private final List<ReturnNode> lst;
        private final IRMethod jsMethod;

        public TestReturnStatement(IRMethod jsMethod, List<ReturnNode> lst) {
            this.jsMethod = jsMethod;
            this.lst = lst;
        }

        @Override
        public void call(ValidationVisitor visitor) {
            IRType methodType = this.jsMethod.getType();
            IRType firstType = null;
            ReturnNode firstNode = null;
            for (ReturnNode element : this.lst) {
                if (element.returnValueReference == null) continue;
                IRType type = JavaScriptValidations.typeOf(element.returnValueReference);
                TypeCompatibility compatibility = null;
                if (methodType instanceof IRTypeExtension) {
                    IValidationStatus status = ((IRTypeExtension)((Object)methodType)).isAssignableFrom(element.returnValueReference);
                    if (status != null) {
                        if (status instanceof TypeCompatibility) {
                            compatibility = (TypeCompatibility)status;
                        } else if (status != ValidationStatus.OK) {
                            JavaScriptValidations.reportValidationStatus(visitor.getProblemReporter(), status, (ISourceNode)element.node, JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, ValidationMessages.DeclarationMismatchWithActualReturnType, this.jsMethod.getName());
                        }
                    }
                } else if (type != null && methodType != null) {
                    compatibility = methodType.isAssignableFrom(type);
                }
                if (compatibility != null && compatibility != TypeCompatibility.TRUE) {
                    ReturnStatement node = element.node;
                    visitor.getProblemReporter().reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE : JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE_PARAMETERIZATION), NLS.bind((String)ValidationMessages.DeclarationMismatchWithActualReturnType, (Object[])new String[]{this.jsMethod.getName(), TypeUtil.getName(methodType), TypeUtil.getName(type)}), node.sourceStart(), node.sourceEnd());
                }
                if (methodType != null || firstType != null || type == null) continue;
                firstType = type.normalize();
                firstNode = element;
            }
            if (firstType != null) {
                for (ReturnNode next : this.lst) {
                    IRType nextType;
                    if (next == firstNode || (nextType = JavaScriptValidations.typeOf(next.returnValueReference)) == null || (nextType = nextType.normalize()).isAssignableFrom(firstType).ok() || firstType.isAssignableFrom(nextType).ok()) continue;
                    visitor.getProblemReporter().reportProblem((IProblemIdentifier)JavaScriptProblems.RETURN_INCONSISTENT, NLS.bind((String)ValidationMessages.ReturnTypeInconsistentWithPreviousReturn, (Object[])new String[]{TypeUtil.getName(nextType), TypeUtil.getName(firstType)}), next.node.sourceStart(), next.node.sourceEnd());
                }
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " - " + this.jsMethod.getName();
        }
    }

    public static class ValidationVisitor
    extends TypeInferencerVisitor {
        private final List<ExpressionValidator> expressionValidators = new ArrayList<ExpressionValidator>();
        private final Set<FunctionStatement> inconsistentReturns;
        private final Map<ASTNode, VisitorMode> modes = new IdentityHashMap<ASTNode, VisitorMode>();
        private final Stack<ASTNode> visitStack = new Stack();
        final Map<ASTNode, IValueReference> bindings;
        private IValidatorExtension[] extensions;
        private final Stack<FunctionScope> functionScopes = new Stack();
        private final List<ValidationStatus> statuses = new ArrayList<ValidationStatus>();
        private final List<IValueReference> variables = new ArrayList<IValueReference>();
        private MemberValidationEvent memberValidationEvent;

        public ValidationVisitor(ITypeInferenceContext context, JSProblemReporter reporter, Set<FunctionStatement> inconsistentReturns) {
            this(context, reporter, inconsistentReturns, false);
        }

        public ValidationVisitor(ITypeInferenceContext context, JSProblemReporter reporter, Set<FunctionStatement> inconsistentReturns, boolean hasDependents) {
            super(context);
            this.reporter = reporter;
            this.inconsistentReturns = inconsistentReturns;
            this.bindings = hasDependents ? new HashMap() : null;
        }

        @Override
        public IValueReference visit(ASTNode node) {
            this.visitStack.push(node);
            try {
                IValueReference value = super.visit(node);
                if (this.bindings != null && value != null) {
                    this.bindings.put(node, value);
                }
                IValueReference iValueReference = value;
                return iValueReference;
            }
            finally {
                this.visitStack.pop();
            }
        }

        @Override
        public void initialize() {
            super.initialize();
            this.modes.clear();
            this.visitStack.clear();
            this.expressionValidators.clear();
            this.variables.clear();
            this.functionScopes.clear();
            this.functionScopes.add(new FunctionScope());
            List<IValidatorExtension> extensions = TypeInfoManager.createExtensions(this.context, IValidatorExtension.class, null);
            this.extensions = !extensions.isEmpty() ? extensions.toArray(new IValidatorExtension[extensions.size()]) : null;
            if (this.getTypeChecker() instanceof ITypeCheckerExtension) {
                ((ITypeCheckerExtension)this.getTypeChecker()).setExtensions(this.extensions);
            }
        }

        @Override
        @NonNull
        public ITypeChecker getTypeChecker() {
            ITypeChecker result = super.getTypeChecker();
            if (result == null) {
                this.typeChecker = result = new JSDocValidatorFactory.TypeChecker(this.context, this.reporter);
            }
            return result;
        }

        @Override
        public void done() {
            super.done();
            if (this.inconsistentReturns != null && !this.inconsistentReturns.isEmpty() && this.reporter instanceof Reporter) {
                Reporter r = (Reporter)this.reporter;
                for (FunctionStatement statement : this.inconsistentReturns) {
                    FlowValidation.reportInconsistentReturn(r, statement);
                }
            }
            this.runDelayedValidations();
            for (IValueReference variable : this.variables) {
                IRVariable jsVariable;
                if (variable.getAttribute(IReferenceAttributes.ACCESS) != null || (jsVariable = (IRVariable)variable.getAttribute("R_VARIABLE")) != null && jsVariable.isSuppressed(JavaScriptProblems.UNUSED_VARIABLE)) continue;
                ReferenceLocation location = variable.getLocation();
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNUSED_VARIABLE, NLS.bind((String)"Variable {0} is never used", (Object)variable.getName()), location.getNameStart(), location.getNameEnd());
            }
            ((JSDocValidatorFactory.TypeChecker)this.typeChecker).validate();
        }

        public void runDelayedValidations() {
            if (this.expressionValidators.isEmpty()) {
                return;
            }
            ExpressionValidator[] copy = this.expressionValidators.toArray(new ExpressionValidator[this.expressionValidators.size()]);
            this.expressionValidators.clear();
            this.runExpressionValidations(Arrays.asList(copy));
        }

        public void runDelayedValidationsFor(IValueReference ... references) {
            if (this.expressionValidators.isEmpty() || references.length == 0) {
                return;
            }
            ArrayList<ExpressionValidator> selected = new ArrayList<ExpressionValidator>();
            Iterator<ExpressionValidator> i = this.expressionValidators.iterator();
            block0: while (i.hasNext()) {
                ExpressionValidator validator = i.next();
                IValueReference[] iValueReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueReference reference = iValueReferenceArray[n2];
                    if (validator.isRelatedTo(reference)) {
                        selected.add(validator);
                        i.remove();
                        continue block0;
                    }
                    ++n2;
                }
            }
            if (!selected.isEmpty()) {
                this.runExpressionValidations(selected);
            }
        }

        private void runExpressionValidations(Iterable<ExpressionValidator> validators) {
            ISuppressWarningsState suppressWarnings = this.reporter.getSuppressWarnings();
            try {
                for (ExpressionValidator validator : validators) {
                    this.reporter.restoreSuppressWarnings(validator.getSuppressed());
                    validator.call(this);
                }
            }
            finally {
                this.reporter.restoreSuppressWarnings(suppressWarnings);
            }
        }

        private VisitorMode currentMode() {
            VisitorMode mode = this.modes.get(this.visitStack.peek());
            return mode != null ? mode : VisitorMode.NORMAL;
        }

        @Override
        public IValueReference visitNewExpression(NewExpression node) {
            TypeInferencerVisitor.VisitNewResult result = this.visitNew(node);
            if (result.getTypeValue() != null) {
                this.pushExpressionValidator(new NewExpressionValidator(this.peekFunctionScope(), node, result.getValue(), result.getTypeValue(), result.getArguments(), this.peekContext()));
            }
            return result.getValue();
        }

        private static Path path(Expression expression, IValueReference reference) {
            ArrayList<IValueReference> refs;
            block5: {
                refs = new ArrayList<IValueReference>(8);
                do {
                    if (expression instanceof PropertyExpression) {
                        expression = ((PropertyExpression)expression).getObject();
                    } else if (expression instanceof CallExpression) {
                        expression = ((CallExpression)expression).getExpression();
                    } else {
                        if (!(expression instanceof GetArrayItemExpression)) break block5;
                        expression = ((GetArrayItemExpression)expression).getArray();
                    }
                    refs.add(reference);
                } while ((reference = reference.getParent()) != null);
                return null;
            }
            refs.add(reference);
            return new Path(expression, refs.toArray(new IValueReference[refs.size()]));
        }

        protected final FunctionScope peekFunctionScope() {
            return this.functionScopes.peek();
        }

        public void enterFunctionScope() {
            this.functionScopes.push(new FunctionScope());
        }

        public void leaveFunctionScope(IRMethod method, FunctionStatement function) {
            FunctionScope scope = this.functionScopes.pop();
            if (method != null) {
                if (this.inconsistentReturns != null && method.getType() != null && RTypes.isUndefined(method.getType())) {
                    this.inconsistentReturns.remove(function);
                }
                if (!scope.returnNodes.isEmpty()) {
                    this.pushExpressionValidator(new TestReturnStatement(method, scope.returnNodes));
                } else if (!scope.throwsException && method.getType() != null && !RTypes.isUndefined(method.getType())) {
                    ReferenceLocation location = RUtils.locationOf(method);
                    if (location == null) {
                        return;
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DECLARATION_MISMATCH_ACTUAL_RETURN_TYPE, NLS.bind((String)ValidationMessages.DeclarationMismatchNoReturnType, (Object[])new String[]{method.getName(), TypeUtil.getName(method.getType())}), location.getNameStart(), location.getNameEnd());
                }
            }
        }

        @Override
        public IValueReference visitFunctionStatement(FunctionStatement node) {
            this.enterFunctionScope();
            IValueReference reference = super.visitFunctionStatement(node);
            IRMethod method = (IRMethod)reference.getAttribute("R_METHOD");
            this.leaveFunctionScope(method, node);
            return reference;
        }

        @Override
        protected JSMethod createMethod(FunctionStatement node) {
            this.validateHidesByFunction(node);
            return super.createMethod(node);
        }

        private void validateHidesByFunction(FunctionStatement node) {
            Property property;
            IValueCollection peekContext = this.peekContext();
            boolean inlineBlock = node.isInlineBlock();
            for (Argument argument : node.getArguments()) {
                IValueReference child;
                if (inlineBlock && "undefined".equals(argument.getArgumentName()) || !(child = peekContext.getChild(argument.getArgumentName())).exists()) continue;
                if (child.getKind() == ReferenceKind.PROPERTY) {
                    property = ValueReferenceUtil.extractElement(child, Property.class);
                    if (property.isHideAllowed()) continue;
                    if (property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesPropertyOfType, (Object[])new String[]{argument.getArgumentName(), property.getDeclaringType().getName()}), argument.sourceStart(), argument.sourceEnd());
                        continue;
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesProperty, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                if (Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) continue;
                if (child.getKind() == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.ParameterHidesFunction, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
                    continue;
                }
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.PARAMETER_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.ParameterHidesVariable, (Object)argument.getArgumentName()), argument.sourceStart(), argument.sourceEnd());
            }
            if (node.isDeclaration()) {
                IValueReference child;
                IValueCollection parentScope = ValidationVisitor.getParentScope(peekContext);
                if (parentScope == null) {
                    child = peekContext.getChild(node.getName().getName());
                    if (this.getSource().equals(child.getLocation().getSource())) {
                        return;
                    }
                } else {
                    child = parentScope.getChild(node.getName().getName());
                }
                if (child.exists()) {
                    ReferenceKind kind = child.getKind();
                    if (kind == ReferenceKind.PROPERTY) {
                        property = ValueReferenceUtil.extractElement(child, Property.class);
                        if (!property.isHideAllowed()) {
                            if (property.getDeclaringType() != null) {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesPropertyOfType, (Object[])new String[]{node.getName().getName(), property.getDeclaringType().getName()}), node.getName().sourceStart(), node.getName().sourceEnd());
                            } else {
                                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesProperty, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                            }
                        }
                    } else if (!Boolean.TRUE.equals(child.getAttribute("HIDE_ALLOWED"))) {
                        if (kind == ReferenceKind.FUNCTION) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.FunctionHidesFunction, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        } else if (kind == ReferenceKind.LOCAL || kind == ReferenceKind.GLOBAL) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_VARIABLE, NLS.bind((String)ValidationMessages.FunctionHidesVariable, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.FUNCTION_HIDES_PREDEFINED, NLS.bind((String)ValidationMessages.FunctionHidesPredefinedIdentifier, (Object)node.getName().getName()), node.getName().sourceStart(), node.getName().sourceEnd());
                        }
                    }
                }
            }
        }

        @Override
        public IValueReference visitReturnStatement(ReturnStatement node) {
            IValueReference returnValueReference = super.visitReturnStatement(node);
            if (node.getValue() != null) {
                this.peekFunctionScope().returnNodes.add(new ReturnNode(node, returnValueReference));
            }
            return returnValueReference;
        }

        @Override
        public IValueReference visitThrowStatement(ThrowStatement node) {
            this.peekFunctionScope().throwsException = true;
            return super.visitThrowStatement(node);
        }

        @Override
        public IValueReference visitCallExpression(CallExpression node) {
            IRType expressionType;
            Expression expression = node.getExpression();
            this.modes.put((ASTNode)expression, VisitorMode.CALL);
            IValueReference reference = this.visit((ASTNode)expression);
            this.modes.remove(expression);
            if (reference == null) {
                this.visitList(node.getArguments());
                return null;
            }
            if (reference.getAttribute("PHANTOM", true) != null) {
                this.visitList(node.getArguments());
                return PhantomValueReference.REFERENCE;
            }
            if (ValidationVisitor.isUntyped(reference)) {
                this.visitList(node.getArguments());
                return null;
            }
            if (reference.getKind() == ReferenceKind.ARGUMENT && reference.getDeclaredTypes().contains(RTypes.FUNCTION)) {
                for (ASTNode argument : node.getArguments()) {
                    this.visit(argument);
                }
                return null;
            }
            List args = node.getArguments();
            IValueReference[] arguments = new IValueReference[args.size()];
            int i = 0;
            int size = args.size();
            while (i < size) {
                arguments[i] = this.visit((ASTNode)args.get(i));
                ++i;
            }
            List<IRMethod> methods = ValueReferenceUtil.extractElements(reference, IRMethod.class);
            if (methods != null && methods.size() == 1) {
                IRMethod method = methods.get(0);
                IValueReference ref = this.checkSpecialJavascriptFunctionCalls(reference, arguments, method);
                if (ref != null) {
                    return ref;
                }
                if (method.isGeneric()) {
                    if (!JavaScriptValidations.checkParameterCount(method, args.size())) {
                        Expression methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
                        this.reportMethodParameterError((ASTNode)methodNode, arguments, method);
                        return null;
                    }
                    IRType result = this.evaluateGenericCall(method, arguments);
                    return ConstantValue.of(result);
                }
                this.pushExpressionValidator(new CallExpressionValidator(this.peekFunctionScope(), node, reference, arguments, methods));
                return ConstantValue.of(method.getType());
            }
            this.pushExpressionValidator(new CallExpressionValidator(this.peekFunctionScope(), node, reference, arguments, methods));
            if (methods != null && methods.size() > 1) {
                IRMember bestMatch = null;
                block2: for (IRMethod method : methods) {
                    if (method.getParameterCount() != arguments.length) continue;
                    int i2 = 0;
                    while (i2 < arguments.length) {
                        TypeCompatibility tc = this.testArgumentType(method.getParameters().get(i2).getType(), arguments[i2]);
                        if (tc != TypeCompatibility.TRUE) continue block2;
                        ++i2;
                    }
                    if (bestMatch != null) {
                        List<IRParameter> parameters = method.getParameters();
                        int i3 = 0;
                        while (i3 < parameters.size()) {
                            IRType type = parameters.get(i3).getType();
                            if (type != null) {
                                IRType bestMatchType = bestMatch.getParameters().get(i3).getType();
                                if (bestMatchType == null) break;
                                if (type.isAssignableFrom(bestMatchType) == TypeCompatibility.TRUE) continue block2;
                            }
                            ++i3;
                        }
                    }
                    bestMatch = method;
                }
                if (bestMatch != null) {
                    return ConstantValue.of(bestMatch.getType());
                }
            }
            if ((expressionType = JavaScriptValidations.typeOf(reference)) != null) {
                IRConstructor constructor;
                IRTypeDeclaration target;
                if (expressionType instanceof IRFunctionType) {
                    return ConstantValue.of(((IRFunctionType)expressionType).getReturnType());
                }
                if (expressionType instanceof IRClassType && (target = ((IRClassType)expressionType).getDeclaration()) != null && (constructor = target.getStaticConstructor()) != null && constructor.getType() != null) {
                    return new ConstantValue(constructor.getType());
                }
            }
            return reference.getChild("()");
        }

        private void pushExpressionValidator(ExpressionValidator expressionValidator) {
            expressionValidator.setSuppressed(this.reporter.getSuppressWarnings());
            this.expressionValidators.add(expressionValidator);
        }

        protected void validateCallExpression(FunctionScope scope, CallExpression node, IValueReference reference, IValueReference[] arguments, List<IRMethod> methods) {
            Expression expression = node.getExpression();
            Path path = ValidationVisitor.path(expression, reference);
            if (scope.contains(path)) {
                return;
            }
            Expression methodNode = expression instanceof PropertyExpression ? ((PropertyExpression)expression).getProperty() : expression;
            if (methods == null || methods.size() == 0) {
                methods = ValueReferenceUtil.extractElements(reference, IRMethod.class);
            }
            if (methods != null) {
                IRMethod method = JavaScriptValidations.selectMethod(methods, arguments, true);
                if (method == null) {
                    IRType type = JavaScriptValidations.typeOf(reference.getParent());
                    if (type != null && TypeUtil.kind(type) == TypeKind.JAVA) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_JAVA_PARAMETERS, NLS.bind((String)ValidationMessages.MethodNotSelected, (Object[])new String[]{reference.getName(), type.getName(), this.describeArguments(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else {
                    this.validateCallExpressionMethod(node, reference, arguments, methodNode, method);
                }
                return;
            }
            Object attrRMethod = reference.getAttribute("R_METHOD", true);
            if (attrRMethod instanceof IRMethod) {
                this.validateCallExpressionRMethod(reference, arguments, methodNode, (IRMethod)attrRMethod);
                return;
            }
            IRType expressionType = JavaScriptValidations.typeOf(reference);
            if (expressionType != null) {
                if (expressionType instanceof IRFunctionType) {
                    this.validateCallExpressionRMethod(reference, arguments, methodNode, new RMethodFunctionWrapper((IRFunctionType)expressionType, reference));
                    return;
                }
                if (expressionType instanceof IRClassType) {
                    IRConstructor constructor;
                    IRTypeDeclaration target = ((IRClassType)expressionType).getDeclaration();
                    if (target != null && (constructor = target.getStaticConstructor()) != null) {
                        this.validateCallExpressionMethod(node, reference, arguments, methodNode, constructor);
                        return;
                    }
                } else if (expressionType != RTypes.any() && expressionType != RTypes.none() && !RTypes.FUNCTION.isAssignableFrom(expressionType).ok()) {
                    if (expressionType instanceof IRUnionType && expressionType.isAssignableFrom(RTypes.FUNCTION).ok()) {
                        return;
                    }
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_FUNCTION, ValidationVisitor.isIdentifier(expression) ? NLS.bind((String)ValidationMessages.WrongFunction, (Object)reference.getName()) : ValidationMessages.WrongFunctionExpression, methodNode.sourceStart(), methodNode.sourceEnd());
                    return;
                }
                return;
            }
            scope.add(path);
            if (!this.isDynamicArrayAccess(reference) && !this.isUntypedParameter(reference)) {
                IRType type = JavaScriptValidations.typeOf(reference.getParent());
                if (type != null) {
                    if (type == RTypes.any()) {
                        return;
                    }
                    if (TypeUtil.kind(type) == TypeKind.JAVA) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethod, (Object)reference.getName(), (Object)type.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    } else if (!reference.exists()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodOnObject, (Object)reference.getName(), (Object)reference.getParent().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                } else {
                    if (expression instanceof NewExpression) {
                        if (reference.getKind() == ReferenceKind.TYPE) {
                            return;
                        }
                        IRType newType = JavaScriptValidations.typeOf(reference);
                        if (newType != null) {
                            return;
                        }
                    }
                    if (expression instanceof NewExpression) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_TYPE_EXPRESSION, NLS.bind((String)ValidationMessages.UndefinedJavascriptType, (Object)((NewExpression)expression).getObjectClass().toSourceString("")), methodNode.sourceStart(), methodNode.sourceEnd());
                    } else if (reference.getParent() == null) {
                        if (ValidationVisitor.isIdentifier(expression) && !reference.exists()) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_FUNCTION, NLS.bind((String)ValidationMessages.UndefinedMethodInScript, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                        } else {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_FUNCTION, ValidationVisitor.isIdentifier(expression) ? NLS.bind((String)ValidationMessages.WrongFunction, (Object)reference.getName()) : ValidationMessages.WrongFunctionExpression, methodNode.sourceStart(), methodNode.sourceEnd());
                        }
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_METHOD, NLS.bind((String)ValidationMessages.UndefinedMethodOnObject, (Object)reference.getName(), (Object)reference.getParent().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
                    }
                }
            }
        }

        private void validateCallExpressionRMethod(IValueReference reference, IValueReference[] arguments, Expression methodNode, IRMethod method) {
            if (method.isDeprecated()) {
                String name = reference.getName();
                if (name == null || "".equals(name)) {
                    name = method.getName();
                }
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)name), methodNode.sourceStart(), methodNode.sourceEnd());
            }
            this.validateAccessibility(methodNode, reference, method);
            List<IRParameter> parameters = method.getParameters();
            TypeCompatibility compatibility = this.validateParameters(parameters, arguments, (ISourceNode)methodNode);
            if (compatibility != TypeCompatibility.TRUE) {
                Identifier identifier;
                String name = method.getName();
                if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                    name = identifier.getName();
                }
                JavaScriptProblems problemId = method.isTyped() ? (compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION) : JavaScriptProblems.WRONG_PARAMETERS_UNTYPED;
                this.reporter.reportProblem((IProblemIdentifier)problemId, NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArguments(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private void validateCallExpressionMethod(CallExpression node, IValueReference reference, IValueReference[] arguments, Expression methodNode, IRMethod method) {
            if (method.getVisibility() != Visibility.PUBLIC && !this.validateAccessibility((ASTNode)methodNode, method)) {
                return;
            }
            if (method.isDeprecated()) {
                this.reportDeprecatedMethod((ASTNode)methodNode, reference, method);
            }
            if (!JavaScriptValidations.checkParameterCount(method, node.getArguments().size())) {
                this.reportMethodParameterError((ASTNode)methodNode, arguments, method);
                return;
            }
            List<IRParameter> parameters = method.getParameters();
            TypeCompatibility compatibility = this.validateParameters(parameters, arguments, (ISourceNode)methodNode);
            if (compatibility != TypeCompatibility.TRUE) {
                Identifier identifier;
                String name = method.getName();
                if (name == null && (identifier = PropertyExpressionUtils.getIdentifier((Expression)methodNode)) != null) {
                    name = identifier.getName();
                }
                this.reporter.reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION), NLS.bind((String)ValidationMessages.MethodNotApplicableInScript, (Object[])new String[]{name, this.describeParamTypes(parameters), this.describeArguments(arguments, parameters)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private boolean isUntypedParameter(IValueReference reference) {
            return reference.getKind() == ReferenceKind.ARGUMENT && reference.getDeclaredType() == null;
        }

        public static boolean isUntyped(IValueReference reference) {
            while (reference != null) {
                IRType type;
                ReferenceKind kind = reference.getKind();
                if (kind == ReferenceKind.ARGUMENT ? (type = reference.getDeclaredType()) == null || type == RTypes.any() : kind == ReferenceKind.THIS && reference.getDeclaredType() == null && reference.getDirectChildren().isEmpty()) {
                    return true;
                }
                reference = reference.getParent();
            }
            return false;
        }

        private boolean isDynamicArrayAccess(IValueReference reference) {
            while (reference != null) {
                if (reference.getName() == "[]") {
                    IRType containerType = JavaScriptValidations.typeOf(reference.getParent());
                    if (containerType instanceof IRArrayType || containerType instanceof IRMapType) break;
                    return true;
                }
                reference = reference.getParent();
            }
            return false;
        }

        private void reportDeprecatedMethod(ASTNode methodNode, IValueReference reference, IRMethod method) {
            if (method.getDeclaringType() != null) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedMethod, (Object)reference.getName(), (Object)method.getDeclaringType().getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_METHOD, NLS.bind((String)ValidationMessages.DeprecatedTopLevelMethod, (Object)reference.getName()), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private void reportDeprecatedRecordMember(ASTNode node, IValueReference reference, IRRecordMember method) {
            IRType type = JavaScriptValidations.typeOf(reference.getParent());
            String msg = NLS.bind((String)ValidationMessages.DeprecatedProperty, (Object)method.getName(), (Object)(type != null ? type.getName() : null));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private void reportMethodParameterError(ASTNode methodNode, IValueReference[] arguments, IRMethod method) {
            if (method.getDeclaringType() != null) {
                JavaScriptProblems problemId = JavaScriptProblems.WRONG_PARAMETERS;
                if (method.getDeclaringType().getKind() == TypeKind.JAVA) {
                    problemId = JavaScriptProblems.WRONG_JAVA_PARAMETERS;
                }
                this.reporter.reportProblem((IProblemIdentifier)problemId, NLS.bind((String)ValidationMessages.MethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), method.getDeclaringType().getName(), this.describeArguments(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            } else {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)ValidationMessages.TopLevelMethodNotApplicable, (Object[])new String[]{method.getName(), this.describeParamTypes(method.getParameters()), this.describeArguments(arguments)}), methodNode.sourceStart(), methodNode.sourceEnd());
            }
        }

        private TypeCompatibility validateParameters(List<IRParameter> parameters, IValueReference[] arguments, ISourceNode problemNode) {
            TypeCompatibility pResult;
            if (arguments.length > parameters.size() && (parameters.size() <= 0 || parameters.get(parameters.size() - 1).getKind() != ParameterKind.VARARGS)) {
                return TypeCompatibility.FALSE;
            }
            int testTypesSize = parameters.size();
            if (parameters.size() > arguments.length) {
                int i = arguments.length;
                while (i < parameters.size()) {
                    IRParameter p = parameters.get(i);
                    if (!p.isOptional() && !p.isVarargs()) {
                        return TypeCompatibility.FALSE;
                    }
                    ++i;
                }
                testTypesSize = arguments.length;
            } else if (parameters.size() < arguments.length) {
                testTypesSize = parameters.size() - 1;
            }
            this.statuses.clear();
            TypeCompatibility result = TypeCompatibility.TRUE;
            int i = 0;
            while (i < testTypesSize) {
                IValueReference argument = arguments[i];
                IRParameter parameter = parameters.get(i);
                if (parameter.getType() instanceof IRTypeExtension) {
                    IValidationStatus status = ((IRTypeExtension)((Object)parameter.getType())).isAssignableFrom(argument);
                    if (status instanceof TypeCompatibility) {
                        pResult = (TypeCompatibility)status;
                        if (pResult.after(result)) {
                            if (pResult == TypeCompatibility.FALSE && this.statuses.isEmpty()) {
                                return pResult;
                            }
                            result = pResult;
                        }
                    } else if (status instanceof ValidationStatus) {
                        this.statuses.add((ValidationStatus)status);
                    } else if (status instanceof ValidationMultiStatus) {
                        Collections.addAll(this.statuses, ((ValidationMultiStatus)status).getChildren());
                    }
                } else {
                    TypeCompatibility pResult2 = this.testArgumentType(parameter.getType(), argument);
                    if (pResult2.after(result)) {
                        if (pResult2 == TypeCompatibility.FALSE && this.statuses.isEmpty()) {
                            return pResult2;
                        }
                        result = pResult2;
                    }
                }
                ++i;
            }
            if (parameters.size() < arguments.length) {
                int varargsParameter = parameters.size() - 1;
                IRType paramType = parameters.get(varargsParameter).getType();
                int i2 = varargsParameter;
                while (i2 < arguments.length) {
                    IValueReference argument = arguments[i2];
                    pResult = this.testArgumentType(paramType, argument);
                    if (pResult.after(result)) {
                        if (pResult == TypeCompatibility.FALSE && this.statuses.isEmpty()) {
                            return pResult;
                        }
                        result = pResult;
                    }
                    ++i2;
                }
            }
            if (!this.statuses.isEmpty()) {
                for (ValidationStatus status : this.statuses) {
                    int end;
                    int start;
                    if (status.hasRange()) {
                        start = status.start();
                        end = status.end();
                    } else {
                        start = problemNode.start();
                        end = problemNode.end();
                    }
                    this.reporter.reportProblem(status.identifier(), status.message(), start, end);
                }
                return TypeCompatibility.TRUE;
            }
            return result;
        }

        private TypeCompatibility testArgumentType(IRType paramType, IValueReference argument) {
            if (argument != null && paramType != null) {
                IRType argumentType;
                if (argument.getAttribute("R_METHOD") != null) {
                    IRMethod method = (IRMethod)argument.getAttribute("R_METHOD");
                    argumentType = RTypes.functionType(this.getContext(), method.getParameters(), method.getType());
                } else {
                    argumentType = JavaScriptValidations.typeOf(argument);
                }
                if (argumentType != null) {
                    return paramType.isAssignableFrom(argumentType);
                }
            }
            return TypeCompatibility.TRUE;
        }

        private String describeParamTypes(List<IRParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            for (IRParameter parameter : parameters) {
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (parameter.getType() instanceof IRRecordType) {
                    sb.append('{');
                    for (IRRecordMember member : ((IRRecordType)parameter.getType()).getMembers()) {
                        boolean optional;
                        if (sb.length() > 1) {
                            sb.append(", ");
                        }
                        if (optional = member.isOptional()) {
                            sb.append('[');
                        }
                        sb.append(member.getName());
                        if (member.getType() != null) {
                            sb.append(':');
                            sb.append(member.getType().getName());
                        }
                        if (!optional) continue;
                        sb.append(']');
                    }
                    sb.append('}');
                    continue;
                }
                if (parameter.getType() != null) {
                    if (parameter.getKind() == ParameterKind.OPTIONAL) {
                        sb.append("[");
                    }
                    if (parameter.getKind() == ParameterKind.VARARGS) {
                        sb.append("...");
                    }
                    sb.append(parameter.getType().getName());
                    if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
                    sb.append("]");
                    continue;
                }
                sb.append('?');
            }
            return sb.toString();
        }

        private String describeArguments(IValueReference[] arguments) {
            return this.describeArguments(arguments, Collections.<IRParameter>emptyList());
        }

        private String describeArguments(IValueReference[] arguments, List<IRParameter> parameters) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < arguments.length) {
                IRParameter parameter;
                IValueReference argument = arguments[i];
                IRParameter iRParameter = parameter = i < parameters.size() ? parameters.get(i) : null;
                if (sb.length() != 0) {
                    sb.append(',');
                }
                if (argument == null) {
                    sb.append("null");
                } else if (parameter != null && parameter.getType() instanceof IRRecordType) {
                    this.describeRecordTypeArgument(sb, argument, (IRRecordType)parameter.getType());
                } else if (argument.getAttribute("R_METHOD") != null) {
                    IRMethod method = (IRMethod)argument.getAttribute("R_METHOD");
                    sb.append(RTypes.functionType(this.getContext(), method.getParameters(), method.getType()).getName());
                } else if (argument.getDeclaredType() != null) {
                    sb.append(argument.getDeclaredType().getName());
                } else {
                    JSTypeSet types = argument.getTypes();
                    if (types.size() > 0) {
                        sb.append(types.toRType().getName());
                    } else {
                        sb.append('?');
                    }
                }
                ++i;
            }
            return sb.toString();
        }

        private void describeRecordTypeArgument(StringBuilder sb, IValueReference argument, @Nullable IRRecordType expectedType) {
            sb.append('{');
            boolean appendComma = false;
            HashSet<String> children = new HashSet<String>(argument.getDirectChildren());
            JSTypeSet types = argument.getTypes();
            for (IRType type : types) {
                if (!(type instanceof IRRecordType)) continue;
                Collection<IRRecordMember> members = ((IRRecordType)type).getMembers();
                for (IRRecordMember member : members) {
                    children.add(member.getName());
                }
            }
            for (String childName : children) {
                IRRecordMember member;
                if (appendComma) {
                    sb.append(", ");
                }
                appendComma = true;
                sb.append(childName);
                IRType expectedMemberType = expectedType != null ? ((member = expectedType.getMember(childName)) != null ? member.getType() : null) : null;
                if (expectedMemberType instanceof IRRecordType) {
                    sb.append(": ");
                    this.describeRecordTypeArgument(sb, argument.getChild(childName), (IRRecordType)expectedMemberType);
                    continue;
                }
                IValueReference child = argument.getChild(childName);
                IRType type = JavaScriptValidations.typeOf(child);
                if (type == null) continue;
                if (expectedType != null && type.getName().equals("Object") && !child.getDirectChildren().isEmpty()) {
                    sb.append(": ");
                    this.describeRecordTypeArgument(sb, child, null);
                    continue;
                }
                sb.append(':');
                sb.append(type.getName());
            }
            sb.append('}');
        }

        @Override
        public IValueReference visitPropertyExpression(PropertyExpression node) {
            IValueReference result = super.visitPropertyExpression(node);
            if (result == null || result.getAttribute("PHANTOM", true) != null || ValidationVisitor.isUntyped(result)) {
                return result;
            }
            if (this.currentMode() != VisitorMode.CALL) {
                this.pushExpressionValidator(new PropertyExpressionHolder(this.peekFunctionScope(), node, result, result.exists()));
            }
            return result;
        }

        @Override
        protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
            if (left != null) {
                this.checkAssign(left, (ASTNode)node);
            }
            return super.visitAssign(left, right, node);
        }

        private static boolean isVarOrFunction(IValueReference reference) {
            ReferenceKind kind = reference.getKind();
            return kind.isVariable() || kind == ReferenceKind.FUNCTION;
        }

        private static boolean isAccess(Identifier node) {
            return ValidationVisitor.isAccess(node, (ASTNode)node.getParent());
        }

        private static boolean isAccess(Identifier node, ASTNode parent) {
            if (parent instanceof BinaryOperation) {
                return !((BinaryOperation)parent).isAssignmentTo((Expression)node);
            }
            if (parent instanceof StatementBlock || parent instanceof Script) {
                return false;
            }
            if (parent instanceof UnaryOperation) {
                UnaryOperation operation = (UnaryOperation)parent;
                int op = operation.getOperation();
                return op != 90 && op != 91 && op != 147 && op != 146 || ValidationVisitor.isAccess(node, (ASTNode)operation.getParent());
            }
            return true;
        }

        @Override
        public IValueReference visitIdentifier(Identifier node) {
            IRProperty property;
            IValueReference result = super.visitIdentifier(node);
            if (ValidationVisitor.isAccess(node) && ValidationVisitor.isVarOrFunction(result) && this.getSource().equals(result.getLocation().getSource()) && result.getAttribute(IReferenceAttributes.ACCESS) == null) {
                result.setAttribute(IReferenceAttributes.ACCESS, Boolean.TRUE);
            }
            if ((property = ValueReferenceUtil.extractElement(result, IRProperty.class)) != null && property.isDeprecated()) {
                this.reportDeprecatedProperty(property, null, (ASTNode)node);
            } else if (!result.exists() && !this.isParentCallOrNew(node)) {
                this.peekFunctionScope().add(ValidationVisitor.path((Expression)node, result));
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDECLARED_VARIABLE, NLS.bind((String)ValidationMessages.UndeclaredVariable, (Object)node.getName()), node.sourceStart(), node.sourceEnd());
            } else {
                this.validateAccessibility((Expression)node, result, null);
                if (result.exists() && node.getParent() instanceof BinaryOperation && ((BinaryOperation)node.getParent()).getOperation() == 21 && ((BinaryOperation)node.getParent()).getRightExpression() == node) {
                    this.checkTypeReference((ASTNode)node, JavaScriptValidations.typeOf(result), this.peekContext());
                }
            }
            return result;
        }

        private boolean isParentCallOrNew(Identifier node) {
            JSNode parent = node.getParent();
            if (parent instanceof CallExpression) {
                return ((CallExpression)parent).getExpression() == node;
            }
            if (parent instanceof NewExpression) {
                return ((NewExpression)parent).getObjectClass() == node;
            }
            return false;
        }

        private static IValueCollection getParentScope(IValueCollection collection) {
            IValueCollection c = collection;
            while (c != null && !c.isScope()) {
                c = c.getParent();
            }
            if (c != null && (c = c.getParent()) != null) {
                return c;
            }
            return null;
        }

        @Override
        protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
            this.validateHidesByVariable(context, declaration);
            IValueReference variable = super.createVariable(context, declaration);
            if (context.getParent() != null || this.canValidateUnusedVariable(context, variable)) {
                this.variables.add(variable);
            }
            return variable;
        }

        private boolean canValidateUnusedVariable(IValueCollection collection, IValueReference reference) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidatorExtension.UnusedVariableValidation result = extension.canValidateUnusedVariable(collection, reference);
                    if (result != null) {
                        return result == IValidatorExtension.UnusedVariableValidation.TRUE;
                    }
                    ++n2;
                }
            }
            return ValidationVisitor.isPrivate(reference);
        }

        private static boolean isPrivate(IValueReference reference) {
            IModelBuilder.IVariable variable = (IModelBuilder.IVariable)reference.getAttribute("VARIABLE");
            return variable != null && variable.getVisibility() == Visibility.PRIVATE;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkAssign(IValueReference reference, ASTNode node) {
            Object value = reference.getAttribute(IAssignProtection.ATTRIBUTE);
            if (value != null) {
                void var4_6;
                if (value instanceof IAssignProtection2) {
                    if (!((IAssignProtection2)value).isReadOnly(reference)) return;
                    IAssignProtection iAssignProtection = (IAssignProtection)value;
                } else {
                    IAssignProtection iAssignProtection = value instanceof IAssignProtection ? (IAssignProtection)value : PROTECT_CONST;
                }
                this.reporter.reportProblem(var4_6.problemId(), var4_6.problemMessage(), node.sourceStart(), node.sourceEnd());
                return;
            } else {
                void var4_10;
                if (reference.getKind() != ReferenceKind.FUNCTION) return;
                Object var4_7 = null;
                if (reference.getParent() != null) {
                    if (reference.getParent().getName().equals("prototype")) {
                        Set set = Collections.emptySet();
                    } else {
                        Set<String> set = reference.getParent().getDirectChildren(2);
                    }
                }
                if (var4_10 != null && !var4_10.contains(reference.getName())) return;
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNASSIGNABLE_ELEMENT, ValidationMessages.UnassignableFunction, node.sourceStart(), node.sourceEnd());
            }
        }

        @Override
        protected void initializeVariable(IValueReference reference, VariableDeclaration declaration) {
            if (declaration.getInitializer() != null && declaration.getParent() instanceof VariableStatement) {
                this.checkAssign(reference, (ASTNode)declaration);
            }
            super.initializeVariable(reference, declaration);
        }

        private void validateHidesByVariable(IValueCollection context, VariableDeclaration declaration) {
            IValueReference child;
            Identifier identifier = declaration.getIdentifier();
            IValueCollection parentScope = ValidationVisitor.getParentScope(context);
            if (parentScope == null) {
                child = context.getChild(identifier.getName());
                if (this.getSource().equals(child.getLocation().getSource())) {
                    return;
                }
            } else {
                child = parentScope.getChild(identifier.getName());
            }
            if (child.exists()) {
                ReferenceKind kind = child.getKind();
                if (kind == ReferenceKind.ARGUMENT) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PARAMETER, NLS.bind((String)ValidationMessages.VariableHidesParameter, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (kind == ReferenceKind.FUNCTION) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_FUNCTION, NLS.bind((String)ValidationMessages.VariableHidesFunction, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else if (kind == ReferenceKind.PROPERTY) {
                    Property property = ValueReferenceUtil.extractElement(child, Property.class);
                    if (property != null && property.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesPropertyOfType, (Object)declaration.getVariableName(), (Object)property.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PROPERTY, NLS.bind((String)ValidationMessages.VariableHidesProperty, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else if (kind == ReferenceKind.METHOD) {
                    IRMethod method = ValueReferenceUtil.extractElement(child, IRMethod.class);
                    if (method != null && method.getDeclaringType() != null) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethodOfType, (Object)declaration.getVariableName(), (Object)method.getDeclaringType().getName()), identifier.sourceStart(), identifier.sourceEnd());
                    } else {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_METHOD, NLS.bind((String)ValidationMessages.VariableHidesMethod, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                    }
                } else if (kind == ReferenceKind.LOCAL || kind == ReferenceKind.GLOBAL) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DUPLICATE_VAR_DECLARATION, NLS.bind((String)ValidationMessages.VariableHidesVariable, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                } else {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.VAR_HIDES_PREDEFINED, NLS.bind((String)ValidationMessages.VariableHidesPredefinedIdentifier, (Object)declaration.getVariableName()), identifier.sourceStart(), identifier.sourceEnd());
                }
            }
        }

        protected void validateProperty(FunctionScope scope, PropertyExpression propertyExpression, IValueReference result, boolean exists) {
            Path path = ValidationVisitor.path((Expression)propertyExpression, result);
            if (scope.contains(path)) {
                return;
            }
            Expression propName = propertyExpression.getProperty();
            IRMember member = ValueReferenceUtil.extractElement(result, IRMember.class);
            if (member != null) {
                if (member.isDeprecated()) {
                    IRProperty parentProperty = ValueReferenceUtil.extractElement(result.getParent(), IRProperty.class);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof IRProperty) {
                            this.reportDeprecatedProperty((IRProperty)member, parentProperty, (ASTNode)propName);
                        } else if (member instanceof IRMethod) {
                            this.reportDeprecatedMethod((ASTNode)propName, result, (IRMethod)member);
                        }
                    } else if (member instanceof IRProperty) {
                        this.reportDeprecatedProperty((IRProperty)member, member.getDeclaringType(), (ASTNode)propName);
                    } else if (member instanceof IRMethod) {
                        this.reportDeprecatedMethod((ASTNode)propName, result, (IRMethod)member);
                    } else if (member instanceof IRRecordMember) {
                        this.reportDeprecatedRecordMember((ASTNode)propName, result, (IRRecordMember)member);
                    }
                } else if (!member.isVisible()) {
                    IRProperty parentProperty = ValueReferenceUtil.extractElement(result.getParent(), IRProperty.class);
                    if (parentProperty != null && parentProperty.getDeclaringType() == null) {
                        if (member instanceof IRProperty) {
                            this.reportHiddenProperty((IRProperty)member, parentProperty, (ASTNode)propName);
                        }
                    } else if (member instanceof IRProperty) {
                        this.reportHiddenProperty((IRProperty)member, member.getDeclaringType(), (ASTNode)propName);
                    }
                } else if (member.getVisibility() != Visibility.PUBLIC) {
                    this.validateAccessibility(propName, result, member);
                }
            } else if (!(exists || result.exists() || this.isDynamicArrayAccess(result))) {
                scope.add(path);
                IRType parentType = JavaScriptValidations.typeOf(result.getParent());
                if (parentType != null && parentType.isExtensible()) {
                    return;
                }
                TypeKind parentKind = TypeUtil.kind(parentType);
                if (parentType != null && parentKind == TypeKind.JAVA) {
                    this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_JAVA_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedProperty, (Object)result.getName(), (Object)parentType.getName()), propName.sourceStart(), propName.sourceEnd());
                } else if (!this.belongsToLogicalExpression((Expression)propertyExpression)) {
                    if (parentType != null && (parentKind == TypeKind.JAVASCRIPT || parentKind == TypeKind.PREDEFINED)) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScriptType, (Object)result.getName(), (Object)parentType.getName()), propName.sourceStart(), propName.sourceEnd());
                    } else {
                        String parentPath = PropertyExpressionUtils.getPath((Expression)propertyExpression.getObject());
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.UNDEFINED_PROPERTY, NLS.bind((String)ValidationMessages.UndefinedPropertyInScript, (Object)result.getName(), (Object)(parentPath != null ? parentPath : "javascript")), propName.sourceStart(), propName.sourceEnd());
                    }
                }
            } else {
                IRVariable variable = (IRVariable)result.getAttribute("R_VARIABLE");
                if (variable != null) {
                    if (variable.isDeprecated()) {
                        this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_VARIABLE, NLS.bind((String)ValidationMessages.DeprecatedVariable, (Object)variable.getName()), propName.sourceStart(), propName.sourceEnd());
                    }
                    this.validateAccessibility(propName, result, variable);
                    return;
                }
                IRMethod method = (IRMethod)result.getAttribute("R_METHOD");
                if (method != null) {
                    if (method.isDeprecated()) {
                        boolean report = true;
                        JSNode parent = propertyExpression.getParent();
                        if (parent instanceof BinaryOperation) {
                            Expression rightExpression = ((BinaryOperation)parent).getRightExpression();
                            boolean bl = report = !(rightExpression instanceof FunctionStatement);
                        }
                        if (report) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_FUNCTION, NLS.bind((String)ValidationMessages.DeprecatedFunction, (Object)method.getName()), propName.sourceStart(), propName.sourceEnd());
                        }
                    }
                    this.validateAccessibility(propName, result, method);
                    return;
                }
            }
        }

        private boolean belongsToLogicalExpression(Expression expression) {
            if (expression.getParent() instanceof BinaryOperation) {
                BinaryOperation bo = (BinaryOperation)expression.getParent();
                return bo.getOperation() == 100 || bo.getOperation() == 101;
            }
            return false;
        }

        private void reportDeprecatedProperty(IRProperty property, IRElement owner, ASTNode node) {
            String msg = owner instanceof IRType ? NLS.bind((String)ValidationMessages.DeprecatedProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof IRProperty ? NLS.bind((String)ValidationMessages.DeprecatedPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.DeprecatedPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private void reportHiddenProperty(IRProperty property, IRElement owner, ASTNode node) {
            String msg = owner instanceof IRType ? NLS.bind((String)ValidationMessages.HiddenProperty, (Object)property.getName(), (Object)owner.getName()) : (owner instanceof IRProperty ? NLS.bind((String)ValidationMessages.HiddenPropertyOfInstance, (Object)property.getName(), (Object)owner.getName()) : NLS.bind((String)ValidationMessages.HiddenPropertyNoType, (Object)property.getName()));
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.HIDDEN_PROPERTY, msg, node.sourceStart(), node.sourceEnd());
        }

        private static boolean isIdentifier(Expression node) {
            return node instanceof Identifier || node instanceof CallExpression && ValidationVisitor.isIdentifier(((CallExpression)node).getExpression());
        }

        private static Identifier getIdentifier(Expression node) {
            if (node instanceof Identifier) {
                return (Identifier)node;
            }
            if (node instanceof CallExpression) {
                return ValidationVisitor.getIdentifier(((CallExpression)node).getExpression());
            }
            return null;
        }

        private IRTypeDeclaration extractClassType(IValueReference typeReference) {
            JSTypeSet types;
            IRType type = typeReference.getDeclaredType();
            if (type == null && (types = typeReference.getTypes()).size() > 0) {
                type = types.toRType();
            }
            if (type != null && type instanceof IRClassType) {
                return ((IRClassType)type).getDeclaration();
            }
            return null;
        }

        protected void validateNewExpression(FunctionScope scope, IValueCollection collection, Expression node, IValueReference reference, IValueReference typeReference, IValueReference[] arguments) {
            Identifier problemNode;
            Identifier identifier = ValidationVisitor.getIdentifier(node);
            Object object = problemNode = identifier != null ? identifier : node;
            if (typeReference.getParent() == null && ValidationVisitor.isIdentifier(node) && !typeReference.exists()) {
                scope.add(ValidationVisitor.path(node, typeReference));
                this.reportUnknownType(JavaScriptProblems.UNDECLARED_VARIABLE, (ASTNode)problemNode, identifier != null ? identifier.getName() : "?");
                return;
            }
            IRTypeDeclaration type = this.extractClassType(typeReference);
            if (type != null) {
                if (type.getKind() != TypeKind.UNKNOWN) {
                    if (!this.validateInstantiability((ASTNode)problemNode, type.getSource(), typeReference)) {
                        return;
                    }
                    this.checkTypeReference((ASTNode)problemNode, type);
                    List<IRConstructor> constructors = TypeUtil.findConstructors(type);
                    if (!constructors.isEmpty()) {
                        List<IRParameter> parameters;
                        TypeCompatibility compatibility;
                        IRConstructor constructor = JavaScriptValidations.selectMethod(constructors, arguments, false);
                        if (constructor == null) {
                            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.WRONG_PARAMETERS, NLS.bind((String)"The constructor {0}({1}) is undefined", (Object[])new String[]{typeReference.getName(), this.describeArguments(arguments)}), problemNode.sourceStart(), problemNode.sourceEnd());
                            return;
                        }
                        if (constructor.isDeprecated()) {
                            this.reportDeprecatedMethod((ASTNode)problemNode, typeReference, constructor);
                        }
                        if ((compatibility = this.validateParameters(parameters = this.context.contextualize(constructor, type).getParameters(), arguments, (ISourceNode)problemNode)) != TypeCompatibility.TRUE) {
                            this.reporter.reportProblem((IProblemIdentifier)(compatibility == TypeCompatibility.FALSE ? JavaScriptProblems.WRONG_PARAMETERS : JavaScriptProblems.WRONG_PARAMETERS_PARAMETERIZATION), NLS.bind((String)"The constructor {0}({1}) is not applicable for the arguments ({2})", (Object[])new String[]{typeReference.getName(), this.describeParamTypes(parameters), this.describeArguments(arguments, parameters)}), problemNode.sourceStart(), problemNode.sourceEnd());
                        }
                    }
                }
            } else if (typeReference.getKind() == ReferenceKind.FUNCTION) {
                Object attrRMethod = typeReference.getAttribute("R_METHOD", true);
                if (attrRMethod instanceof IRMethod) {
                    this.validateCallExpressionRMethod(reference, arguments, (Expression)problemNode, (IRMethod)attrRMethod);
                    return;
                }
            } else {
                String lazyName = ValueReferenceUtil.getLazyName(reference);
                if (lazyName != null) {
                    this.reportProblem(JavaScriptProblems.WRONG_TYPE_EXPRESSION, NLS.bind((String)ValidationMessages.UndefinedJavascriptType, (Object)lazyName), (ISourceNode)node);
                }
            }
        }

        protected void checkTypeReference(ASTNode node, IRType type, IValueCollection collection) {
            IRTypeDeclaration t;
            if (type == null) {
                return;
            }
            if (type instanceof IRClassType && (t = ((IRClassType)type).getDeclaration()) != null && t.getKind() != TypeKind.UNKNOWN) {
                this.checkTypeReference(node, t);
            }
        }

        private void checkTypeReference(ASTNode node, IRTypeDeclaration t) {
            if (t.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)t.getName()), node.sourceStart(), node.sourceEnd());
            }
        }

        private boolean validateInstantiability(ASTNode node, Type type, IValueReference typeReference) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.canInstantiate(type, typeReference);
                    if (result != null) {
                        if (result == ValidationStatus.OK) {
                            return true;
                        }
                        JavaScriptValidations.reportValidationStatus(this.reporter, result, (ISourceNode)node, JavaScriptProblems.NON_INSTANTIABLE_TYPE, ValidationMessages.NonInstantiableType, type.getName());
                        return false;
                    }
                    ++n2;
                }
            }
            if (!type.isInstantiable()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.NON_INSTANTIABLE_TYPE, NLS.bind((String)ValidationMessages.NonInstantiableType, (Object)type.getName()), node.sourceStart(), node.sourceEnd());
                return false;
            }
            return true;
        }

        private boolean validateAccessibility(ASTNode node, IRMember member) {
            if (this.extensions != null && member.getSource() instanceof Member) {
                Member source = (Member)member.getSource();
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.validateAccessibility(source);
                    if (result != null) {
                        if (result == ValidationStatus.OK) {
                            return true;
                        }
                        JavaScriptValidations.reportValidationStatus(this.reporter, result, (ISourceNode)node, JavaScriptProblems.INACCESSIBLE_MEMBER, ValidationMessages.InaccessibleMember, member.getName());
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void validateAccessibility(Expression expression, IValueReference reference, IRMember member) {
            if (this.extensions != null) {
                if (this.memberValidationEvent == null) {
                    this.memberValidationEvent = new MemberValidationEvent();
                }
                this.memberValidationEvent.set(reference, member);
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    IValidationStatus result = extension.validateAccessibility(this.memberValidationEvent);
                    if (result != null) {
                        if (result == ValidationStatus.OK) {
                            return;
                        }
                        IRMember rMember = this.memberValidationEvent.getRMember();
                        JavaScriptValidations.reportValidationStatus(this.reporter, result, (ISourceNode)expression, JavaScriptProblems.INACCESSIBLE_MEMBER, ValidationMessages.InaccessibleMember, rMember == null ? reference.getName() : rMember.getName());
                        return;
                    }
                    ++n2;
                }
            }
        }

        @Deprecated
        public void reportUnknownType(IProblemIdentifier identifier, String message, ASTNode node, String name) {
            this.reportProblem(identifier, NLS.bind((String)message, (Object)name), (ISourceNode)node);
        }

        public void reportUnknownType(IProblemIdentifier identifier, ASTNode node, String name) {
            this.reportProblem(identifier, NLS.bind((String)ValidationMessages.UnknownType, (Object)name), (ISourceNode)node);
        }

        public void reportProblem(IProblemIdentifier identifier, String message, ISourceNode node) {
            this.reporter.reportProblem(identifier, message, node.start(), node.end());
        }

        private static boolean stronglyTyped(IValueReference reference) {
            IRType parentType = JavaScriptValidations.typeOf(reference);
            if (parentType != null) {
                if (parentType instanceof IRRecordType) {
                    return true;
                }
                return TypeUtil.kind(parentType) == TypeKind.JAVA;
            }
            return false;
        }

        @Override
        public IValueReference visitIfStatement(IfStatement node) {
            IValueReference parent;
            IValueReference condition = this.visit((ASTNode)node.getCondition());
            if (condition != null && !condition.exists() && node.getCondition() instanceof PropertyExpression && (parent = condition.getParent()) != null && parent.exists() && !ValidationVisitor.stronglyTyped(parent)) {
                condition.setValue(PhantomValueReference.REFERENCE);
            }
            this.visitIfStatements(node);
            return null;
        }
    }

    private static enum VisitorMode {
        NORMAL,
        CALL;

    }
}

