/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core;

import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

public class Types {
    public static final Type OBJECT = Types.initType("Object");
    public static final Type STRING = Types.initType("String");
    public static final Type NUMBER = Types.initType("Number");
    public static final Type BOOLEAN = Types.initType("Boolean");
    public static final Type FUNCTION = Types.initType("Function");
    public static final Type ARRAY = Types.initType("Array");
    public static final Type XML = Types.initType("XML");
    public static final Type REGEXP = Types.initType("RegExp");
    public static final Type ERROR = Types.initType("Error");

    protected static Type initType(String name) {
        Type type = TypeInfoModelLoader.getInstance().getType(name);
        if (type == null) {
            JavaScriptPlugin.error("Created empty " + name + " type (error loading typeinfo models?)");
            type = TypeInfoModelFactory.eINSTANCE.createType();
            type.setName(name);
            type.setKind(TypeKind.PREDEFINED);
        }
        return type;
    }
}

