/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IScope;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public abstract class StructureNode
implements IStructureNode {
    protected final IParentNode parent;

    public StructureNode(IParentNode parent) {
        this.parent = parent;
    }

    @Override
    public List<? extends IStructureNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean isManyChildren() {
        return false;
    }

    @Override
    public IParentNode getParent() {
        return this.parent;
    }

    @Override
    public IScope getScope() {
        return this.parent.getScope();
    }

    protected String typeToModel(JSType type) {
        return type != null ? type.getName() : null;
    }

    protected void reportChildrenStructure(IStructureRequestor requestor, IStructureContext context) {
        for (IStructureNode iStructureNode : this.getChildren()) {
            iStructureNode.reportStructure(requestor, context);
        }
    }
}

