/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.parser.IASTCache;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTLoader;
import org.eclipse.dltk.tcl.internal.core.serialization.TclASTSaver;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;

public class TclASTCache
implements IASTCache {
    public static final String TCL_AST_ATTRIBUTE = "_ast";
    public static final String TCL_PKG_INFO = "_pinf";
    public static final String TCL_STRUCTURE_INDEX = "_sind";
    public static final String TCL_MIXIN_INDEX = "_smix";
    private final TclCacheSaver cacheSaverJob = new TclCacheSaver();

    public IASTCache.ASTCacheEntry restoreModule(ISourceModule module) {
        IFileHandle handle = EnvironmentPathUtils.getFile((IModelElement)module);
        if (handle == null) {
            return null;
        }
        IContentCache cache = ModelManager.getModelManager().getCoreCache();
        ProblemCollector collector = new ProblemCollector();
        TclModule tclModule = null;
        tclModule = TclASTCache.restoreTclModuleFromCache(handle, cache, (IProblemReporter)collector);
        if (tclModule != null) {
            IASTCache.ASTCacheEntry entry = new IASTCache.ASTCacheEntry();
            NewTclSourceParser parser = new NewTclSourceParser();
            entry.problems = collector;
            entry.module = parser.parse(null, tclModule, null);
            if (entry.problems.isEmpty()) {
                entry.problems = null;
            }
            return entry;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static TclModule restoreTclModuleFromCache(IFileHandle handle, IContentCache cache, IProblemReporter collector) {
        block15: {
            InputStream stream = cache.getCacheEntryAttribute(handle, TCL_AST_ATTRIBUTE);
            if (stream != null) {
                block13: {
                    TclASTLoader loader = new TclASTLoader(stream);
                    TclModule tclModule = loader.getModule(collector);
                    if (tclModule == null) break block13;
                    TclModule tclModule2 = tclModule;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return tclModule2;
                    catch (Exception e) {
                        block14: {
                            try {
                                if (!DLTKCore.DEBUG) break block14;
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                try {
                                    stream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                        }
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        break block15;
                    }
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void storeModule(ISourceModule module, IModuleDeclaration moduleDeclaration, ProblemCollector problems) {
        TclModuleDeclaration decl;
        TclModule tclModule;
        IFileHandle handle = EnvironmentPathUtils.getFile((IModelElement)module, (boolean)false);
        if (handle == null) {
            return;
        }
        if (moduleDeclaration instanceof TclModuleDeclaration && (tclModule = (decl = (TclModuleDeclaration)moduleDeclaration).getTclModule()) != null) {
            StoreEntry entry = new StoreEntry();
            entry.handle = handle;
            entry.module = tclModule;
            if (problems != null) {
                entry.problems = new ProblemCollector();
                problems.copyTo((IProblemReporter)entry.problems);
            }
            this.cacheSaverJob.addToQueue(entry);
        }
    }

    public static void storeTclEntryInCache(ProblemCollector problems, TclModule tclModule, OutputStream stream) {
        block2: {
            try {
                TclASTSaver saver = new TclASTSaver();
                saver.save(tclModule, problems, stream);
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private static class StoreEntry {
        ProblemCollector problems;
        IFileHandle handle;
        TclModule module;

        private StoreEntry() {
        }
    }

    private static class TclCacheSaver
    extends Job {
        final Queue<StoreEntry> queue = new LinkedList<StoreEntry>();

        public TclCacheSaver() {
            super("Tcl Cache Saver");
            this.setSystem(true);
            this.setPriority(20);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                StoreEntry entry;
                Queue<StoreEntry> queue = this.queue;
                synchronized (queue) {
                    entry = this.queue.poll();
                }
                if (entry == null) break;
                IContentCache cache = ModelManager.getModelManager().getCoreCache();
                OutputStream stream = cache.getCacheEntryAttributeOutputStream(entry.handle, TclASTCache.TCL_AST_ATTRIBUTE);
                TclASTCache.storeTclEntryInCache(entry.problems, entry.module, stream);
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            Queue<StoreEntry> queue = this.queue;
            synchronized (queue) {
                return !this.queue.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToQueue(StoreEntry entry) {
            int prevSize;
            Queue<StoreEntry> queue = this.queue;
            synchronized (queue) {
                prevSize = this.queue.size();
                if (prevSize <= 256) {
                    this.queue.add(entry);
                }
            }
            if ((prevSize & 0xF) == 0) {
                this.schedule();
            }
        }
    }
}

