/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.search;

import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.tcl.core.TclMatchLocatorParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.extensions.IMatchLocatorExtension;
import org.eclipse.dltk.tcl.internal.core.TclExtensionManager;

public class TclMatchLocator
extends MatchLocator {
    IMatchLocatorExtension[] extensions = TclExtensionManager.getDefault().getMatchLocatorExtensions();

    public IModelElement createMethodHandle(ISourceModule module, String methodName) {
        IMethod methodHandle = null;
        if (methodName.indexOf("::") != -1) {
            int pos = methodName.lastIndexOf("::");
            String cName = methodName.substring(0, pos);
            String name = methodName.substring(pos + 2);
            if (!cName.startsWith("$")) {
                cName = "$" + cName;
            }
            if (!(cName = cName.replaceAll("::", "\\$")).equals("$")) {
                IType type;
                block8: {
                    type = null;
                    try {
                        type = this.findTypeFrom(module.getChildren(), "", cName, '$');
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
                if (type != null) {
                    methodHandle = type.getMethod(name);
                }
            } else {
                methodHandle = module.getMethod(methodName);
            }
        } else {
            methodHandle = module.getMethod(methodName);
        }
        this.resolveDuplicates((IMember)methodHandle);
        return methodHandle;
    }

    protected IModelElement createHandle(MethodDeclaration method, IModelElement parent) {
        if (parent instanceof IType) {
            IType type = (IType)parent;
            return this.createMethodHandle(type, ((TclMatchLocatorParser)this.parser).getRealMethodName(method));
        }
        if (parent instanceof ISourceModule) {
            int i = 0;
            while (i < this.extensions.length) {
                IModelElement handle = this.extensions[i].createMethodHandle((ISourceModule)parent, method, this);
                if (handle != null) {
                    return handle;
                }
                ++i;
            }
            if (method.getName().indexOf("::") != -1) {
                String methodName = String.valueOf(method.getDeclaringTypeName()) + "::" + ((TclMatchLocatorParser)this.parser).getRealMethodName(method);
                return this.createMethodHandle((ISourceModule)parent, methodName);
            }
            return this.createMethodHandle((ISourceModule)parent, method.getName());
        }
        return null;
    }

    protected IModelElement createTypeHandle(IType parent, String name) {
        if (name.indexOf("::") != -1) {
            String[] split = TclParseUtil.tclSplit(name);
            IType e = parent;
            int i = 0;
            while (i < split.length) {
                if ((e = e.getType(split[i])) == null) {
                    return null;
                }
                ++i;
            }
            if (e != null) {
                return e;
            }
        }
        return parent.getType(name);
    }

    protected IType createTypeHandle(String name) {
        Openable openable = this.currentPossibleMatch.openable;
        if (name.startsWith("::")) {
            name = name.substring(2);
        }
        if (name.endsWith("::")) {
            name = name.substring(0, name.length() - 2);
        }
        if (openable instanceof SourceModule || openable instanceof ExternalSourceModule || openable instanceof BuiltinSourceModule) {
            Object e = (IParent)openable;
            if (name.indexOf("::") != -1) {
                String[] split = TclParseUtil.tclSplit(name);
                int i = 0;
                while (i < split.length) {
                    if ((e = e instanceof ISourceModule ? ((ISourceModule)e).getType(split[i]) : (e instanceof IType ? ((IType)e).getType(split[i]) : null)) == null) {
                        return null;
                    }
                    ++i;
                }
                if (e != null && e instanceof IType) {
                    return (IType)e;
                }
            }
        }
        IType type = null;
        if (openable instanceof ISourceModule) {
            type = ((ISourceModule)openable).getType(name);
        }
        return type;
    }
}

