/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSelectionControl
implements ITreeViewerListener,
ICheckStateListener {
    static final boolean DEBUG = false;
    private final CheckboxTreeViewer fViewer;
    private final ITreeContentProvider treeContentProvider;
    private Map<Object, SelectionState> checkedStateStore = new HashMap<Object, SelectionState>();
    private Set<Object> whiteChecked = new HashSet<Object>();
    private Set<Object> expandedTreeNodes = new HashSet<Object>();
    private Object root;

    public TreeSelectionControl(CheckboxTreeViewer viewer) {
        this.fViewer = viewer;
        this.treeContentProvider = (ITreeContentProvider)viewer.getContentProvider();
    }

    protected String getLabelOf(Object element) {
        return ((ILabelProvider)this.fViewer.getLabelProvider()).getText(element);
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        this.setTreeChecked(treeElement, state);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent != null) {
            if (state) {
                this.grayCheckHierarchy(parent);
            } else {
                this.ungrayCheckHierarchy(parent);
            }
            this.grayUpdateHierarchy(parent);
        }
    }

    void dump(String mode) {
        final ArrayList includes = new ArrayList();
        final ArrayList excludes = new ArrayList();
        ICollector collector = new ICollector(){

            public void include(Object object) {
                includes.add(object);
            }

            public void exclude(Object arg0) {
                excludes.add(arg0);
            }
        };
        this.collectCheckedItems(collector);
        System.out.println("===" + mode + " ===");
        System.out.println("[expandedTreeNodes]");
        for (Object object : this.expandedTreeNodes) {
            System.out.println(" " + this.getLabelOf(object));
        }
        System.out.println("[white]");
        for (Object object : this.whiteChecked) {
            System.out.println(" " + this.getLabelOf(object));
        }
        System.out.println("[state]");
        for (Map.Entry entry : this.checkedStateStore.entrySet()) {
            System.out.println(" " + this.getLabelOf(entry.getKey()) + "=" + entry.getValue());
        }
        System.out.println("[INCLUDES]");
        for (Object object : includes) {
            System.out.println(" " + this.getLabelOf(object));
        }
        System.out.println("[EXCLUDES]");
        for (Object object : excludes) {
            System.out.println(" " + this.getLabelOf(object));
        }
        System.out.println("===");
    }

    public void collectCheckedItems(ICollector collector) {
        Object[] children = this.treeContentProvider.getElements(this.root);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            this.collectAllSelectedItems(child, this.whiteChecked.contains(child), collector, false);
            ++i;
        }
    }

    private void collectAllSelectedItems(Object treeElement, boolean addAll, ICollector collector, boolean wasInclude) {
        boolean nextWasInclude = wasInclude;
        if (addAll) {
            if (!wasInclude) {
                collector.include(treeElement);
                nextWasInclude = true;
            }
        } else {
            SelectionState state = this.checkedStateStore.get(treeElement);
            if (state != null) {
                if (state == SelectionState.CHECKED && !wasInclude) {
                    collector.include(treeElement);
                    nextWasInclude = true;
                }
            } else {
                collector.exclude(treeElement);
                return;
            }
        }
        if (!this.expandedTreeNodes.contains(treeElement)) {
            return;
        }
        Object[] treeChildren = this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < treeChildren.length) {
            Object child = treeChildren[i];
            if (addAll) {
                this.collectAllSelectedItems(child, true, collector, nextWasInclude);
            } else if (this.checkedStateStore.containsKey(child)) {
                this.collectAllSelectedItems(child, this.whiteChecked.contains(child), collector, nextWasInclude);
            } else {
                collector.exclude(child);
            }
            ++i;
        }
    }

    public void install() {
        this.fViewer.addCheckStateListener((ICheckStateListener)this);
        this.fViewer.addTreeListener((ITreeViewerListener)this);
    }

    public void setInput(Object input) {
        this.root = input;
        this.fViewer.setInput(input);
        this.expandedTreeNodes.clear();
        this.expandedTreeNodes.add(input);
    }

    public void aboutToOpen() {
        Object primary;
        this.checkNewTreeElements(this.treeContentProvider.getElements(this.root));
        Object[] elements = this.treeContentProvider.getElements(this.root);
        Object object = primary = elements.length > 0 ? elements[0] : null;
        if (primary != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(primary));
        }
    }

    protected void determineWhiteCheckedDescendents(Object treeElement) {
        Object[] children = this.root == treeElement ? this.treeContentProvider.getElements(treeElement) : this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            this.determineWhiteCheckedDescendents(children[i]);
            ++i;
        }
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
    }

    protected boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement) && this.isChecked(treeElement);
    }

    protected boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] children = this.treeContentProvider.getChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (!this.whiteChecked.contains(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isChecked(Object treeElement) {
        return this.checkedStateStore.get(treeElement) == SelectionState.CHECKED;
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        if (state) {
            this.setListForWhiteSelection(treeElement);
        } else {
            this.checkedStateStore.remove(treeElement);
        }
        this.setWhiteChecked(treeElement, state);
        this.fViewer.setChecked(treeElement, state);
        this.fViewer.setGrayed(treeElement, false);
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                this.setTreeChecked(child, state);
                ++i;
            }
        }
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.whiteChecked.contains(treeElement)) {
                this.whiteChecked.add(treeElement);
            }
        } else {
            this.whiteChecked.remove(treeElement);
        }
    }

    private void setListForWhiteSelection(Object treeElement) {
        this.checkedStateStore.put(treeElement, SelectionState.CHECKED);
    }

    protected void grayCheckHierarchy(Object treeElement) {
        this.expandTreeElement(treeElement);
        if (this.checkedStateStore.containsKey(treeElement)) {
            return;
        }
        this.checkedStateStore.put(treeElement, SelectionState.WHITE);
        Object parent = this.treeContentProvider.getParent(treeElement);
        if (parent != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    private void expandTreeElement(final Object item) {
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (TreeSelectionControl.this.expandedTreeNodes.contains(item)) {
                    TreeSelectionControl.this.checkNewTreeElements(TreeSelectionControl.this.treeContentProvider.getChildren(item));
                } else {
                    TreeSelectionControl.this.expandedTreeNodes.add(item);
                    if (TreeSelectionControl.this.whiteChecked.contains(item)) {
                        Object[] children = TreeSelectionControl.this.treeContentProvider.getChildren(item);
                        int i = 0;
                        while (i < children.length) {
                            if (!TreeSelectionControl.this.whiteChecked.contains(children[i])) {
                                Object child = children[i];
                                TreeSelectionControl.this.setWhiteChecked(child, true);
                                TreeSelectionControl.this.fViewer.setChecked(child, true);
                                TreeSelectionControl.this.checkedStateStore.put(child, SelectionState.WHITE);
                            }
                            ++i;
                        }
                        TreeSelectionControl.this.setListForWhiteSelection(item);
                    }
                }
            }
        });
    }

    protected void checkNewTreeElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object currentElement = elements[i];
            boolean checked = this.checkedStateStore.containsKey(currentElement);
            this.fViewer.setChecked(currentElement, checked);
            this.fViewer.setGrayed(currentElement, checked && !this.whiteChecked.contains(currentElement));
            ++i;
        }
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.checkedStateStore.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        SelectionState checked = this.checkedStateStore.get(treeElement);
        if (checked == SelectionState.CHECKED) {
            return true;
        }
        if (this.expandedTreeNodes.contains(treeElement)) {
            Object[] children = this.treeContentProvider.getChildren(treeElement);
            int i = 0;
            while (i < children.length) {
                if (this.checkedStateStore.containsKey(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void grayUpdateHierarchy(Object treeElement) {
        Object parent;
        boolean shouldBeAtLeastGray = this.determineShouldBeAtLeastGrayChecked(treeElement);
        this.fViewer.setGrayChecked(treeElement, shouldBeAtLeastGray);
        if (this.whiteChecked.contains(treeElement)) {
            this.whiteChecked.remove(treeElement);
        }
        if ((parent = this.treeContentProvider.getParent(treeElement)) != null) {
            this.grayUpdateHierarchy(parent);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.expandTreeElement(event.getElement());
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.treeItemChecked(event.getElement(), event.getChecked());
    }

    public void setInitialState(Collection<?> includes, Collection<?> excludes) {
        this.whiteChecked.clear();
        this.checkedStateStore.clear();
        this.expandedTreeNodes.clear();
        HashSet<Object> processedNodes = new HashSet<Object>();
        for (Object key : includes) {
            this.checkedStateStore.put(key, SelectionState.CHECKED);
            this.collectHierarchy(key, processedNodes, true);
        }
        HashSet<Object> allExcludes = new HashSet<Object>();
        Iterator<?> i = excludes.iterator();
        while (i.hasNext()) {
            this.collectHierarchy(i.next(), allExcludes, false);
        }
        for (Object key : includes) {
            if (!allExcludes.contains(key) && includes.contains(key)) {
                this.whiteChecked.add(key);
            }
            this.expandHierarchy(key, true, includes, excludes, allExcludes);
        }
        i = excludes.iterator();
        while (i.hasNext()) {
            this.expandHierarchy(i.next(), false, includes, excludes, allExcludes);
        }
    }

    private void collectHierarchy(Object item, Set<Object> processedNodes, boolean include) {
        Object parent;
        if (processedNodes.add(item) && (parent = this.treeContentProvider.getParent(item)) != null) {
            if (include) {
                this.checkedStateStore.put(parent, SelectionState.WHITE);
            }
            this.collectHierarchy(parent, processedNodes, include);
        }
    }

    private void expandHierarchy(Object item, boolean include, Collection<?> includes, Collection<?> excludes, Set<Object> allExcludes) {
        Object parent = this.treeContentProvider.getParent(item);
        if (parent != null && this.expandedTreeNodes.add(parent)) {
            Object child;
            Object[] children = this.treeContentProvider.getChildren(parent);
            boolean anyExclude = false;
            int i = 0;
            while (i < children.length) {
                child = children[i];
                if (allExcludes.contains(child)) {
                    anyExclude = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < children.length) {
                child = children[i];
                if (!excludes.contains(child)) {
                    this.checkedStateStore.put(child, SelectionState.CHECKED);
                }
                if (!allExcludes.contains(child) && anyExclude) {
                    this.whiteChecked.add(child);
                }
                ++i;
            }
            this.expandHierarchy(parent, include, includes, excludes, allExcludes);
        }
    }

    public void resetState() {
        this.whiteChecked.clear();
        this.checkedStateStore.clear();
    }

    public static interface ICollector {
        public void include(Object var1);

        public void exclude(Object var1);
    }

    private static class SelectionState {
        public static SelectionState WHITE = new SelectionState();
        public static SelectionState CHECKED = new SelectionState();

        private SelectionState() {
        }

        public String toString() {
            if (this == WHITE) {
                return "WHITE";
            }
            if (this == CHECKED) {
                return "CHECKED";
            }
            return super.toString();
        }
    }
}

