/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.refactoring;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.Checks;
import org.eclipse.dltk.internal.javascript.corext.refactoring.ParameterInfo;
import org.eclipse.dltk.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParameterEditDialog
extends StatusDialog {
    private final ParameterInfo fParameter;
    private final boolean fEditType;
    private final boolean fEditDefault;
    private Text fType;
    private Text fName;
    private Text fDefaultValue;

    public ParameterEditDialog(Shell parentShell, ParameterInfo parameter, boolean canEditType, boolean canEditDefault) {
        super(parentShell);
        this.fParameter = parameter;
        this.fEditType = canEditType;
        this.fEditDefault = canEditDefault;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(RefactoringMessages.ParameterEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 2;
        Label label = new Label(result, 0);
        String newName = this.fParameter.getNewName();
        if (newName.length() == 0) {
            label.setText(RefactoringMessages.ParameterEditDialog_message_new);
        } else {
            label.setText(Messages.format((String)RefactoringMessages.ParameterEditDialog_message, (Object)BasicElementLabels.getJavaElementName((String)newName)));
        }
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        if (this.fEditType) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_type);
            this.fType = new Text(result, 2048);
            gd = new GridData(768);
            this.fType.setLayoutData((Object)gd);
            this.fType.setText(this.fParameter.getNewTypeName());
            this.fType.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install((Text)this.fType);
        }
        label = new Label(result, 0);
        this.fName = new Text(result, 2048);
        this.initializeDialogUnits((Control)this.fName);
        label.setText(RefactoringMessages.ParameterEditDialog_name);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(45);
        this.fName.setLayoutData((Object)gd);
        this.fName.setText(newName);
        this.fName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterEditDialog.this.validate((Text)e.widget);
            }
        });
        TextFieldNavigationHandler.install((Text)this.fName);
        if (this.fEditDefault && this.fParameter.isAdded()) {
            label = new Label(result, 0);
            label.setText(RefactoringMessages.ParameterEditDialog_defaultValue);
            this.fDefaultValue = new Text(result, 2048);
            gd = new GridData(768);
            this.fDefaultValue.setLayoutData((Object)gd);
            this.fDefaultValue.setText(this.fParameter.getDefaultValue());
            this.fDefaultValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ParameterEditDialog.this.validate((Text)e.widget);
                }
            });
            TextFieldNavigationHandler.install((Text)this.fDefaultValue);
        }
        ParameterEditDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fType != null) {
            this.fParameter.setNewTypeName(this.fType.getText());
        }
        this.fParameter.setNewName(this.fName.getText());
        if (this.fDefaultValue != null) {
            this.fParameter.setDefaultValue(this.fDefaultValue.getText());
        }
        super.okPressed();
    }

    private void validate(Text first) {
        IStatus[] result = new IStatus[3];
        if (first == this.fType) {
            result[0] = this.validateType();
            result[1] = this.validateName();
            result[2] = this.validateDefaultValue();
        } else if (first == this.fName) {
            result[0] = this.validateName();
            result[1] = this.validateType();
            result[2] = this.validateDefaultValue();
        } else {
            result[0] = this.validateDefaultValue();
            result[1] = this.validateName();
            result[2] = this.validateType();
        }
        int i = 0;
        while (i < result.length) {
            IStatus status = result[i];
            if (status != null && !status.isOK()) {
                this.updateStatus(status);
                return;
            }
            ++i;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private IStatus validateType() {
        if (this.fType == null) {
            return Status.OK_STATUS;
        }
        String type = this.fType.getText();
        if ("".equals(type)) {
            return Status.OK_STATUS;
        }
        RefactoringStatus status = Checks.validateIdentifier((String)type);
        if (status == null || status.isOK()) {
            return Status.OK_STATUS;
        }
        if (status.hasError()) {
            return this.createErrorStatus(status.getEntryWithHighestSeverity().getMessage());
        }
        return this.createWarningStatus(status.getEntryWithHighestSeverity().getMessage());
    }

    private IStatus validateName() {
        if (this.fName == null) {
            return null;
        }
        String text = this.fName.getText();
        if (text.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_name_error);
        }
        RefactoringStatus status = Checks.validateIdentifier((String)text);
        if (status == null || status.isOK()) {
            return Status.OK_STATUS;
        }
        if (status.hasError()) {
            return this.createErrorStatus(status.getEntryWithHighestSeverity().getMessage());
        }
        return this.createWarningStatus(status.getEntryWithHighestSeverity().getMessage());
    }

    private IStatus validateDefaultValue() {
        if (this.fDefaultValue == null) {
            return null;
        }
        String defaultValue = this.fDefaultValue.getText();
        if (defaultValue.length() == 0) {
            return this.createErrorStatus(RefactoringMessages.ParameterEditDialog_defaultValue_error);
        }
        return Status.OK_STATUS;
    }

    private Status createWarningStatus(String message) {
        return new Status(2, "org.eclipse.dltk.javascript.core", 2, message, null);
    }

    private Status createErrorStatus(String message) {
        return new Status(4, "org.eclipse.dltk.javascript.core", 4, message, null);
    }
}

