/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.ConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.dltk.debug.core.DLTKDebugLaunchConstants;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.Messages;
import org.eclipse.dltk.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.debug.ui.ScriptStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IScriptStreamProxy;
import org.eclipse.dltk.launching.process.IScriptProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class DebugConsoleManager
implements ILaunchesListener2 {
    private static DebugConsoleManager instance;
    private final Map<ILaunch, ScriptDebugConsole> launchToConsoleMap = Collections.synchronizedMap(new HashMap());
    private Map<String, IConfigurationElement> fColorProviders = null;
    private IConsoleColorProvider fDefaultColorProvider;

    public static synchronized DebugConsoleManager getInstance() {
        if (instance == null) {
            instance = new DebugConsoleManager();
        }
        return instance;
    }

    protected boolean acceptLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        if (!Boolean.parseBoolean(launch.getAttribute("use_dltk_console")) && !"debug".equals(launch.getLaunchMode())) {
            return false;
        }
        return launch.getProcesses().length != 0 && DLTKDebugLaunchConstants.isDebugConsole((ILaunch)launch) || launch.getDebugTarget() instanceof IScriptDebugTarget && ((IScriptDebugTarget)launch.getDebugTarget()).isRemote();
    }

    protected ScriptDebugConsole createConsole(ILaunch launch) {
        String encoding = this.selectEncoding(launch);
        IProcess[] processes = launch.getProcesses();
        IProcess process = processes.length != 0 ? processes[0] : null;
        IConsoleColorProvider colorProvider = this.getColorProvider(process != null ? process.getAttribute(IProcess.ATTR_PROCESS_TYPE) : null);
        ScriptDebugConsole console = new ScriptDebugConsole(launch, this.computeName(launch), null, encoding, colorProvider);
        if (process != null) {
            console.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_PROCESS", process);
            if (process instanceof IScriptProcess) {
                console.connect((IScriptProcess)process);
            }
        }
        IConsoleManager manager = this.getConsoleManager();
        manager.addConsoles(new IConsole[]{console});
        manager.showConsoleView((IConsole)console);
        return console;
    }

    private String selectEncoding(ILaunch launch) {
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null) {
            return encoding;
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                return DebugPlugin.getDefault().getLaunchManager().getEncoding(configuration);
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        return ResourcesPlugin.getEncoding();
    }

    protected void destroyConsole(IOConsole console) {
        this.getConsoleManager().removeConsoles(new IConsole[]{console});
    }

    private IConsoleManager getConsoleManager() {
        return ConsolePlugin.getDefault().getConsoleManager();
    }

    protected DebugConsoleManager() {
    }

    protected String computeName(ILaunch launch) {
        String consoleName;
        IProcess[] processes = launch.getProcesses();
        if (processes.length != 0) {
            IProcess process = processes[0];
            ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
            consoleName = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
            if (consoleName == null) {
                consoleName = config == null || DebugUITools.isPrivate((ILaunchConfiguration)config) ? process.getLabel() : this.computeName(config, process);
            }
        } else {
            ILaunchConfiguration config = launch.getLaunchConfiguration();
            consoleName = config != null ? this.computeName(config, null) : "";
        }
        consoleName = String.valueOf(Messages.DebugConsoleManager_debugConsole) + " " + consoleName;
        if (launch.isTerminated()) {
            consoleName = NLS.bind((String)Messages.DebugConsoleManager_terminated, (Object)consoleName);
        }
        return consoleName;
    }

    protected String computeName(ILaunchConfiguration config, IProcess process) {
        String type = null;
        try {
            type = config.getType().getName();
        }
        catch (CoreException coreException) {}
        StringBuffer buffer = new StringBuffer();
        buffer.append(config.getName());
        if (type != null) {
            buffer.append(" [");
            buffer.append(type);
            buffer.append("]");
        }
        if (process != null) {
            buffer.append(" ");
            buffer.append(process.getLabel());
        }
        return buffer.toString();
    }

    public void launchesAdded(ILaunch[] launches) {
        this.launchesChanged(launches);
    }

    public void launchesChanged(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (this.acceptLaunch(launch)) {
                IScriptDebugTarget target;
                IProcess[] processes;
                ScriptDebugConsole console = this.launchToConsoleMap.get(launch);
                if (console == null) {
                    console = this.createConsole(launch);
                    this.launchToConsoleMap.put(launch, console);
                }
                if ((processes = launch.getProcesses()).length != 0) {
                    boolean cfr_ignored_0 = processes[0] instanceof IScriptProcess;
                }
                if (launch.getDebugTarget() instanceof IScriptDebugTarget && (target = (IScriptDebugTarget)launch.getDebugTarget()) != null && target.getStreamProxy() == null) {
                    target.setStreamProxy((IScriptStreamProxy)new ScriptStreamProxy(console));
                }
            }
            ++n2;
        }
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            ScriptDebugConsole console = this.launchToConsoleMap.get(launch);
            if (console != null) {
                this.destroyConsole(console);
                this.launchToConsoleMap.remove(launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            String newName;
            ILaunch launch = iLaunchArray[n2];
            final ScriptDebugConsole console = this.launchToConsoleMap.get(launch);
            if (console != null && !(newName = this.computeName(launch)).equals(console.getName())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        console.setName(newName);
                    }
                };
                DLTKDebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++n2;
        }
    }

    private IConsoleColorProvider getColorProvider(String type) {
        IConfigurationElement extension;
        if (this.fColorProviders == null) {
            this.fColorProviders = new HashMap<String, IConfigurationElement>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "consoleColorProviders");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension2 = elements[i];
                this.fColorProviders.put(extension2.getAttribute("processType"), extension2);
                ++i;
            }
        }
        if ((extension = this.fColorProviders.get(type)) != null) {
            try {
                Object colorProvider = extension.createExecutableExtension("class");
                if (colorProvider instanceof IConsoleColorProvider) {
                    return (IConsoleColorProvider)colorProvider;
                }
                DLTKDebugUIPlugin.logErrorMessage(MessageFormat.format((String)"Extension {0} must specify an instanceof IConsoleColorProvider for class attribute.", (Object[])new String[]{extension.getDeclaringExtension().getUniqueIdentifier()}));
            }
            catch (CoreException e) {
                DLTKDebugUIPlugin.log(e);
            }
        }
        if (this.fDefaultColorProvider == null) {
            this.fDefaultColorProvider = new ConsoleColorProvider();
        }
        return this.fDefaultColorProvider;
    }
}

