/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.debug.core.IHotCodeReplaceListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.HotCodeReplaceErrorDialog;
import org.eclipse.dltk.internal.debug.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ScriptHotCodeReplaceListener
implements IHotCodeReplaceListener {
    public void hotCodeReplaceSucceeded(IScriptDebugTarget target) {
    }

    public void hotCodeReplaceFailed(IScriptDebugTarget target, DebugException exception) {
        String alertMessage;
        String preference;
        Status status;
        if (exception != null && !DLTKDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed") || exception == null && !DLTKDebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported")) {
            return;
        }
        final Display display = DLTKDebugUIPlugin.getStandardDisplay();
        if (display.isDisposed()) {
            return;
        }
        String launchName = target.getLaunch().getLaunchConfiguration().getName();
        if (exception == null) {
            status = new Status(2, DLTKDebugUIPlugin.getUniqueIdentifier(), 2, Messages.ScriptHotCodeReplaceListener_theTargetDoesntSupportHotCodeReplace, null);
            preference = "org.eclipse.dltk.debug.ui.alert_hot_code_replace_not_supported";
            alertMessage = Messages.ScriptHotCodeReplaceListener_doNotShowErrorWhenHotCodeReplaceIsNotSupported;
        } else {
            status = new Status(2, DLTKDebugUIPlugin.getUniqueIdentifier(), 2, exception.getMessage(), exception.getCause());
            preference = "org.eclipse.dltk.debug.ui.alert_hot_code_replace_failed";
            alertMessage = Messages.ScriptHotCodeReplaceListener_doNotShowErrorWhenHotCodeReplaceFails;
        }
        final String title = Messages.ScriptHotCodeReplaceListener_hotCodeReplaceFailed;
        final String message = NLS.bind((String)Messages.ScriptHotCodeReplaceListener_someCodeChangesCannotBeHotSwappedIntoARunningInterpreter, (Object)launchName);
        display.asyncExec(new Runnable((IStatus)status, preference, alertMessage, target){
            private final /* synthetic */ IStatus val$status;
            private final /* synthetic */ String val$preference;
            private final /* synthetic */ String val$alertMessage;
            private final /* synthetic */ IScriptDebugTarget val$target;
            {
                this.val$status = iStatus;
                this.val$preference = string3;
                this.val$alertMessage = string4;
                this.val$target = iScriptDebugTarget;
            }

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = DLTKDebugUIPlugin.getActiveWorkbenchShell();
                HotCodeReplaceErrorDialog dialog = new HotCodeReplaceErrorDialog(shell, title, message, this.val$status, this.val$preference, this.val$alertMessage, DLTKDebugUIPlugin.getDefault().getPreferenceStore(), (IDebugTarget)this.val$target);
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
    }
}

