/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.ui;

import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.eclipse.dltk.validators.internal.externalchecker.ui.ExternalCheckerConfigurationPage;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class RuleCelllModifier
implements ICellModifier {
    private ExternalCheckerConfigurationPage page;

    public RuleCelllModifier(ExternalCheckerConfigurationPage page) {
        this.page = page;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int index = this.page.getColumnNames().indexOf(property);
        Object result = null;
        Rule rule = (Rule)element;
        switch (index) {
            case 0: {
                result = rule.getDescription();
                break;
            }
            case 1: {
                String stringValue = rule.getType();
                String[] choices = this.page.getChoices(property);
                int i = choices.length - 1;
                while (!stringValue.equals(choices[i]) && i > 0) {
                    --i;
                }
                result = new Integer(i);
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int index = this.page.getColumnNames().indexOf(property);
        TableItem item = (TableItem)element;
        Rule task = (Rule)item.getData();
        switch (index) {
            case 0: {
                String valueString = ((String)value).trim();
                task.setDescription(valueString);
                this.page.getRulesList().ruleChanged(task);
                break;
            }
            case 1: {
                String valueString = this.page.getChoices(property)[(Integer)value].trim();
                if (task.getType().equals(valueString)) break;
                task.setType(valueString);
            }
        }
        this.page.getRulesList().ruleChanged(task);
    }
}

