/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.codeassist;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;

public class AssistParser
implements IAssistParser {
    private final IAssistParser parser;

    public AssistParser(IAssistParser parser) {
        this.parser = parser;
    }

    @Override
    public ASTNode getAssistNodeParent() {
        return this.parser.getAssistNodeParent();
    }

    @Override
    public ModuleDeclaration getModule() {
        return this.parser.getModule();
    }

    @Override
    public void handleNotInElement(ASTNode unit, int position) {
        this.parser.handleNotInElement(unit, position);
    }

    @Override
    public ModuleDeclaration parse(IModuleSource sourceModule) {
        return this.parser.parse(sourceModule);
    }

    @Override
    public void parseBlockStatements(ASTNode node, ASTNode unit, int position) {
        this.parser.parseBlockStatements(node, unit, position);
    }

    @Override
    public void setSource(ModuleDeclaration unit) {
        this.parser.setSource(unit);
    }

    public ASTNode parseBlockStatements(ModuleDeclaration unit, int position) {
        TypeDeclaration[] types = unit.getTypes();
        int length = types.length;
        int i = 0;
        while (i < length) {
            TypeDeclaration type = types[i];
            if (type.sourceStart() <= position && type.sourceEnd() >= position) {
                this.parser.setSource(unit);
                return this.parseBlockStatements(type, unit, position);
            }
            ++i;
        }
        MethodDeclaration[] methods = unit.getFunctions();
        length = methods.length;
        int i2 = 0;
        while (i2 < length) {
            MethodDeclaration method = methods[i2];
            if (method.sourceStart() <= position && method.sourceEnd() >= position) {
                this.parser.setSource(unit);
                return this.parseMethod(method, unit, position);
            }
            ++i2;
        }
        ASTNode[] nodes = unit.getNonTypeOrMethodNode();
        length = nodes.length;
        int i3 = 0;
        while (i3 < length) {
            ASTNode node = nodes[i3];
            if (node.sourceStart() <= position && node.sourceEnd() >= position) {
                this.parser.setSource(unit);
                this.parser.parseBlockStatements(node, unit, position);
                return node;
            }
            ++i3;
        }
        this.parser.handleNotInElement(unit, position);
        return null;
    }

    public ASTNode parseBlockStatements(TypeDeclaration type, ModuleDeclaration unit, int position) {
        ASTNode node;
        MethodDeclaration[] methods;
        TypeDeclaration[] memberTypes = type.getTypes();
        if (memberTypes != null) {
            int length = memberTypes.length;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberType = memberTypes[i];
                if (memberType.getNameStart() <= position && memberType.getNameEnd() >= position) {
                    this.parser.handleNotInElement(memberType, position);
                }
                if (memberType.sourceStart() <= position && memberType.sourceEnd() >= position) {
                    return this.parseBlockStatements(memberType, unit, position);
                }
                ++i;
            }
        }
        if ((methods = type.getMethods()) != null) {
            int length = methods.length;
            int i = 0;
            while (i < length) {
                MethodDeclaration method = methods[i];
                node = this.parseMethod(method, unit, position);
                if (node != null) {
                    return node;
                }
                ++i;
            }
        }
        ASTNode[] nodes = type.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            node = nodes[i];
            if (node.sourceStart() <= position && node.sourceEnd() >= position) {
                this.parser.setSource(unit);
                this.parser.parseBlockStatements(node, type, position);
                return node;
            }
            ++i;
        }
        this.parser.handleNotInElement(type, position);
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Engine: Add fields support.");
        }
        return null;
    }

    private ASTNode parseMethod(MethodDeclaration method, ModuleDeclaration unit, int position) {
        if (method != null) {
            if (method.sourceStart() > position) {
                return null;
            }
            if (method.sourceEnd() >= position) {
                this.parser.parseBlockStatements(method, unit, position);
                return method;
            }
        }
        return null;
    }
}

