/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.javascript.ast.JSDeclaration;
import org.eclipse.dltk.javascript.ast.JSScope;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.parser.SymbolKind;

public class SymbolTable {
    private final Map<String, SymbolKind> symbols = new HashMap<String, SymbolKind>();
    private final Set<String> labels = new HashSet<String>();
    private final JSScope scope;

    public SymbolTable(JSScope scope) {
        this.scope = scope;
    }

    public SymbolKind canAdd(String name) {
        return this.symbols.get(name);
    }

    public SymbolKind add(String name, SymbolKind kind) {
        return this.add(name, kind, null);
    }

    public SymbolKind add(String name, SymbolKind kind, JSDeclaration node) {
        SymbolKind prev;
        if (node != null) {
            this.scope.addDeclaration(node);
        }
        if ((prev = this.symbols.get(name)) != null) {
            return prev;
        }
        this.symbols.put(name, kind);
        return null;
    }

    public boolean addLabel(LabelledStatement statement) {
        String label = statement.getLabel().getText();
        if (this.labels.contains(label)) {
            return false;
        }
        this.labels.add(label);
        return true;
    }

    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }
}

