/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class MetaTypeFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    private IConfigurationElement config;
    private String className;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof String)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Data argument must be a String for " + this.getClass(), null));
        }
        this.className = (String)data;
        this.config = config;
    }

    public Object create() throws CoreException {
        if (this.className == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Class name not specified for " + this.getClass(), null));
        }
        int dot = this.className.lastIndexOf(46);
        if (dot == -1) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Illegal class name " + this.className + " for " + this.getClass(), null));
        }
        String bundleName = this.config.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Bundle " + bundleName + " not found for " + this.getClass(), null));
        }
        try {
            Enum[] entries;
            Class clazz = bundle.loadClass(this.className.substring(0, dot));
            String name = this.className.substring(dot + 1);
            if (!clazz.isEnum()) {
                Field field = clazz.getDeclaredField(name);
                if (this.isConstField(field)) {
                    try {
                        return field.get(null);
                    }
                    catch (IllegalAccessException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Error reading " + field, (Throwable)e));
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Field " + field + " must be public static final", null));
            }
            Enum[] enumArray = entries = (Enum[])clazz.getEnumConstants();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                Enum entry = enumArray[n2];
                if (name.equals(entry.name())) {
                    return entry;
                }
                ++n2;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "No enum const " + this.className + " for " + this.getClass(), null));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        try {
            Class clazz = bundle.loadClass(this.className);
            if (!clazz.isEnum()) {
                ArrayList<Field> fields = new ArrayList<Field>();
                Field[] fieldArray = clazz.getDeclaredFields();
                int n = fieldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Field field = fieldArray[n3];
                    if (this.isConstField(field)) {
                        fields.add(field);
                    }
                    ++n3;
                }
                if (fields.size() != 1) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Single public static final field expected in " + clazz.getName() + " for " + this.getClass(), null));
                }
                try {
                    return ((Field)fields.get(0)).get(null);
                }
                catch (IllegalAccessException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Error reading " + fields.get(0), (Throwable)e));
                }
            }
            T[] entries = clazz.getEnumConstants();
            if (entries.length != 1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Single enum const expected in " + clazz.getName() + " for " + this.getClass(), null));
            }
            return entries[0];
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.javascript.core", 0, "Class " + this.className + " not found for " + this.getClass(), (Throwable)e));
        }
    }

    private boolean isConstField(Field field) {
        return (field.getModifiers() & 0x19) == 25;
    }
}

