/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;

class RUnionType
extends RType
implements IRUnionType {
    final Set<IRType> targets = new LinkedHashSet<IRType>();

    public RUnionType(Collection<IRType> targets) {
        assert (!targets.contains(null));
        this.targets.addAll(targets);
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        for (IRType type : this.targets) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(type.getName());
        }
        return sb.toString();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (type instanceof IRUnionType) {
            Set<IRType> targets = ((IRUnionType)type).getTargets();
            if (this.targets.containsAll(targets)) {
                return TypeCompatibility.TRUE;
            }
            HashSet<IRType> compartible = new HashSet<IRType>();
            for (IRType myTarget : this.targets) {
                for (IRType theirTarget : targets) {
                    if (myTarget.isAssignableFrom(theirTarget) != TypeCompatibility.TRUE) continue;
                    compartible.add(theirTarget);
                }
            }
            if (compartible.size() == targets.size()) {
                return TypeCompatibility.TRUE;
            }
            return TypeCompatibility.FALSE;
        }
        for (IRType target : this.targets) {
            if (!target.isAssignableFrom(type).ok()) continue;
            return TypeCompatibility.TRUE;
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public Set<IRType> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public int hashCode() {
        return this.targets.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RUnionType) {
            RUnionType other = (RUnionType)obj;
            return this.targets.equals(other.targets);
        }
        return false;
    }
}

