/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.ui.preferences.FieldValidators;
import org.eclipse.dltk.ui.preferences.ImprovedAbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.Messages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

final class ScriptCorePreferenceBlock
extends ImprovedAbstractConfigurationBlock {
    private static final String[] names = new String[]{Messages.ScriptCorePreferenceBlock_Warning, Messages.ScriptCorePreferenceBlock_Error};
    private static final String[] ids = new String[]{"warning", "error"};
    private Combo circularBuildPathCombo;

    ScriptCorePreferenceBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808);
        Group editorGroup = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_editOptions, 2, 1, 768);
        this.bindControl(SWTFactory.createCheckButton((Composite)editorGroup, PreferencesMessages.EditorPreferencePage_evaluateTemporaryProblems, 2), "handleTemporaryProblems");
        SWTFactory.createLabel((Composite)editorGroup, Messages.ScriptCorePreferenceBlock_CodeAssistTimeout, 1);
        Text connectionTimeout = SWTFactory.createText((Composite)editorGroup, 2048, 1, "");
        this.bindControl(connectionTimeout, "content_assist_timeout", FieldValidators.POSITIVE_NUMBER_VALIDATOR);
        Group uiGroup = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_UI_Options, 1, 1, 768);
        this.bindControl(SWTFactory.createCheckButton((Composite)uiGroup, Messages.EditorPreferencePage_ResourceShowError_InvalidResourceName), "resourceShowError_InvalidResourceName");
        Group builderGroup = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_Builder_Options, 2, 1, 768);
        SWTFactory.createLabel((Composite)builderGroup, Messages.ScriptCorePreferenceBlock_Builder_CircularDependencies, 1);
        this.circularBuildPathCombo = SWTFactory.createCombo((Composite)builderGroup, 2056, 0, names);
        this.createReIndex(composite);
        return composite;
    }

    private void createReIndex(Composite composite) {
        if (DLTKCore.SHOW_REINDEX) {
            Group g = SWTFactory.createGroup(composite, Messages.ScriptCorePreferenceBlock_debugOptionsOperations, 2, 1, 768);
            Label l = new Label((Composite)g, 8);
            l.setText(Messages.ScriptCorePreferencePage_manualReindex);
            Button reCreateIndex = new Button((Composite)g, 8);
            reCreateIndex.setText(Messages.ScriptCorePreferencePage_reindex);
            reCreateIndex.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    block4: {
                        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
                        indexManager.rebuild();
                        try {
                            PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)new ReindexOperation());
                        }
                        catch (InvocationTargetException e3) {
                            if (DLTKCore.DEBUG) {
                                e3.printStackTrace();
                            }
                        }
                        catch (InterruptedException e3) {
                            if (!DLTKCore.DEBUG) break block4;
                            e3.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    @Override
    protected List<OverlayPreferenceStore.OverlayKey> createOverlayKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "handleTemporaryProblems"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "resourceShowError_InvalidResourceName"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_timeout"));
        return overlayKeys;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeBuildPathField(DLTKCore.getPlugin().getPluginPreferences().getString("org.eclipse.dltk.core.circularBuildpath"));
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.initializeBuildPathField(DLTKCore.getPlugin().getPluginPreferences().getDefaultString("org.eclipse.dltk.core.circularBuildpath"));
    }

    private void initializeBuildPathField(String defaultCircularBuildPath) {
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(defaultCircularBuildPath)) {
                this.circularBuildPathCombo.select(i);
                break;
            }
            ++i;
        }
    }

    @Override
    protected void initializeFields() {
        super.initializeFields();
    }

    @Override
    public void performOk() {
        Preferences prefs;
        String value;
        super.performOk();
        int buildPathIndex = this.circularBuildPathCombo.getSelectionIndex();
        if (buildPathIndex >= 0 && buildPathIndex < ids.length && !(value = ids[buildPathIndex]).equals((prefs = DLTKCore.getDefault().getPluginPreferences()).getString("org.eclipse.dltk.core.circularBuildpath"))) {
            prefs.setValue("org.eclipse.dltk.core.circularBuildpath", value);
        }
        DLTKCore.getDefault().savePluginPreferences();
    }

    private final class ReindexOperation
    implements IRunnableWithProgress {
        private ReindexOperation() {
        }

        public void run(IProgressMonitor monitor) {
            block2: {
                try {
                    ResourcesPlugin.getWorkspace().build(6, monitor);
                }
                catch (CoreException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }
    }
}

