/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import java.util.ArrayList;
import java.util.List;

public class CommandLine {
    private final List<String> args = new ArrayList<String>();

    public CommandLine() {
    }

    public CommandLine(String value) {
        String[] parts = value.split("\\s+");
        this.add(parts);
    }

    public void add(String arg) {
        this.args.add(arg);
    }

    public void add(String[] parts) {
        int i = 0;
        while (i < parts.length) {
            this.args.add(parts[i]);
            ++i;
        }
    }

    public void add(CommandLine other) {
        this.args.addAll(other.args);
    }

    public void add(int index, String arg) {
        this.args.add(index, arg);
    }

    public void replaceSequence(char pattern, String value) {
        int i = 0;
        int size = this.args.size();
        while (i < size) {
            String replaced;
            String arg = this.args.get(i);
            if (!arg.equals(replaced = CommandLine.replace(arg, pattern, value))) {
                this.args.set(i, replaced);
            }
            ++i;
        }
    }

    public void clear() {
        this.args.clear();
    }

    private static String replace(String arg, char pattern, String value) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < arg.length()) {
            char c = arg.charAt(i);
            if (c == '%' && i < arg.length() - 1 && arg.charAt(i + 1) == pattern) {
                buffer.append(value);
                ++i;
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String[] toArray() {
        return this.args.toArray(new String[this.args.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.args.size()) {
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(this.args.get(i));
            ++i;
        }
        return sb.toString();
    }

    public boolean contains(String string) {
        return this.args.contains(string);
    }
}

