/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter.internal;

import java.util.Arrays;
import org.eclipse.dltk.formatter.IFormatterIndentGenerator;

public class FormatterIndentGenerator
implements IFormatterIndentGenerator {
    private final char[] chars = new char[256];
    private final int indentationSize;
    private final int tabSize;

    public FormatterIndentGenerator(char ch, int indentationSize, int tabSize) {
        Arrays.fill(this.chars, ch);
        this.indentationSize = indentationSize;
        this.tabSize = tabSize;
    }

    @Override
    public void generateIndent(int indentLevel, StringBuilder target) {
        if (indentLevel > 0) {
            int size = indentLevel * this.indentationSize;
            while (size > 0) {
                int step = Math.min(size, this.chars.length);
                target.append(this.chars, 0, step);
                size -= step;
            }
        }
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }
}

