/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.env;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;

public class MethodSourceCode
implements ISourceModule {
    private final IMethod method;

    public MethodSourceCode(IMethod method) {
        this.method = method;
    }

    @Override
    public char[] getContentsAsCharArray() {
        try {
            return this.method.getSource().toCharArray();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IModelElement getModelElement() {
        return this.method;
    }

    @Override
    public String getSourceContents() {
        try {
            return this.method.getSource();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return "";
        }
    }

    @Override
    public String getFileName() {
        return this.method.getSourceModule().getPath().toString();
    }
}

