/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.formatter.AbstractScriptFormatterFactory;
import org.eclipse.dltk.javascript.formatter.JavaScriptFormatter;
import org.eclipse.dltk.javascript.formatter.JavaScriptFormatterConstants;
import org.eclipse.dltk.javascript.formatter.preferences.JavaScriptFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.preferences.PreferenceKey;

public class JavaScriptFormatterFactory
extends AbstractScriptFormatterFactory {
    public IScriptFormatter createFormatter(String lineDelimiter, Map<String, String> preferences) {
        return new JavaScriptFormatter(lineDelimiter, preferences);
    }

    public Map<String, String> changeToIndentingOnly(Map<String, String> preferences) {
        HashMap<String, String> copy = new HashMap<String, String>(preferences);
        copy.put("formatter.statement.new.line", String.valueOf(false));
        copy.put("wrap.comments", String.valueOf(false));
        copy.put("lines.preserve", String.valueOf(-1));
        copy.put("formatter.keep.lines", String.valueOf(true));
        return copy;
    }

    public PreferenceKey getProfilesKey() {
        return new PreferenceKey("org.eclipse.dltk.javascript.formatter", "formatter.profiles");
    }

    public PreferenceKey getActiveProfileKey() {
        return new PreferenceKey("org.eclipse.dltk.javascript.formatter", "formatter.profiles.active");
    }

    public PreferenceKey[] getPreferenceKeys() {
        String[] options = JavaScriptFormatterConstants.getNames();
        PreferenceKey[] result = new PreferenceKey[options.length];
        int i = 0;
        while (i < options.length) {
            String key = options[i];
            String qualifier = "formatter.tabulation.char".equals(key) || "formatter.indentation.size".equals(key) || "formatter.tabulation.size".equals(key) ? "org.eclipse.dltk.javascript.ui" : "org.eclipse.dltk.javascript.formatter";
            result[i] = new PreferenceKey(qualifier, key);
            ++i;
        }
        return result;
    }

    public URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("FormatterPreview.js");
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner) {
        return new JavaScriptFormatterModifyDialog(dialogOwner, (IScriptFormatterFactory)this);
    }
}

