/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast.expressions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.ExpressionList;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonListForExpression
extends ExpressionList {
    private Expression fMaker;

    public PythonListForExpression(Expression maker) {
        this.fMaker = maker;
        this.setStart(maker.sourceStart());
        this.setEnd(maker.sourceEnd());
    }

    public void addExpression(Expression ex) {
        super.addExpression(ex);
        this.setEnd(ex.sourceEnd());
    }

    public int getKind() {
        return 38007;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            List expressions;
            if (this.fMaker != null) {
                this.fMaker.traverse(pVisitor);
            }
            if ((expressions = this.getExpressions()) != null) {
                Iterator i = expressions.iterator();
                while (i.hasNext()) {
                    Expression expr = (Expression)i.next();
                    expr.traverse(pVisitor);
                }
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        if (this.fMaker != null) {
            this.fMaker.printNode(output);
        }
        output.formatPrintLn(" ");
        List exprs = this.getExpressions();
        Iterator i = exprs.iterator();
        while (i.hasNext()) {
            Expression e = (Expression)i.next();
            e.printNode(output);
            output.formatPrintLn(" ");
        }
    }
}

