/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.folding;

import java.util.List;
import org.eclipse.dltk.tcl.internal.ui.text.folding.TclFoldingMessages;
import org.eclipse.dltk.ui.preferences.ControlBindingManager;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.text.folding.SourceCodeFoldingPreferenceBlock;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclFoldingPreferenceBlock
extends SourceCodeFoldingPreferenceBlock {
    private Button fFoldOtherEnabled;
    private Button fInitFoldOtherBlocks;
    private ListBlock fExcludePatterns;
    private ListBlock fIncludePatterns;

    public TclFoldingPreferenceBlock(OverlayPreferenceStore store, PreferencePage page) {
        super(store, page);
    }

    public Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        this.createDependency(this.fFoldOtherEnabled, new Control[]{this.fInitFoldOtherBlocks}, ControlBindingManager.DEPENDENCY_INVERSE_SELECTION);
        return control;
    }

    protected void addInitiallyFoldOptions(Group group) {
        super.addInitiallyFoldOptions(group);
        this.fInitFoldOtherBlocks = this.createCheckBox((Composite)group, TclFoldingMessages.DefaultFoldingPreferenceBlock_other, "editor_folding_init_other_blocks");
    }

    protected void addOverlayKeys(List<OverlayPreferenceStore.OverlayKey> keys) {
        super.addOverlayKeys(keys);
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_blocks"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_include_list"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_exclude_list"));
        keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_init_other_blocks"));
    }

    protected void createOptionsControl(Composite composite) {
        Group group = SWTFactory.createGroup((Composite)composite, (String)TclFoldingMessages.TclFoldingPreferenceBlock_10, (int)1, (int)1, (int)768);
        this.fFoldOtherEnabled = this.createRadioButton((Composite)group, TclFoldingMessages.TclFoldingPreferenceBlock_11, "editor_folding_blocks", new Integer(0));
        this.createRadioButton((Composite)group, TclFoldingMessages.TclFoldingPreferenceBlock_12, "editor_folding_blocks", new Integer(2));
        this.fExcludePatterns = new ListBlock((Composite)group, "editor_folding_exclude_list");
        this.createRadioButton((Composite)group, TclFoldingMessages.TclFoldingPreferenceBlock_13, "editor_folding_blocks", new Integer(1));
        this.fIncludePatterns = new ListBlock((Composite)group, "editor_folding_include_list");
    }

    protected String getInitiallyFoldClassesKey() {
        return "editor_folding_init_namespaces";
    }

    protected String getInitiallyFoldMethodsKey() {
        return "editor_folding_init_blocks";
    }

    protected String getInitiallyFoldClassesText() {
        return TclFoldingMessages.DefaultFoldingPreferenceBlock_innerTypes;
    }

    protected String getInitiallyFoldMethodsText() {
        return TclFoldingMessages.DefaultFoldingPreferenceBlock_methods;
    }

    public void initialize() {
        super.initialize();
        this.fExcludePatterns.initialize();
        this.fIncludePatterns.initialize();
    }

    public void performDefaults() {
        super.performDefaults();
        this.fExcludePatterns.performDefault();
        this.fIncludePatterns.performDefault();
    }

    protected class ListBlock {
        private ListViewer fList;
        private String fKey;
        private Button fAddButton;
        private Button fRemoveButton;

        public ListBlock(Composite parent, String key) {
            this.fKey = key;
            this.createControl(parent);
        }

        private Control createControl(Composite parent) {
            Font font = parent.getFont();
            Composite comp = new Composite(parent, 0);
            GridLayout topLayout = new GridLayout();
            topLayout.numColumns = 2;
            topLayout.marginHeight = 0;
            topLayout.marginWidth = 0;
            comp.setLayout((Layout)topLayout);
            GridData gd = new GridData(1808);
            comp.setLayoutData((Object)gd);
            this.fList = new ListViewer(comp);
            gd = new GridData(1808);
            gd.heightHint = 6;
            this.fList.getControl().setLayoutData((Object)gd);
            Composite pathButtonComp = new Composite(comp, 0);
            GridLayout pathButtonLayout = new GridLayout();
            pathButtonLayout.marginHeight = 0;
            pathButtonLayout.marginWidth = 0;
            pathButtonComp.setLayout((Layout)pathButtonLayout);
            gd = new GridData(258);
            pathButtonComp.setLayoutData((Object)gd);
            pathButtonComp.setFont(font);
            this.fAddButton = this.createPushButton(pathButtonComp, TclFoldingMessages.TclFoldingPreferenceBlock_0);
            this.fAddButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    IInputValidator validator = new IInputValidator(){

                        public String isValid(String newText) {
                            if (newText.trim().length() > 0 && newText.matches("[_a-zA-Z]*")) {
                                return null;
                            }
                            return TclFoldingMessages.TclFoldingPreferenceBlock_2;
                        }
                    };
                    InputDialog dlg = new InputDialog(null, TclFoldingMessages.TclFoldingPreferenceBlock_3, TclFoldingMessages.TclFoldingPreferenceBlock_4, "", validator);
                    if (dlg.open() == 0) {
                        ListBlock.this.fList.add((Object)dlg.getValue());
                        ListBlock.this.save();
                    }
                }
            });
            this.fRemoveButton = this.createPushButton(pathButtonComp, TclFoldingMessages.TclFoldingPreferenceBlock_6);
            this.fRemoveButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection s = ListBlock.this.fList.getSelection();
                    if (s instanceof IStructuredSelection) {
                        IStructuredSelection sel = (IStructuredSelection)s;
                        ListBlock.this.fList.remove(sel.toArray());
                        ListBlock.this.save();
                    }
                }
            });
            return comp;
        }

        protected Button createPushButton(Composite parent, String label) {
            Button button = new Button(parent, 8);
            button.setFont(parent.getFont());
            if (label != null) {
                button.setText(label);
            }
            GridData gd = new GridData();
            button.setLayoutData((Object)gd);
            gd.widthHint = this.getButtonWidthHint(button);
            gd.horizontalAlignment = 4;
            return button;
        }

        public int getButtonWidthHint(Button button) {
            button.setFont(JFaceResources.getDialogFont());
            PixelConverter converter = new PixelConverter((Control)button);
            int widthHint = converter.convertHorizontalDLUsToPixels(61);
            return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        }

        private String[] getEntries() {
            return this.fList.getList().getItems();
        }

        private void setEntries(String[] items) {
            this.fList.remove((Object[])this.fList.getList().getItems());
            int i = 0;
            while (i < items.length) {
                if (items[i].trim().length() > 0) {
                    this.fList.add((Object)items[i]);
                }
                ++i;
            }
        }

        public void save() {
            String[] items = this.getEntries();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                buf.append(items[i]);
                if (i != items.length - 1) {
                    buf.append(",");
                }
                ++i;
            }
            TclFoldingPreferenceBlock.this.getPreferenceStore().setValue(this.fKey, buf.toString());
        }

        public void initialize() {
            String val = TclFoldingPreferenceBlock.this.getPreferenceStore().getString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }

        public void performDefault() {
            String val = TclFoldingPreferenceBlock.this.getPreferenceStore().getDefaultString(this.fKey);
            if (val != null) {
                String[] items = val.split(",");
                this.setEntries(items);
            }
        }
    }
}

