/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.environment;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IEnvironmentProvider;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;

public class LocalEnvironmentProvider
implements IEnvironmentProvider {
    public static final String FILE_SCHEME = "file";

    @Override
    public String getProviderName() {
        return LocalEnvironment.getInstance().getName();
    }

    @Override
    public IEnvironment getEnvironment(String envId) {
        if ("org.eclipse.dltk.core.environment.localEnvironment".equals(envId)) {
            return LocalEnvironment.getInstance();
        }
        return null;
    }

    @Override
    public IEnvironment[] getEnvironments() {
        return new IEnvironment[]{LocalEnvironment.getInstance()};
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void waitInitialized() {
    }

    @Override
    public IEnvironment getProjectEnvironment(IProject project) {
        File file;
        IPath location;
        if (project.isAccessible() && (location = project.getLocation()) != null && (file = new File(location.makeAbsolute().toOSString())).exists()) {
            return LocalEnvironment.getInstance();
        }
        return null;
    }

    @Override
    public IEnvironment getEnvironment(URI locationURI) {
        if (FILE_SCHEME.equals(locationURI.getScheme())) {
            return LocalEnvironment.getInstance();
        }
        return null;
    }
}

