/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.ILocalVariable;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.ui.UIModelProviderManager;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ScriptElementLabels {
    public static final long M_PARAMETER_TYPES = 1L;
    public static final long M_PARAMETER_NAMES = 2L;
    public static final long M_PARAMETER_INITIALIZERS = 0x2000000000000L;
    public static final long M_PRE_TYPE_PARAMETERS = 4L;
    public static final long M_APP_TYPE_PARAMETERS = 8L;
    public static final long M_EXCEPTIONS = 16L;
    public static final long M_APP_RETURNTYPE = 32L;
    public static final long M_PRE_RETURNTYPE = 64L;
    public static final long M_FULLY_QUALIFIED = 128L;
    public static final long M_POST_QUALIFIED = 256L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long I_POST_QUALIFIED = 2048L;
    public static final long F_APP_TYPE_SIGNATURE = 16384L;
    public static final long F_PRE_TYPE_SIGNATURE = 32768L;
    public static final long F_FULLY_QUALIFIED = 65536L;
    public static final long F_POST_QUALIFIED = 131072L;
    public static final long T_FULLY_QUALIFIED = 262144L;
    public static final long T_CONTAINER_QUALIFIED = 524288L;
    public static final long T_POST_QUALIFIED = 0x100000L;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CU_QUALIFIED = 0x80000000L;
    public static final long CU_POST_QUALIFIED = 0x100000000L;
    public static final long P_QUALIFIED = 0x800000000L;
    public static final long P_POST_QUALIFIED = 0x1000000000L;
    public static final long P_COMPRESSED = 0x2000000000L;
    public static final long ROOT_VARIABLE = 0x10000000000L;
    public static final long ROOT_QUALIFIED = 0x20000000000L;
    public static final long ROOT_POST_QUALIFIED = 0x40000000000L;
    public static final long APPEND_ROOT_PATH = 0x80000000000L;
    public static final long PREPEND_ROOT_PATH = 0x100000000000L;
    public static final long REFERENCED_ROOT_POST_QUALIFIED = 0x200000000000L;
    public static final long REFERENCED_ARCHIVE_POST_QUALIFIED = 0x400000000000L;
    public static final long USE_RESOLVED = 0x1000000000000L;
    public static final long APPEND_FILE = Long.MIN_VALUE;
    public static final long ALL_FULLY_QUALIFIED = 2235681801408L;
    public static final long ALL_POST_QUALIFIED = 4471364126976L;
    public static final long ALL_DEFAULT = 0x2000000200022L;
    public static final long F_CATEGORY = 0x2000000000000L;
    public static final long M_CATEGORY = 0x4000000000000L;
    public static final long T_CATEGORY = 0x8000000000000L;
    public static final long ALL_CATEGORY = 0xE000000000000L;
    public static final long DEFAULT_QUALIFIED = 2298807424L;
    public static final long DEFAULT_POST_QUALIFIED = 4598139136L;
    public static final String CONCAT_STRING = " - ";
    public static final String COMMA_STRING = ", ";
    public static final String DECL_STRING = " : ";
    public static final String ELLIPSIS_STRING = "...";
    public static final String DEFAULT_PACKAGE = "(default package)";
    public static final String BUILTINS_FRAGMENT = "(builtins)";
    protected static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static ScriptElementLabels sInstanceO = new ScriptElementLabels(){};
    private static ScriptElementLabels sInstance = new ScriptElementLabels(){

        private ScriptElementLabels getLabels(IModelElement element) {
            ScriptElementLabels scriptElementLabels;
            IDLTKUILanguageToolkit languageToolkit = DLTKUILanguageManager.getLanguageToolkit(element);
            if (languageToolkit != null && (scriptElementLabels = languageToolkit.getScriptElementLabels()) != null) {
                return scriptElementLabels;
            }
            return sInstanceO;
        }

        @Override
        public String getContainerEntryLabel(IPath containerPath, IScriptProject project) throws ModelException {
            return this.getLabels((IModelElement)project).getContainerEntryLabel(containerPath, project);
        }

        @Override
        public void getDeclarationLabel(IModelElement declaration, long flags, StringBuffer buf) {
            this.getLabels(declaration).getDeclarationLabel(declaration, flags, buf);
        }

        @Override
        public void getElementLabel(IModelElement element, long flags, StringBuffer buf) {
            this.getLabels(element).getElementLabel(element, flags, buf);
        }

        @Override
        public String getElementLabel(IModelElement element, long flags) {
            return this.getLabels(element).getElementLabel(element, flags);
        }

        @Override
        public void getProjectFragmentLabel(IProjectFragment root, long flags, StringBuffer buf) {
            this.getLabels((IModelElement)root).getProjectFragmentLabel(root, flags, buf);
        }

        @Override
        public void getScriptFolderLabel(IProjectFragment pack, long flags, StringBuffer buf) {
            this.getLabels((IModelElement)pack).getScriptFolderLabel(pack, flags, buf);
        }

        @Override
        protected void getTypeLabel(IType type, long flags, StringBuffer buf) {
            this.getLabels((IModelElement)type).getTypeLabel(type, flags, buf);
        }
    };
    protected static String fgPkgNamePrefix;
    protected static String fgPkgNamePostfix;
    protected static int fgPkgNameChars;
    protected static int fgPkgNameLength;

    static {
        fgPkgNameLength = -1;
    }

    public static ScriptElementLabels getDefault() {
        return sInstance;
    }

    protected ScriptElementLabels() {
    }

    protected String getTypeDelimiter(IModelElement modelElement) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)modelElement);
        ISearchPatternProcessor processor = DLTKLanguageManager.getSearchPatternProcessor((IDLTKLanguageToolkit)toolkit);
        if (processor != null) {
            return processor.getDelimiterReplacementString();
        }
        return ".";
    }

    protected static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public String getTextLabel(Object obj, long flags) {
        IWorkbenchAdapter wbadapter;
        if (obj instanceof IModelElement) {
            ScriptElementLabels labels;
            IDLTKUILanguageToolkit uiToolkit;
            IModelElement element = (IModelElement)obj;
            if (this.equals(sInstance) && (uiToolkit = DLTKUILanguageManager.getLanguageToolkit(element)) != null && (labels = uiToolkit.getScriptElementLabels()) != null) {
                return labels.getElementLabel(element, flags);
            }
            return this.getElementLabel((IModelElement)obj, flags);
        }
        if (obj instanceof IAdaptable && (wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class)) != null) {
            return wbadapter.getLabel(obj);
        }
        return "";
    }

    private ILabelProvider[] getProviders(Object element) {
        IDLTKLanguageToolkit toolkit;
        String idtoolkit = null;
        if (element instanceof IModelElement && (toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)element))) != null) {
            idtoolkit = toolkit.getNatureId();
        }
        ILabelProvider[] providers = UIModelProviderManager.getLabelProviders(idtoolkit);
        return providers;
    }

    public String getElementLabel(IModelElement element, long flags) {
        ILabelProvider[] providers = this.getProviders(element);
        if (providers != null) {
            int i = 0;
            while (i < providers.length) {
                String text = providers[i].getText((Object)element);
                if (text != null) {
                    return text;
                }
                ++i;
            }
        }
        StringBuffer buf = new StringBuffer(61);
        this.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public void getElementLabel(IModelElement element, long flags, StringBuffer buf) {
        int type = element.getElementType();
        IProjectFragment root = null;
        IScriptProject project = element.getScriptProject();
        if (type != 1 && type != 2 && type != 3) {
            IResource resource = element.getResource();
            if (resource != null) {
                root = project.getProjectFragment(resource);
            }
            if (root == null) {
                root = this.findProjectFragment(element);
            }
        }
        if (root != null && ScriptElementLabels.getFlag(flags, 0x100000000000L)) {
            this.getProjectFragmentLabel(root, 0x20000000000L, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 9: {
                this.getMethodLabel((IMethod)element, flags, buf);
                break;
            }
            case 8: {
                this.getFieldLabel((IField)element, flags, buf);
                break;
            }
            case 7: {
                this.getTypeLabel((IType)element, flags, buf);
                break;
            }
            case 5: {
                this.getSourceModule((ISourceModule)element, flags, buf);
                break;
            }
            case 1: 
            case 2: {
                buf.append(element.getElementName());
                break;
            }
            case 11: {
                this.getImportContainerLabel(element, flags, buf);
                break;
            }
            case 12: {
                this.getImportDeclarationLabel(element, flags, buf);
                break;
            }
            case 10: {
                this.getDeclarationLabel(element, flags, buf);
                break;
            }
            case 4: {
                this.getScriptFolderLabel((IScriptFolder)element, flags, buf);
                break;
            }
            case 3: {
                this.getProjectFragmentLabel((IProjectFragment)element, flags, buf);
                break;
            }
            case 13: {
                this.getLocalVariableLabel((ILocalVariable)element, flags, buf);
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
        ISourceModule sourceModule = (ISourceModule)element.getAncestor(5);
        if (sourceModule != null && ScriptElementLabels.getFlag(flags, Long.MIN_VALUE)) {
            buf.append(CONCAT_STRING);
            this.getSourceModule(sourceModule, flags, buf);
        }
        if (root != null && ScriptElementLabels.getFlag(flags, 0x80000000000L)) {
            buf.append(CONCAT_STRING);
            this.getProjectFragmentLabel(root, 0x20000000000L, buf);
        }
    }

    protected IProjectFragment findProjectFragment(IModelElement element) {
        while (element != null && element.getElementType() != 3) {
            element = element.getParent();
        }
        return (IProjectFragment)element;
    }

    protected void getScriptFolderLabel(IScriptFolder folder, StringBuffer buf) {
        buf.append(folder.getElementName());
    }

    protected void getScriptFolderLabel(IScriptFolder folder, long flags, StringBuffer buf) {
        if (ScriptElementLabels.getFlag(flags, 0x800000000L)) {
            this.getProjectFragmentLabel((IProjectFragment)folder.getParent(), 0x20000000000L, buf);
            buf.append('/');
        }
        if (folder.isRootFolder()) {
            buf.append(DEFAULT_PACKAGE);
        } else if (ScriptElementLabels.getFlag(flags, 0x2000000000L) && fgPkgNameLength >= 0) {
            String name = folder.getElementName();
            int start = 0;
            int dot = name.indexOf(47, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(47, start);
            }
            buf.append(name.substring(start));
        } else {
            this.getScriptFolderLabel(folder, buf);
        }
        if (ScriptElementLabels.getFlag(flags, 0x1000000000L)) {
            buf.append(CONCAT_STRING);
            this.getProjectFragmentLabel((IProjectFragment)folder.getParent(), 0x20000000000L, buf);
        }
    }

    protected void getSourceModule(ISourceModule module, long flags, StringBuffer buf) {
        if (ScriptElementLabels.getFlag(flags, 0x80000000L)) {
            IScriptFolder pack = (IScriptFolder)module.getParent();
            this.getScriptFolderLabel(pack, flags & 0x1002000000000L, buf);
            buf.append(this.getTypeDelimiter((IModelElement)module));
        }
        buf.append(module.getElementName());
        if (ScriptElementLabels.getFlag(flags, 0x100000000L) && !((IScriptFolder)module.getParent()).isRootFolder()) {
            buf.append(CONCAT_STRING);
            this.getScriptFolderLabel((IScriptFolder)module.getParent(), flags & 0x1002000000000L, buf);
        }
    }

    protected void appendTypeQualification(IType type, long flags, StringBuffer buf) {
        try {
            INamespace namespace = type.getNamespace();
            if (namespace != null) {
                buf.append(namespace.getQualifiedName("."));
                buf.append(".");
                return;
            }
        }
        catch (ModelException modelException) {
            return;
        }
        IResource resource = type.getResource();
        IProjectFragment pack = null;
        if (resource != null) {
            IScriptProject project = type.getScriptProject();
            pack = project.getProjectFragment(resource);
        } else {
            pack = this.findProjectFragment((IModelElement)type);
        }
        if (pack == null) {
            pack = this.findProjectFragment((IModelElement)type);
        }
        this.getScriptFolderLabel(pack, flags & 0x1002000000000L, buf);
    }

    protected void getTypeLabel(IType type, long flags, StringBuffer buf) {
        String typeName;
        if (ScriptElementLabels.getFlag(flags, 262144L)) {
            this.appendTypeQualification(type, flags, buf);
        }
        if (ScriptElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                this.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter(elem));
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8) {
                this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter(elem));
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                if (type.getParent() instanceof IField) {
                    typeName = "{...}";
                } else {
                    String[] superNames = type.getSuperClasses();
                    if (superNames != null) {
                        int count = 0;
                        typeName = String.valueOf(typeName) + DECL_STRING;
                        int i = 0;
                        while (i < superNames.length) {
                            if (count > 0) {
                                typeName = String.valueOf(typeName) + ",  ";
                            }
                            typeName = String.valueOf(typeName) + superNames[i];
                            ++count;
                            ++i;
                        }
                    }
                }
            }
            catch (ModelException modelException) {
                typeName = "";
            }
        }
        buf.append(typeName);
        if (ScriptElementLabels.getFlag(flags, 0x100000L)) {
            int parentType;
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                buf.append(CONCAT_STRING);
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8) {
                    buf.append(this.getTypeDelimiter(elem));
                    this.getElementLabel(type.getParent(), 0L, buf);
                }
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8) {
                buf.append(CONCAT_STRING);
                this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
            }
        }
    }

    protected void getFieldLabel(IField field, long flags, StringBuffer buf) {
        IType declaringType;
        Object type;
        if (ScriptElementLabels.getFlag(flags, 65536L) && (type = field.getDeclaringType()) != null) {
            this.getTypeLabel((IType)type, 0x40000L | flags & 0x1002000000000L, buf);
            buf.append(this.getTypeDelimiter((IModelElement)type));
        }
        buf.append(field.getElementName());
        if (ScriptElementLabels.getFlag(flags, 16384L) && field.exists()) {
            try {
                type = field.getType();
                if (type != null) {
                    buf.append(DECL_STRING);
                    buf.append((String)type);
                }
            }
            catch (CoreException e) {
                DLTKCore.error((String)"Failed to append type name to field", (Throwable)e);
            }
        }
        if (ScriptElementLabels.getFlag(flags, 256L) && (declaringType = field.getDeclaringType()) != null) {
            buf.append(CONCAT_STRING);
            this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
        }
    }

    protected void getLocalVariableLabel(ILocalVariable field, long flags, StringBuffer buf) {
        String type;
        buf.append(field.getElementName());
        if (ScriptElementLabels.getFlag(flags, 16384L) && field.exists() && (type = field.getType()) != null) {
            buf.append(DECL_STRING);
            buf.append(type);
        }
    }

    protected void getMethodLabel(IMethod method, long flags, StringBuffer buf) {
        try {
            IType declaringType;
            String type;
            String methodName;
            IType type2;
            if (ScriptElementLabels.getFlag(flags, 128L) && (type2 = method.getDeclaringType()) != null) {
                this.getTypeLabel(type2, 0x40000L | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter((IModelElement)type2));
            }
            if ((methodName = method.getElementName()).length() != 0) {
                buf.append(methodName);
            } else {
                buf.append("function");
            }
            buf.append('(');
            this.getMethodParameters(method, flags, buf);
            buf.append(')');
            if (ScriptElementLabels.getFlag(flags, 32L) && method.exists() && !method.isConstructor() && (type = method.getType()) != null) {
                buf.append(DECL_STRING);
                buf.append(type);
            }
            if (ScriptElementLabels.getFlag(flags, 256L) && (declaringType = method.getDeclaringType()) != null) {
                buf.append(CONCAT_STRING);
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    protected void getMethodParameters(IMethod method, long flags, StringBuffer buf) throws ModelException {
        if (ScriptElementLabels.getFlag(flags, 3L)) {
            if (method.exists()) {
                boolean bNames = ScriptElementLabels.getFlag(flags, 2L);
                boolean bTypes = ScriptElementLabels.getFlag(flags, 1L);
                boolean bInitializers = ScriptElementLabels.getFlag(flags, 0x2000000000000L);
                IParameter[] params = method.getParameters();
                int i = 0;
                int nParams = params.length;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    if (bNames) {
                        buf.append(params[i].getName());
                    }
                    if (bTypes) {
                        if (params[i].getType() != null) {
                            if (bNames) {
                                buf.append(':');
                            }
                            buf.append(params[i].getType());
                        } else if (!bNames) {
                            buf.append(params[i].getName());
                        }
                    }
                    if (bInitializers && params[i].getDefaultValue() != null) {
                        buf.append("=");
                        buf.append(params[i].getDefaultValue());
                    }
                    ++i;
                }
            }
        } else if (method.getParameters().length > 0) {
            buf.append(ELLIPSIS_STRING);
        }
    }

    public void getProjectFragmentLabel(IProjectFragment root, long flags, StringBuffer buf) {
        if (root.isArchive()) {
            this.getArchiveLabel(root, flags, buf);
        } else if (root.isBuiltin()) {
            buf.append(BUILTINS_FRAGMENT);
        } else if (root.isExternal() && !root.isBinary()) {
            this.getExternalFolderLabel(root, flags, buf);
        } else {
            this.getFolderLabel(root, flags, buf);
        }
    }

    protected void getArchiveLabel(IProjectFragment root, long flags, StringBuffer buf) {
        boolean external = root.isExternal();
        if (external) {
            this.getExternalArchiveLabel(root, flags, buf);
        } else {
            this.getInternalArchiveLabel(root, flags, buf);
        }
    }

    protected void getExternalArchiveLabel(IProjectFragment root, long flags, StringBuffer buf) {
        IPath path = root.getPath();
        path = EnvironmentPathUtils.getLocalPath((IPath)path);
        IEnvironment env = EnvironmentManager.getEnvironment((IModelElement)root);
        if (ScriptElementLabels.getFlag(flags, 0x400000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                buf.append(path.segment(segements - 1));
                if (segements > 1 || path.getDevice() != null) {
                    buf.append(CONCAT_STRING);
                    buf.append(env.convertPathToString(path.removeLastSegments(1)));
                }
            } else {
                buf.append(env.convertPathToString(path));
            }
        } else {
            buf.append(env.convertPathToString(path));
        }
    }

    protected boolean isReferenced(IProjectFragment root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject archiveProject = resource.getProject();
            IProject container = root.getScriptProject().getProject();
            return !container.equals((Object)archiveProject);
        }
        return false;
    }

    protected void getInternalArchiveLabel(IProjectFragment root, long flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ScriptElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ScriptElementLabels.getFlag(flags, 0x400000000000L) && this.isReferenced(root);
        if (rootQualified) {
            buf.append(EnvironmentPathUtils.getLocalPath((IPath)root.getPath()).makeRelative().toString());
        } else {
            buf.append(root.getElementName());
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (ScriptElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(EnvironmentPathUtils.getLocalPath((IPath)root.getParent().getPath()).makeRelative().toString());
            }
        }
    }

    protected void getFolderLabel(IProjectFragment root, long flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ScriptElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ScriptElementLabels.getFlag(flags, 0x200000000000L) && resource != null;
        if (rootQualified) {
            buf.append(EnvironmentPathUtils.getLocalPath((IPath)root.getPath()).makeRelative().toString());
        } else {
            if (resource != null) {
                buf.append(resource.getProjectRelativePath().toString());
            } else {
                buf.append(root.getElementName());
            }
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (ScriptElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getElementName());
            }
        }
    }

    protected void getExternalFolderLabel(IProjectFragment root, long flags, StringBuffer buf) {
        boolean rootQualified = ScriptElementLabels.getFlag(flags, 0x20000000000L);
        boolean referencedQualified = ScriptElementLabels.getFlag(flags, 0x200000000000L);
        buf.append(EnvironmentPathUtils.getLocalPathString((IPath)root.getPath()));
        if (!rootQualified) {
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(root.getScriptProject().getElementName());
            } else if (ScriptElementLabels.getFlag(flags, 0x40000000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getElementName());
            }
        }
    }

    public void getScriptFolderLabel(IProjectFragment pack, long flags, StringBuffer buf) {
        if (ScriptElementLabels.getFlag(flags, 0x800000000L)) {
            this.getProjectFragmentLabel((IProjectFragment)pack.getParent(), 0x20000000000L, buf);
            buf.append('/');
        }
        if (pack instanceof ExternalProjectFragment) {
            buf.append(String.valueOf(pack.getElementName().replace('>', '/')) + " ");
        } else if (pack instanceof BuiltinProjectFragment) {
            buf.append("(builtins) ");
        } else if (pack != null) {
            buf.append(String.valueOf(pack.getElementName()) + " ");
        }
        if (ScriptElementLabels.getFlag(flags, 0x1000000000L)) {
            buf.append(CONCAT_STRING);
            this.getProjectFragmentLabel((IProjectFragment)pack.getParent(), 0x20000000000L, buf);
        }
    }

    public String getContainerEntryLabel(IPath containerPath, IScriptProject project) throws ModelException {
        IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)containerPath, (IScriptProject)project);
        if (container != null) {
            return container.getDescription();
        }
        BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer((String)containerPath.segment(0));
        if (initializer != null) {
            return initializer.getDescription(containerPath, project);
        }
        return containerPath.toString();
    }

    public void getDeclarationLabel(IModelElement declaration, long flags, StringBuffer buf) {
        IOpenable openable;
        if (ScriptElementLabels.getFlag(flags, 0x1000000L) && (openable = declaration.getOpenable()) != null) {
            buf.append(this.getElementLabel((IModelElement)openable, 0x88000000L | flags & 0x1002000000000L));
            buf.append('/');
        }
        buf.append(declaration.getElementName());
        if (ScriptElementLabels.getFlag(flags, 0x2000000L) && (openable = declaration.getOpenable()) != null) {
            buf.append(CONCAT_STRING);
            buf.append(this.getElementLabel((IModelElement)openable, 0x88000000L | flags & 0x1002000000000L));
        }
    }

    protected void getImportContainerLabel(IModelElement element, long flags, StringBuffer buf) {
        buf.append(Messages.ScriptElementLabels_import_declarations);
    }

    protected void getImportDeclarationLabel(IModelElement element, long flags, StringBuffer buf) {
        buf.append(element.getElementName());
        IImportDeclaration declaration = (IImportDeclaration)element;
        if (declaration.getVersion() != null && declaration.getVersion().length() != 0) {
            buf.append(" ");
            buf.append(declaration.getVersion());
        }
    }
}

