/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.core.model.IScriptDebugTargetListener;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.ILaunchStatusHandler;
import org.eclipse.dltk.launching.ILaunchStatusHandlerExtension;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.Messages;

public class DebugSessionAcceptor
implements IDbgpThreadAcceptor,
IScriptDebugTargetListener {
    private final ScriptDebugTarget target;
    private IProgressMonitor parentMonitor;
    private boolean initialized = false;
    private boolean connected = false;
    private ILaunchStatusHandler statusHandler = null;
    private static final int WAIT_CHUNK = 1000;
    private IProgressMonitor initializeMonitor = null;

    public DebugSessionAcceptor(ScriptDebugTarget target, IProgressMonitor monitor) {
        this.target = target;
        this.parentMonitor = monitor;
        target.addListener((IScriptDebugTargetListener)this);
        target.getDbgpService().registerAcceptor(target.getSessionId(), (IDbgpThreadAcceptor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetInitialized() {
        DebugSessionAcceptor debugSessionAcceptor = this;
        synchronized (debugSessionAcceptor) {
            this.initialized = true;
            this.notify();
        }
    }

    public void targetTerminating() {
        this.target.getDbgpService().unregisterAcceptor(this.target.getSessionId());
        this.disposeStatusHandler();
    }

    public void disposeStatusHandler() {
        if (this.statusHandler != null) {
            this.statusHandler.dispose();
            this.statusHandler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitConnection(int timeout) throws CoreException {
        block18: {
            sub = new SubProgressMonitor(this.parentMonitor, 1);
            sub.beginTask("", timeout / 1000);
            try {
                sub.setTaskName(Messages.DebugSessionAcceptor_waitConnection);
                start = System.currentTimeMillis();
                try {
                    waitStart = start;
lbl8:
                    // 2 sources

                    while (true) {
                        var7_6 = this;
                        synchronized (var7_6) {
                            if (this.connected) {
                                break;
                            }
                            ** break block19
                        }
                        break;
                    }
                }
                catch (InterruptedException v1) {
                    Thread.currentThread().interrupt();
                    break block18;
                }
            }
            catch (Throwable var9_7) {
                sub.done();
                throw var9_7;
            }
            sub.done();
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.target.isTerminated() || sub.isCanceled()) break block18;
            }
            this.abortIfProcessTerminated();
            var7_6 = this;
            synchronized (var7_6) {
                this.wait(1000L);
            }
            now = System.currentTimeMillis();
            if (timeout == 0 || now - start <= (long)timeout) ** GOTO lbl44
            if (this.statusHandler == null) {
                this.statusHandler = this.createStatusHandler();
            }
            if (!(this.statusHandler instanceof ILaunchStatusHandlerExtension) || !((ILaunchStatusHandlerExtension)this.statusHandler).isCanceled()) ** GOTO lbl-1000
            sub.done();
            return false;
lbl-1000:
            // 1 sources

            {
                this.statusHandler.updateElapsedTime(now - start);
lbl44:
                // 2 sources

                sub.worked((int)((now - waitStart) / 1000L));
                waitStart = now;
                ** continue;
            }
        }
        sub.done();
        return false;
    }

    private void abortIfProcessTerminated() throws CoreException {
        if (this.target.getProcess() != null && this.target.getProcess().isTerminated()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.launching", 112, LaunchingMessages.DebugSessionAcceptor_DebuggerUnexpectedlyTerminated, null));
        }
    }

    private ILaunchStatusHandler createStatusHandler() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.launching.launchStatusHandler");
        int i = 0;
        while (i < elements.length) {
            try {
                ILaunchStatusHandler handler = (ILaunchStatusHandler)elements[i].createExecutableExtension("class");
                handler.initialize((IDebugTarget)this.target, this.parentMonitor);
                return handler;
            }
            catch (Exception e) {
                DLTKLaunchingPlugin.logWarning(e);
                ++i;
            }
        }
        NopLaunchStatusHandler handler = new NopLaunchStatusHandler();
        handler.initialize((IDebugTarget)this.target, this.parentMonitor);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptDbgpThread(IDbgpSession session, IProgressMonitor monitor) {
        boolean isFirst;
        DebugSessionAcceptor debugSessionAcceptor = this;
        synchronized (debugSessionAcceptor) {
            boolean bl = isFirst = !this.connected;
            if (!this.connected) {
                this.connected = true;
                this.notify();
            }
        }
        if (isFirst) {
            IProgressMonitor sub = this.getInitializeMonitor();
            try {
                this.target.getDbgpThreadAcceptor().acceptDbgpThread(session, sub);
            }
            finally {
                sub.done();
            }
        } else {
            this.target.getDbgpThreadAcceptor().acceptDbgpThread(session, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private synchronized IProgressMonitor getInitializeMonitor() {
        if (this.initializeMonitor == null) {
            this.initializeMonitor = new SubProgressMonitor(this.parentMonitor, 1);
            this.initializeMonitor.beginTask("", 100);
            this.initializeMonitor.setTaskName(Messages.DebugSessionAcceptor_waitInitialization);
        }
        return this.initializeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitInitialized(int timeout) throws CoreException {
        IProgressMonitor sub = this.getInitializeMonitor();
        try {
            long now;
            long start = System.currentTimeMillis();
            do {
                DebugSessionAcceptor debugSessionAcceptor;
                try {
                    debugSessionAcceptor = this;
                    synchronized (debugSessionAcceptor) {
                        if (this.initialized) {
                            return true;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    return false;
                }
                if (this.target.isTerminated()) return false;
                if (sub.isCanceled()) {
                    return false;
                }
                this.abortIfProcessTerminated();
                debugSessionAcceptor = this;
                synchronized (debugSessionAcceptor) {
                    this.wait(1000L);
                }
                now = System.currentTimeMillis();
            } while (timeout == 0 || now - start <= (long)timeout);
            return false;
        }
        finally {
            sub.done();
        }
    }

    private static class NopLaunchStatusHandler
    implements ILaunchStatusHandler,
    ILaunchStatusHandlerExtension {
        private NopLaunchStatusHandler() {
        }

        @Override
        public void initialize(IDebugTarget target, IProgressMonitor monitor) {
        }

        @Override
        public void updateElapsedTime(long elapsedTime) {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isCanceled() {
            return true;
        }
    }
}

