/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

public class RParameter
implements IRParameter {
    private final String name;
    private final IRType type;
    private final ParameterKind kind;

    public RParameter(String name, IRType type, ParameterKind kind) {
        Assert.isNotNull((Object)type);
        this.name = name;
        this.type = type;
        this.kind = kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IRType getType() {
        return this.type;
    }

    @Override
    public ParameterKind getKind() {
        return this.kind;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RParameter) {
            RParameter other = (RParameter)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.type.equals(other.type)) {
                return false;
            }
            return this.kind == other.kind;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.type;
    }

    @Override
    public boolean isOptional() {
        return this.kind == ParameterKind.OPTIONAL;
    }

    @Override
    public boolean isVarargs() {
        return this.kind == ParameterKind.VARARGS;
    }
}

