/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.MethodCallExpression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;

public class ShelledSelectionEngine
extends ScriptSelectionEngine {
    private ISourceModule sourceModule;

    public IModelElement[] select(IModuleSource module, final int offset, int i) {
        ArrayList results;
        block2: {
            this.sourceModule = (ISourceModule)module.getModelElement();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)this.sourceModule, null);
            results = new ArrayList();
            try {
                moduleDeclaration.traverse(new ASTVisitor(){

                    public boolean visit(Expression s) throws Exception {
                        if (s.sourceStart() <= offset && offset <= s.sourceEnd()) {
                            if (s instanceof MethodCallExpression) {
                                ShelledSelectionEngine.this.findDeclaration(((MethodCallExpression)s).getName(), results);
                            }
                            if (s instanceof VariableReference) {
                                ShelledSelectionEngine.this.findDeclaration(((VariableReference)s).getName(), results);
                            }
                        }
                        return super.visit(s);
                    }

                    public boolean visit(MethodDeclaration s) throws Exception {
                        if (s.getNameStart() <= offset && offset <= s.getNameEnd()) {
                            ShelledSelectionEngine.this.findDeclaration(s.getName(), results);
                        }
                        return super.visit(s);
                    }
                });
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return results.toArray(new IModelElement[results.size()]);
    }

    private void findDeclaration(final String name, final List<IModelElement> results) {
        block2: {
            try {
                this.sourceModule.accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element.getElementName().equals(name)) {
                            results.add(element);
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }
}

