/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.ParameterData;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowContext;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.dltk.internal.javascript.corext.refactoring.code.flow.VariableBinding;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.FunctionExpression;
import org.eclipse.dltk.javascript.core.dom.Identifier;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Parameter;
import org.eclipse.dltk.javascript.core.dom.ReturnStatement;
import org.eclipse.dltk.javascript.core.dom.Statement;
import org.eclipse.dltk.javascript.core.dom.ThisExpression;
import org.eclipse.dltk.javascript.core.dom.VariableReference;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.core.dom.rewrite.VariableLookup;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class SourceAnalyzer {
    private ISourceModule cu;
    private IMethod method;
    private FunctionExpression declaration;
    private ParameterData[] paramData;
    private int implicitReceiversCount;
    private boolean interruptedFlow;

    public SourceAnalyzer(FunctionExpression declaration, IMethod method) {
        this.cu = method.getSourceModule();
        this.method = method;
        this.declaration = declaration;
    }

    public boolean isExecutionFlowInterrupted() {
        return this.interruptedFlow;
    }

    public RefactoringStatus checkActivation() {
        RefactoringStatus result = new RefactoringStatus();
        ActivationAnalyzer analyzer = new ActivationAnalyzer();
        analyzer.traverse(this.declaration);
        result.merge(analyzer.status);
        return result;
    }

    public void initialize() {
        new UpdateCollector().traverse(this.declaration.getBody());
        Map<Identifier, VariableBinding> bindings = VariableLookup.findBindings(this.declaration);
        FlowContext context = new FlowContext(bindings);
        context.setConsiderAccessMode(true);
        context.setComputeMode(FlowContext.Mode.MERGE);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(context);
        EList<Statement> statements = this.declaration.getBody().getStatements();
        FlowInfo info = flowAnalyzer.perform(statements.toArray((Node[])new Node[statements.size()]));
        this.paramData = new ParameterData[this.declaration.getParameters().size()];
        int i = 0;
        HashMap<VariableBinding, ParameterData> datas = new HashMap<VariableBinding, ParameterData>();
        for (Parameter element : this.declaration.getParameters()) {
            VariableBinding binding = bindings.get(element.getName());
            int n = i++;
            ParameterData parameterData = new ParameterData(element.getName());
            this.paramData[n] = parameterData;
            ParameterData data = parameterData;
            data.setAccessMode(info.getAccessMode(context, binding));
            datas.put(binding, data);
        }
        for (Map.Entry<Identifier, VariableBinding> entry : bindings.entrySet()) {
            ParameterData data;
            Identifier key = entry.getKey();
            VariableBinding value = entry.getValue();
            if (value.getDeclaration() == key || (data = (ParameterData)datas.get(value)) == null) continue;
            data.addReference(key);
            if (key.eContainer().eContainmentFeature() != DomPackage.eINSTANCE.getCallExpression_Applicant()) continue;
            data.setFunction(true);
        }
    }

    public String getCode() throws ModelException {
        return this.cu.getSource();
    }

    public int getImplicitReceiversCount() {
        return this.implicitReceiversCount;
    }

    public ParameterData getParameterData(int index) {
        return this.paramData[index];
    }

    public ISourceModule getSourceModule() {
        return this.cu;
    }

    private class ActivationAnalyzer
    extends DomSwitch<Boolean> {
        public RefactoringStatus status = new RefactoringStatus();
        private Node fLastNode = this.getLastNode();

        private ActivationAnalyzer() {
        }

        public void traverse(Node node) {
            TreeIterator it = node.eAllContents();
            while (it.hasNext()) {
                if (this.doSwitch((EObject)it.next()) == null) continue;
                it.prune();
            }
        }

        @Override
        public Boolean caseReturnStatement(ReturnStatement node) {
            if (node != this.fLastNode) {
                SourceAnalyzer.this.interruptedFlow = true;
            }
            return null;
        }

        @Override
        public Boolean caseFunctionExpression(FunctionExpression node) {
            return false;
        }

        @Override
        public Boolean caseVariableReference(VariableReference node) {
            IModelElement[] elems;
            try {
                elems = SourceAnalyzer.this.cu.codeSelect(node.getBegin(), node.getEnd() - node.getBegin());
            }
            catch (ModelException modelException) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors);
                return false;
            }
            IModelElement[] iModelElementArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement elem = iModelElementArray[n2];
                if (elem.equals(SourceAnalyzer.this.method)) {
                    this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_recursive_call);
                    return false;
                }
                ++n2;
            }
            return false;
        }

        private Node getLastNode() {
            EList<Statement> statements = SourceAnalyzer.this.declaration.getBody().getStatements();
            if (statements.size() == 0) {
                return null;
            }
            return (Node)statements.get(statements.size() - 1);
        }
    }

    private class UpdateCollector
    extends DomSwitch<Boolean> {
        private UpdateCollector() {
        }

        void traverse(Node node) {
            TreeIterator it = node.eAllContents();
            while (it.hasNext()) {
                if (this.doSwitch((EObject)it.next()) == null) continue;
                it.prune();
            }
        }

        @Override
        public Boolean caseFunctionExpression(FunctionExpression node) {
            return true;
        }

        @Override
        public Boolean caseCallExpression(CallExpression node) {
            Expression receiver = RefactoringUtils.getReceiver(node);
            if (receiver == null) {
                SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
                sourceAnalyzer.implicitReceiversCount = sourceAnalyzer.implicitReceiversCount + 1;
            }
            return null;
        }

        @Override
        public Boolean caseThisExpression(ThisExpression node) {
            SourceAnalyzer sourceAnalyzer = SourceAnalyzer.this;
            sourceAnalyzer.implicitReceiversCount = sourceAnalyzer.implicitReceiversCount + 1;
            return true;
        }
    }
}

