/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProcessor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    private static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String AUTOACTIVATION_TRIGGERS = "content_assist_autoactivation_triggers_script";
    private static final String SHOW_VISIBLE_PROPOSALS = "content_assist_show_visible_proposals";
    private static final String CASE_SENSITIVITY = "content_assist_case_sensitivity";
    private static final String FILL_METHOD_ARGUMENTS = "content_assist_fill_method_arguments";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    protected abstract ScriptTextTools getTextTools();

    private Color getColor(IPreferenceStore store, String key) {
        ScriptTextTools textTools = this.getTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private ScriptCompletionProcessor getScriptProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof ScriptCompletionProcessor) {
            return (ScriptCompletionProcessor)p;
        }
        return null;
    }

    private void configureScriptProcessor(ContentAssistant assistant, IPreferenceStore store) {
        ScriptCompletionProcessor jcp = this.getScriptProcessor(assistant);
        if (jcp == null) {
            return;
        }
        String triggers = store.getString(AUTOACTIVATION_TRIGGERS);
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean(SHOW_VISIBLE_PROPOSALS);
        jcp.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean(CASE_SENSITIVITY);
        jcp.restrictProposalsToMatchingCases(enabled);
    }

    public void configure(ContentAssistant assistant, IPreferenceStore store) {
        ScriptTextTools textTools = this.getTextTools();
        IColorManager manager = textTools.getColorManager();
        boolean enabled = store.getBoolean(AUTOACTIVATION);
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c);
        assistant.setContextSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c);
        assistant.setContextSelectorBackground(c);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
        this.configureScriptProcessor(assistant, store);
    }

    private void changeScriptProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        ScriptCompletionProcessor jcp = this.getScriptProcessor(assistant);
        if (jcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS.equals(key)) {
            String triggers = store.getString(AUTOACTIVATION_TRIGGERS);
            if (triggers != null) {
                jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
            }
        } else if (SHOW_VISIBLE_PROPOSALS.equals(key)) {
            boolean enabled = store.getBoolean(SHOW_VISIBLE_PROPOSALS);
            jcp.restrictProposalsToVisibility(enabled);
        } else if (CASE_SENSITIVITY.equals(key)) {
            boolean enabled = store.getBoolean(CASE_SENSITIVITY);
            jcp.restrictProposalsToMatchingCases(enabled);
        }
    }

    public void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION.equals(p)) {
            boolean enabled = store.getBoolean(AUTOACTIVATION);
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = this.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = this.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = this.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = this.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        } else if (PREFIX_COMPLETION.equals(p)) {
            boolean enabled = store.getBoolean(PREFIX_COMPLETION);
            assistant.enablePrefixCompletion(enabled);
        }
        this.changeScriptProcessor(assistant, store, p);
    }

    public boolean fillArgumentsOnMethodCompletion(IPreferenceStore store) {
        return store.getBoolean(FILL_METHOD_ARGUMENTS);
    }
}

