/*******************************************************************************
 * Copyright (c) 2005, 2016 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/
package org.eclipse.dltk.python.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;

/**
 * While statement.
 */
public class WhileStatement extends Statement {
	private Statement fCondition;
	private Statement fAction;

	public WhileStatement(DLTKToken token) {
		super(token);
	}

	public WhileStatement(DLTKToken whileToken, Expression condition,
			Statement action) {
		this.setStart(whileToken.getColumn());
		this.setEnd(action.sourceEnd());
		this.fCondition = condition;
		this.fAction = action;
	}

	public WhileStatement(Statement condition, Statement action) {
		this.fCondition = condition;
		this.fAction = action;
	}

	@Override
	public void traverse(ASTVisitor pVisitor) throws Exception {
		if (pVisitor.visit(this)) {
			if (fCondition != null) {
				fCondition.traverse(pVisitor);
			}
			if (fAction != null) {
				fAction.traverse(pVisitor);
			}
			pVisitor.endvisit(this);
		}
	}

	@Override
	public int getKind() {
		return S_WHILE;
	}

	public Statement getCondition() {
		return fCondition;
	}

	public Statement getAction() {
		return fAction;
	}

	@Override
	public void printNode(CorePrinter output) {
		output.formatPrintLn("while");
		if (this.fCondition != null) {
			this.fCondition.printNode(output);
		}
		if (this.fAction != null) {
			output.indent();
			this.fAction.printNode(output);
			output.dedent();
		}
		output.formatPrint("");
	}
}
