/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.dltk.javascript.internal.ui.text.TypeNameNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;

public class JSDocTextUtils {
    public static IRegion getLineRegion(IDocument document, int offset) throws BadLocationException {
        IRegion region = document.getLineInformationOfOffset(offset);
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"__javascript_partitioning", (int)offset, (boolean)false);
        if (partition.getOffset() > region.getOffset() || partition.getOffset() + partition.getLength() < region.getOffset() + region.getLength()) {
            int newOffset = Math.max(partition.getOffset(), region.getOffset());
            int newEnd = Math.min(partition.getOffset() + partition.getLength(), region.getOffset() + region.getLength());
            return new Region(newOffset, newEnd - newOffset);
        }
        return region;
    }

    public static TypeNameNode getTag(char[] line, int begin, int end) {
        int index = begin;
        while (index < end && Character.isWhitespace(line[index])) {
            ++index;
        }
        if (index < end && line[index] == '/') {
            ++index;
        }
        while (index < end && line[index] == '*') {
            ++index;
        }
        while (index < end && Character.isWhitespace(line[index])) {
            ++index;
        }
        if (index < end && line[index] == '@') {
            int tagStart = index++;
            if (index < end && Character.isJavaIdentifierStart(line[index])) {
                ++index;
                while (index < end && (Character.isJavaIdentifierPart(line[index]) || line[index] == '.' || line[index] == '-')) {
                    ++index;
                }
            }
            return new TypeNameNode(new String(line, tagStart, index - tagStart), tagStart, index);
        }
        return null;
    }
}

