/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import java.io.Reader;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.javascript.scriptdoc.BufferJavaDocCommentReader;
import org.eclipse.dltk.javascript.scriptdoc.JSDocContentAccess;
import org.eclipse.dltk.javascript.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.dltk.javascript.scriptdoc.JavaDocCommentReader;
import org.eclipse.dltk.javascript.scriptdoc.StringJavaDocCommentReader;

public class ScriptdocContentAccess {
    private ScriptdocContentAccess() {
    }

    public static ISourceRange getJavadocRange(IMember member) throws ModelException {
        return JSDocContentAccess.getDocRange((IMember)member);
    }

    public static JavaDocCommentReader getReader(IOpenable openable, ISourceRange docRange) throws ModelException {
        IBuffer buf = openable.getBuffer();
        if (buf != null) {
            return new BufferJavaDocCommentReader(buf, docRange.getOffset(), docRange.getOffset() + docRange.getLength());
        }
        if (openable instanceof ISourceModule) {
            ISourceModule module = (ISourceModule)openable;
            return new StringJavaDocCommentReader(module.getSource().substring(docRange.getOffset(), docRange.getOffset() + docRange.getLength()));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Reader getContentReader(IMember member, boolean allowInherited) throws ModelException {
        IOpenable openable = member.getOpenable();
        if (openable == null) return null;
        try {
            ISourceRange javadocRange = ScriptdocContentAccess.getJavadocRange(member);
            if (javadocRange != null) {
                JavaDocCommentReader reader = ScriptdocContentAccess.getReader(openable, javadocRange);
                if (reader == null) {
                    return null;
                }
                if (!reader.containsOnlyInheritDoc()) {
                    reader.reset();
                    return reader;
                }
            }
            if (!allowInherited) return null;
            if (member.getElementType() != 9) return null;
            return ScriptdocContentAccess.findDocInHierarchy((IMethod)member);
        }
        catch (ModelException e) {
            return null;
        }
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws ModelException {
        Reader contentReader = ScriptdocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        IOpenable openable = member.getOpenable();
        if (useAttachedJavadoc && openable != null) {
            openable.getBuffer();
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited) throws ModelException {
        return ScriptdocContentAccess.getHTMLContentReader(member, allowInherited, false);
    }

    private static Reader findDocInHierarchy(IMethod method) throws ModelException {
        return null;
    }
}

