/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.javascript.internal.corext.codemanipulation.AddJavaDocStubOperation;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ElementValidator;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class AddJavaDocStubAction
extends SelectionDispatchAction {
    private ScriptEditor fEditor;

    public AddJavaDocStubAction(IWorkbenchSite site) {
        super(site);
        this.setText("Generate Element Commen&t");
        this.setDescription("Add a comment stub to the member element");
        this.setToolTipText("Add a Comment Stub to the Member Element");
    }

    public AddJavaDocStubAction(ScriptEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        this.setEnabled(members != null && members.length > 0);
    }

    public void run(IStructuredSelection selection) {
        IMember[] members = this.getSelectedMembers(selection);
        if (members == null || members.length == 0) {
            return;
        }
        try {
            ISourceModule cu = members[0].getSourceModule();
            if (!ActionUtil.isEditable((Shell)this.getShell(), (IModelElement)cu)) {
                return;
            }
            IEditorPart editor = DLTKUIPlugin.openInEditor((IModelElement)cu);
            if (ElementValidator.check((IModelElement[])members, (Shell)this.getShell(), (String)this.getDialogTitle(), (boolean)false)) {
                this.run(members);
            }
            ScriptModelUtil.reconcile((ISourceModule)cu);
            EditorUtility.revealInEditor((IEditorPart)editor, (IModelElement)members[0]);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)"Error while adding comment");
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn((IEditorPart)this.fEditor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ITextSelection selection) {
        try {
            int type;
            IModelElement element = SelectionConverter.getElementAtOffset((IEditorPart)this.fEditor);
            if (!ActionUtil.isEditable((ITextEditor)this.fEditor, (Shell)this.getShell(), (IModelElement)element)) {
                return;
            }
            while (true) {
                if (!(element instanceof IType) && !(element instanceof IMethod) || element.getElementName().length() != 0) {
                    int n = type = element != null ? element.getElementType() : -1;
                }
                element = element.getParent();
            }
            if (type != 9 && type != 7 && type != 8 && (element = SelectionConverter.getTypeAtOffset((IEditorPart)this.fEditor)) == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)"The operation is not applicable to the current selection. Select a type or method.");
                return;
            }
            IMember[] members = new IMember[]{(IMember)element};
            if (!ElementValidator.checkValidateEdit((IModelElement[])members, (Shell)this.getShell(), (String)this.getDialogTitle())) return;
            this.run(members);
            return;
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)"Error while adding comment");
        }
    }

    private void run(IMember[] members) {
        AddJavaDocStubOperation op = new AddJavaDocStubOperation(members);
        if (members.length < 11) {
            try {
                op.run(null);
            }
            catch (CoreException e) {
                ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)"Error while adding comment");
            }
            catch (OperationCanceledException e) {
                // empty catch block
            }
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)op, op.getScheduleRule()), op.getScheduleRule());
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)"Error while adding comment");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IMember[] getSelectedMembers(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IMember[] res = new IMember[nElements];
            ISourceModule cu = null;
            int i = 0;
            while (i < nElements) {
                IMember member;
                Object curr = elements.get(i);
                if (curr instanceof IMethod || curr instanceof IType || curr instanceof IField) {
                    member = (IMember)curr;
                    if (!member.exists()) {
                        return null;
                    }
                    if (i == 0 ? (cu = member.getSourceModule()) == null : !cu.equals(member.getSourceModule())) {
                        return null;
                    }
                    if ((member instanceof IType || member instanceof IMethod) && member.getElementName().length() == 0) {
                        return null;
                    }
                } else {
                    return null;
                }
                res[i] = member;
                ++i;
            }
            return res;
        }
        return null;
    }

    private String getDialogTitle() {
        return "Generate Element Comment";
    }
}

