/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.ErrorDialogWithToggle;
import org.eclipse.dltk.internal.debug.ui.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class HotCodeReplaceErrorDialog
extends ErrorDialogWithToggle {
    protected IDebugTarget target;
    protected int TERMINATE_ID = 14;
    protected int DISCONNECT_ID = this.TERMINATE_ID + 1;
    protected int RESTART_ID = this.TERMINATE_ID + 2;

    public HotCodeReplaceErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, String preferenceKey, String toggleMessage, IPreferenceStore store, IDebugTarget target) {
        super(parentShell, dialogTitle, message, status, preferenceKey, toggleMessage, store);
        this.target = target;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(Messages.HotCodeReplaceErrorDialog_continue);
        boolean canTerminate = this.target.canTerminate();
        boolean canDisconnect = this.target.canDisconnect();
        if (canTerminate) {
            this.createButton(parent, this.TERMINATE_ID, Messages.HotCodeReplaceErrorDialog_terminate, false);
        }
        if (canDisconnect) {
            this.createButton(parent, this.DISCONNECT_ID, Messages.HotCodeReplaceErrorDialog_disconnect, false);
        }
        if (canTerminate && !canDisconnect) {
            this.createButton(parent, this.RESTART_ID, Messages.HotCodeReplaceErrorDialog_restart, false);
        }
    }

    @Override
    protected void buttonPressed(int id) {
        if (id == this.TERMINATE_ID || id == this.DISCONNECT_ID || id == this.RESTART_ID) {
            DebugException[] ex = new DebugException[1];
            Object[] operation = new String[1];
            ex[0] = null;
            Runnable r = () -> this.lambda$0(id, (String[])operation, ex);
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
            if (ex[0] != null) {
                DLTKDebugUIPlugin.errorDialog(NLS.bind((String)Messages.HotCodeReplaceErrorDialog_failed, (Object[])operation), ex[0].getStatus());
            }
            this.okPressed();
        } else {
            super.buttonPressed(id);
        }
    }

    private /* synthetic */ void lambda$0(int n, String[] stringArray, DebugException[] debugExceptionArray) {
        try {
            if (n == this.TERMINATE_ID) {
                stringArray[0] = Messages.HotCodeReplaceErrorDialog_terminate2;
                this.target.terminate();
            } else if (n == this.DISCONNECT_ID) {
                stringArray[0] = Messages.HotCodeReplaceErrorDialog_disconnect2;
                this.target.disconnect();
            } else {
                stringArray[0] = Messages.HotCodeReplaceErrorDialog_restart2;
                ILaunch launch = this.target.getLaunch();
                launch.terminate();
                ILaunchConfiguration config = launch.getLaunchConfiguration();
                if (config != null && config.exists()) {
                    DebugUITools.launch((ILaunchConfiguration)config, (String)launch.getLaunchMode());
                }
            }
        }
        catch (DebugException e) {
            debugExceptionArray[0] = e;
        }
    }
}

