/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterEnvironmentVariablesBlock;
import org.eclipse.dltk.internal.debug.ui.interpreters.AddScriptInterpreterDialog;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class TclInterpreterEnvironmentVariablesBlock
extends AbstractInterpreterEnvironmentVariablesBlock {
    public TclInterpreterEnvironmentVariablesBlock(AddScriptInterpreterDialog d) {
        super(d);
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)super.getLabelProvider(), (ILabelDecorator)new EnvironmentVariableDecorator());
    }

    private class EnvironmentVariableDecorator
    extends BaseLabelProvider
    implements ILabelDecorator {
        private final ImageDescriptorRegistry registry = new ImageDescriptorRegistry(false);

        private EnvironmentVariableDecorator() {
        }

        public Image decorateImage(Image image, Object element) {
            EnvironmentVariable env;
            if (!(!(element instanceof EnvironmentVariable) || this.isSafe(env = (EnvironmentVariable)element) && env.validate().isOK())) {
                return this.registry.get((ImageDescriptor)new DecorationOverlayIcon(image, DLTKPluginImages.DESC_OVR_WARNING, 2));
            }
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        public void dispose() {
            super.dispose();
            this.registry.dispose();
        }

        private boolean isSafe(EnvironmentVariable env) {
            IExecutionEnvironment execEnvironment;
            IEnvironment environment = TclInterpreterEnvironmentVariablesBlock.this.getEnvironment();
            if (environment != null && (execEnvironment = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class)) != null) {
                return execEnvironment.isSafeEnvironmentVariable(env.getName());
            }
            return true;
        }
    }
}

