/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.index.sql.h2.H2Index;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class Schema {
    public static final String VERSION = "0.8.1";
    private static final Set<String> TABLES_CACHE = new HashSet<String>();

    public void initialize(Connection connection) throws SQLException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(Schema.readSqlFile("resources/basic.sql"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.storeSchemaVersion(VERSION);
        }
        catch (SQLException e) {
            H2Index.error("An exception was thrown while initializing schema", e);
            throw e;
        }
    }

    public String getTableName(int elementType, String natureId, boolean isReference) {
        StringBuilder tableName = new StringBuilder();
        if (isReference) {
            tableName.append("R_");
        } else {
            tableName.append("D_");
        }
        tableName.append(natureId.toUpperCase().replace('.', '_')).append('_').append(elementType);
        return tableName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable(Connection connection, String tableName, boolean isReference) throws SQLException {
        Set<String> set = TABLES_CACHE;
        synchronized (set) {
            if (TABLES_CACHE.add(tableName)) {
                String query = isReference ? Schema.readSqlFile("resources/element_ref.sql") : Schema.readSqlFile("resources/element_decl.sql");
                query = NLS.bind((String)query, (Object)tableName);
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (Statement statement = connection.createStatement();){
                        statement.executeUpdate(query);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    H2Index.error("An exception was thrown while creating elements table", e);
                    throw e;
                }
            }
        }
    }

    public boolean isCompatible() {
        String storedVersion = this.getStoredSchemaVersion();
        return storedVersion != null && VERSION.equals(storedVersion);
    }

    private String getStoredSchemaVersion() {
        return Platform.getPreferencesService().getString("org.eclipse.dltk.core.index.sql.h2", "schemaVersion", null, null);
    }

    private void storeSchemaVersion(String newVersion) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.dltk.core.index.sql.h2");
        node.put("schemaVersion", newVersion);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    static String readSqlFile(String sqlFile) {
        try {
            URL url = FileLocator.find((Bundle)H2Index.getDefault().getBundle(), (IPath)new Path(sqlFile), null);
            URL resolved = FileLocator.resolve((URL)url);
            StringBuilder buf = new StringBuilder();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(resolved.openStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    buf.append(line).append('\n');
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return buf.toString();
        }
        catch (IOException e) {
            H2Index.error("An exception is thrown while reading file: " + sqlFile, e);
            return null;
        }
    }
}

