/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;

public class PropertyExpression
extends Expression
implements Documentable {
    private Expression object;
    private Expression property;
    private int dot = -1;
    private Comment documentation;

    public PropertyExpression(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.object != null) {
                this.object.traverse(visitor);
            }
            if (this.property != null) {
                this.property.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getObject() {
        return this.object;
    }

    public void setObject(Expression object) {
        this.object = object;
    }

    public Expression getProperty() {
        return this.property;
    }

    public void setProperty(Expression property) {
        this.property = property;
    }

    public int getDotPosition() {
        return this.dot;
    }

    public void setDotPosition(int dot) {
        this.dot = dot;
    }

    @Override
    public void setDocumentation(Comment documentation) {
        this.documentation = documentation;
    }

    @Override
    public Comment getDocumentation() {
        return this.documentation;
    }

    @Override
    public String toSourceString(String indentationString) {
        return String.valueOf(PropertyExpression.toSourceString(this.object, indentationString)) + '.' + PropertyExpression.toSourceString(this.property, indentationString);
    }

    public List<Expression> getPath() {
        ArrayList<Expression> path = new ArrayList<Expression>();
        PropertyExpression.addToPath(this.object, path);
        path.add(this.property);
        return path;
    }

    private static void addToPath(Expression object, List<Expression> path) {
        if (object instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)object;
            PropertyExpression.addToPath(pe.object, path);
            path.add(pe.property);
        } else {
            path.add(object);
        }
    }
}

