/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.SimpleDLTKExtensionManager;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationCommand;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.ui.DLTKDebugUILanguageManager;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.debug.ui.DetailFormatter;
import org.eclipse.dltk.internal.debug.ui.Messages;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ScriptDetailFormattersManager
implements IPropertyChangeListener {
    private static final String DEFAULT_FORMATTER_TYPE = "#DEFAULT#";
    private static final String ATTR_SNIPPET = "snippet";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NATURE = "nature";
    private static final String SCRIPT_DETAIL_FORMATTER_EXTENSION = "org.eclipse.dltk.debug.ui.scriptDetailFormatter";
    private static HashMap managerInstances = new HashMap();
    private static final String CANNOT_EVALUATE = Messages.ScriptDetailFormattersManager_cantEvaluateDetails;
    private HashMap formatters = new HashMap();
    private DetailFormatter defaultFormatter = null;

    public static ScriptDetailFormattersManager getDefault(String natureId) {
        ScriptDetailFormattersManager instance = (ScriptDetailFormattersManager)managerInstances.get(natureId);
        if (instance == null) {
            instance = new ScriptDetailFormattersManager(natureId);
            managerInstances.put(natureId, instance);
        }
        return instance;
    }

    private ScriptDetailFormattersManager(String natureId) {
        this.populateDetailFormatters(natureId);
        DLTKDebugUILanguageManager.getLanguageToolkit(natureId).getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void populateDetailFormatters(String natureId) {
        SimpleDLTKExtensionManager manager = new SimpleDLTKExtensionManager(SCRIPT_DETAIL_FORMATTER_EXTENSION);
        SimpleDLTKExtensionManager.ElementInfo[] infos = manager.getElementInfos();
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement config = infos[i].getConfig();
            String nature = config.getAttribute(ATTR_NATURE);
            if (natureId.equals(nature)) {
                String code = config.getAttribute(ATTR_SNIPPET);
                String type = config.getAttribute(ATTR_TYPE);
                DetailFormatter formatter = new DetailFormatter(type, code, true);
                if (DEFAULT_FORMATTER_TYPE.equals(type)) {
                    this.setDefaultFormatter(formatter);
                } else {
                    this.addFormatter(formatter);
                }
            }
            ++i;
        }
    }

    private String getValueText(IValue value) {
        if (value instanceof IScriptValue) {
            ScriptDebugModelPresentation presentation = DLTKDebugUIPlugin.getDefault().getModelPresentation(value.getModelIdentifier());
            return presentation.getDetailPaneText((IScriptValue)value);
        }
        return null;
    }

    public void computeValueDetail(final IScriptValue value, IScriptThread thread, final IValueDetailListener listener) {
        if (thread == null || !thread.isSuspended()) {
            listener.detailComputed((IValue)value, this.getValueText((IValue)value));
            return;
        }
        DetailFormatter formatter = this.getDetailFormatter(value);
        if (formatter == null || !formatter.isEnabled()) {
            listener.detailComputed((IValue)value, this.getValueText((IValue)value));
            return;
        }
        IScriptEvaluationCommand command = value.createEvaluationCommand(formatter.getSnippet(), thread);
        if (command == null) {
            listener.detailComputed((IValue)value, this.getValueText((IValue)value));
            return;
        }
        command.asyncEvaluate(new IScriptEvaluationListener(){

            public void evaluationComplete(IScriptEvaluationResult result) {
                if (result == null) {
                    return;
                }
                IScriptValue resultValue = result.getValue();
                if (resultValue != null) {
                    listener.detailComputed((IValue)value, ScriptDetailFormattersManager.this.getValueText((IValue)resultValue));
                } else {
                    try {
                        listener.detailComputed((IValue)value, value.getValueString());
                    }
                    catch (DebugException e) {
                        if (DLTKCore.DEBUG) {
                            e.printStackTrace();
                        }
                        listener.detailComputed((IValue)value, CANNOT_EVALUATE);
                    }
                }
            }
        });
    }

    public DetailFormatter getDetailFormatter(IScriptValue value) {
        DetailFormatter formatter = (DetailFormatter)this.formatters.get(value.getType().getName());
        if (formatter == null) {
            formatter = this.getDefaultFormatter();
        }
        return formatter;
    }

    private DetailFormatter getDefaultFormatter() {
        return this.defaultFormatter;
    }

    public void setDefaultFormatter(DetailFormatter formatter) {
        this.defaultFormatter = formatter;
    }

    public void addFormatter(DetailFormatter formatter) {
        this.formatters.put(formatter.getTypeName(), formatter);
    }

    public void removeFormatter(DetailFormatter formatter) {
        this.formatters.remove(formatter.getTypeName());
    }

    public void propertyChange(PropertyChangeEvent event) {
        IScriptStackFrame frame;
        IAdaptable selected;
        String property = event.getProperty();
        if (this.handlesPropertyEvent(property) && (selected = DebugUITools.getDebugContext()) != null && (frame = (IScriptStackFrame)selected.getAdapter(IScriptStackFrame.class)) != null) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)frame, 16)});
        }
    }

    private boolean handlesPropertyEvent(String property) {
        if ("org.eclipse.dltk.debug.ui.show_details".equals(property)) {
            return true;
        }
        return "org.eclipse.debug.ui.max_detail_length".equals(property);
    }
}

